/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.utils;

import com.amazonaws.services.schemaregistry.common.AWSSchemaRegistryClient;
import com.amazonaws.services.schemaregistry.exception.AWSSchemaRegistryException;
import com.amazonaws.services.schemaregistry.serializers.avro.User;
import com.amazonaws.services.schemaregistry.utils.AVROUtils;
import com.amazonaws.services.schemaregistry.utils.Customer;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class AVROUtilsTest {
    private AWSSchemaRegistryClient mockClient;
    private final Map<String, Object> configs = new HashMap<String, Object>();
    private Schema schema = null;
    private User userDefinedPojo;
    private GenericRecord genericRecord;
    private Customer customer;

    @BeforeEach
    public void setup() {
        this.mockClient = (AWSSchemaRegistryClient)Mockito.mock(AWSSchemaRegistryClient.class);
        this.customer = new Customer();
        this.customer.setName("test");
        Schema.Parser parser = new Schema.Parser();
        try {
            this.schema = parser.parse(new File("src/test/java/resources/avro/user.avsc"));
        }
        catch (IOException e) {
            Assertions.fail((String)"Catch IOException: ", (Throwable)e);
        }
        this.userDefinedPojo = User.newBuilder().setName("test_avros_schema").setFavoriteColor("violet").setFavoriteNumber(10).build();
        this.genericRecord = new GenericData.Record(this.schema);
        this.genericRecord.put("name", (Object)"sansa");
        this.genericRecord.put("favorite_number", (Object)99);
        this.genericRecord.put("favorite_color", (Object)"red");
        this.configs.put("endpoint", "https://mjguu1u07a.execute-api.us-west-2.amazonaws.com/beta");
        this.configs.put("region", "us-west-2");
        this.configs.put("compression", "NONE");
    }

    @Test
    public void testGetSchemaDefinition_pojo_schemaDefinitionMatches() {
        String schema = "{\"type\":\"record\",\"name\":\"User\",\"namespace\":\"com.amazonaws.services.schemaregistry.serializers.avro\",\"fields\":[{\"name\":\"name\",\"type\":\"string\"},{\"name\":\"favorite_number\",\"type\":[\"int\",\"null\"]},{\"name\":\"favorite_color\",\"type\":[\"string\",\"null\"]}]}";
        Assertions.assertEquals((Object)schema, (Object)AVROUtils.getInstance().getSchemaDefinition((Object)this.userDefinedPojo));
    }

    @Test
    public void testGetSchemaDefinition_parseSchema_schemaDefinitionMatches() {
        String schema = "{\"type\":\"record\",\"name\":\"User\",\"namespace\":\"com.amazonaws.services.schemaregistry.serializers.avro\",\"fields\":[{\"name\":\"name\",\"type\":\"string\"},{\"name\":\"favorite_number\",\"type\":[\"int\",\"null\"]},{\"name\":\"favorite_color\",\"type\":[\"string\",\"null\"]}]}";
        Assertions.assertEquals((Object)schema, (Object)AVROUtils.getInstance().getSchemaDefinition((Object)this.genericRecord));
    }

    @Test
    public void testGetSchemaDefinition_nonAVROSchema_throwsException() {
        Assertions.assertThrows(AWSSchemaRegistryException.class, () -> Assertions.assertNull((Object)AVROUtils.getInstance().getSchemaDefinition((Object)this.customer)));
    }

    @Test
    public void testGetSchemaDefinition_nullObject_throwsException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> AVROUtils.getInstance().getSchemaDefinition(null));
    }

    @Test
    public void testGetSchema_nullObject_throwsException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> AVROUtils.getInstance().getSchema(null));
    }
}

