/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.deserializers.avro;

import com.amazonaws.services.schemaregistry.exception.AWSSchemaRegistryException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecondaryDeserializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecondaryDeserializer.class);
    private Class<?> clz;
    private Object obj;

    private SecondaryDeserializer() {
    }

    public static SecondaryDeserializer newInstance() {
        return new SecondaryDeserializer();
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        try {
            Method secConfigure = this.clz.getMethod("configure", Map.class, Boolean.TYPE);
            secConfigure.invoke(this.obj, configs, isKey);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            String message = "Can't find method called configure or invoke it.";
            throw new AWSSchemaRegistryException(message, (Throwable)e);
        }
    }

    public boolean validate(Map<String, ?> configs) {
        Object className = configs.get("secondaryDeserializer");
        String secDeserializer = String.valueOf(className);
        try {
            this.clz = Class.forName(secDeserializer);
            this.obj = this.clz.newInstance();
            return Arrays.asList(this.clz.getInterfaces()).contains(Class.forName("org.apache.kafka.common.serialization.Deserializer"));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            String message = "Can't find the class or instantiate it.";
            throw new AWSSchemaRegistryException(message, (Throwable)e);
        }
    }

    public Object deserialize(String topic, byte[] data) {
        if (this.obj == null) {
            throw new AWSSchemaRegistryException("Didn't find secondary deserializer.");
        }
        try {
            Method secDeserialize = this.clz.getMethod("deserialize", String.class, byte[].class);
            return secDeserialize.invoke(this.obj, topic, data);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            String message = "Can't find method called deserialize or invoke it.";
            throw new AWSSchemaRegistryException(message, (Throwable)e);
        }
    }

    public void close() {
        if (this.obj == null) {
            throw new AWSSchemaRegistryException("Didn't find secondary deserializer.");
        }
        try {
            Method close = this.clz.getMethod("close", new Class[0]);
            close.invoke(this.obj, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            String message = "Can't find method called close or invoke it.";
            throw new AWSSchemaRegistryException(message, (Throwable)e);
        }
    }
}

