/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.serializers.avro;

import com.amazonaws.services.schemaregistry.common.AWSSchemaNamingStrategy;
import com.amazonaws.services.schemaregistry.common.AWSSerializerInput;
import com.amazonaws.services.schemaregistry.serializers.avro.AWSAvroSerializer;
import com.amazonaws.services.schemaregistry.utils.AVROUtils;
import com.amazonaws.services.schemaregistry.utils.AWSSchemaRegistryUtils;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;

public class AWSKafkaAvroSerializer
implements Serializer<Object> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AWSKafkaAvroSerializer.class);
    private AWSAvroSerializer avroSerializer;
    private final AwsCredentialsProvider credentialProvider;
    private final UUID schemaVersionId;
    private String schemaName;
    private AWSSchemaNamingStrategy schemaNamingStrategy;

    public AWSKafkaAvroSerializer() {
        this((AwsCredentialsProvider)DefaultCredentialsProvider.builder().build(), null, null);
    }

    public AWSKafkaAvroSerializer(Map<String, ?> configs) {
        this((AwsCredentialsProvider)DefaultCredentialsProvider.builder().build(), null, configs);
    }

    public AWSKafkaAvroSerializer(AwsCredentialsProvider credentialProvider, Map<String, ?> configs) {
        this(credentialProvider, null, configs);
    }

    public AWSKafkaAvroSerializer(@NonNull Map<String, ?> configs, UUID schemaVersionId) {
        this((AwsCredentialsProvider)DefaultCredentialsProvider.builder().build(), schemaVersionId, configs);
        if (configs == null) {
            throw new IllegalArgumentException("configs is marked @NonNull but is null");
        }
    }

    public AWSKafkaAvroSerializer(AwsCredentialsProvider credentialProvider, UUID schemaVersionId, Map<String, ?> configs) {
        this.credentialProvider = credentialProvider == null ? DefaultCredentialsProvider.builder().build() : credentialProvider;
        this.schemaVersionId = schemaVersionId;
        if (configs != null) {
            this.configure(configs, false);
        }
    }

    public void configure(@NonNull Map<String, ?> configs, boolean isKey) {
        if (configs == null) {
            throw new IllegalArgumentException("configs is marked @NonNull but is null");
        }
        log.info("Configuring Amazon Glue Schema Registry Service using these properties: {}", configs);
        this.schemaName = AWSSchemaRegistryUtils.getInstance().getSchemaName(configs);
        if (this.schemaName == null) {
            this.schemaNamingStrategy = AWSSchemaRegistryUtils.getInstance().configureSchemaNamingStrategy(configs);
        }
        this.avroSerializer = AWSAvroSerializer.builder().configs(configs).credentialProvider(this.credentialProvider).build();
    }

    public byte[] serialize(String topic, Object data) {
        byte[] result = null;
        if (null == data) {
            return null;
        }
        UUID schemaVersionIdFromRegistry = null;
        if (this.schemaVersionId == null) {
            log.debug("Schema Version Id is null. Trying to register the schema.");
            schemaVersionIdFromRegistry = this.avroSerializer.registerSchema(this.prepareInput(data, topic));
        } else {
            schemaVersionIdFromRegistry = this.schemaVersionId;
        }
        if (schemaVersionIdFromRegistry != null) {
            log.debug("Schema Version Id received from schema registry: {}", (Object)schemaVersionIdFromRegistry);
            result = this.avroSerializer.serialize(data, schemaVersionIdFromRegistry);
        }
        return result;
    }

    public void close() {
    }

    private String getSchemaName(String topic, Object data) {
        if (this.schemaName == null) {
            return this.schemaNamingStrategy.getSchemaName(topic, data);
        }
        return this.schemaName;
    }

    private AWSSerializerInput prepareInput(@NonNull Object data, String topic) {
        if (data == null) {
            throw new IllegalArgumentException("data is marked @NonNull but is null");
        }
        return AWSSerializerInput.builder().schemaDefinition(AVROUtils.getInstance().getSchemaDefinition(data)).schemaName(this.getSchemaName(topic, data)).transportName(topic).build();
    }

    @Generated
    public AWSAvroSerializer getAvroSerializer() {
        return this.avroSerializer;
    }

    @Generated
    public AwsCredentialsProvider getCredentialProvider() {
        return this.credentialProvider;
    }

    @Generated
    public UUID getSchemaVersionId() {
        return this.schemaVersionId;
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public AWSSchemaNamingStrategy getSchemaNamingStrategy() {
        return this.schemaNamingStrategy;
    }

    @Generated
    public void setAvroSerializer(AWSAvroSerializer avroSerializer) {
        this.avroSerializer = avroSerializer;
    }

    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Generated
    public void setSchemaNamingStrategy(AWSSchemaNamingStrategy schemaNamingStrategy) {
        this.schemaNamingStrategy = schemaNamingStrategy;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AWSKafkaAvroSerializer)) {
            return false;
        }
        AWSKafkaAvroSerializer other = (AWSKafkaAvroSerializer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AWSAvroSerializer this$avroSerializer = this.getAvroSerializer();
        AWSAvroSerializer other$avroSerializer = other.getAvroSerializer();
        if (this$avroSerializer == null ? other$avroSerializer != null : !this$avroSerializer.equals(other$avroSerializer)) {
            return false;
        }
        AwsCredentialsProvider this$credentialProvider = this.getCredentialProvider();
        AwsCredentialsProvider other$credentialProvider = other.getCredentialProvider();
        if (this$credentialProvider == null ? other$credentialProvider != null : !this$credentialProvider.equals(other$credentialProvider)) {
            return false;
        }
        UUID this$schemaVersionId = this.getSchemaVersionId();
        UUID other$schemaVersionId = other.getSchemaVersionId();
        if (this$schemaVersionId == null ? other$schemaVersionId != null : !((Object)this$schemaVersionId).equals(other$schemaVersionId)) {
            return false;
        }
        String this$schemaName = this.getSchemaName();
        String other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
            return false;
        }
        AWSSchemaNamingStrategy this$schemaNamingStrategy = this.getSchemaNamingStrategy();
        AWSSchemaNamingStrategy other$schemaNamingStrategy = other.getSchemaNamingStrategy();
        return !(this$schemaNamingStrategy == null ? other$schemaNamingStrategy != null : !this$schemaNamingStrategy.equals(other$schemaNamingStrategy));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AWSKafkaAvroSerializer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AWSAvroSerializer $avroSerializer = this.getAvroSerializer();
        result = result * 59 + ($avroSerializer == null ? 43 : $avroSerializer.hashCode());
        AwsCredentialsProvider $credentialProvider = this.getCredentialProvider();
        result = result * 59 + ($credentialProvider == null ? 43 : $credentialProvider.hashCode());
        UUID $schemaVersionId = this.getSchemaVersionId();
        result = result * 59 + ($schemaVersionId == null ? 43 : ((Object)$schemaVersionId).hashCode());
        String $schemaName = this.getSchemaName();
        result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
        AWSSchemaNamingStrategy $schemaNamingStrategy = this.getSchemaNamingStrategy();
        result = result * 59 + ($schemaNamingStrategy == null ? 43 : $schemaNamingStrategy.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AWSKafkaAvroSerializer(avroSerializer=" + this.getAvroSerializer() + ", credentialProvider=" + this.getCredentialProvider() + ", schemaVersionId=" + this.getSchemaVersionId() + ", schemaName=" + this.getSchemaName() + ", schemaNamingStrategy=" + this.getSchemaNamingStrategy() + ")";
    }
}

