/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.deserializers.avro;

import com.amazonaws.services.schemaregistry.common.GlueSchemaRegistryDataFormatDeserializer;
import com.amazonaws.services.schemaregistry.common.configs.GlueSchemaRegistryConfiguration;
import com.amazonaws.services.schemaregistry.deserializers.GlueSchemaRegistryDeserializerDataParser;
import com.amazonaws.services.schemaregistry.deserializers.avro.DatumReaderInstance;
import com.amazonaws.services.schemaregistry.exception.AWSSchemaRegistryException;
import com.amazonaws.services.schemaregistry.utils.AvroRecordType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.nio.ByteBuffer;
import lombok.Generated;
import lombok.NonNull;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroDeserializer
implements GlueSchemaRegistryDataFormatDeserializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AvroDeserializer.class);
    private static final GlueSchemaRegistryDeserializerDataParser DESERIALIZER_DATA_PARSER = GlueSchemaRegistryDeserializerDataParser.getInstance();
    private static final long MAX_DATUM_READER_CACHE_SIZE = 100L;
    private GlueSchemaRegistryConfiguration schemaRegistrySerDeConfigs;
    private AvroRecordType avroRecordType;
    @NonNull
    @VisibleForTesting
    protected final LoadingCache<String, DatumReader<Object>> datumReaderCache;

    public AvroDeserializer(GlueSchemaRegistryConfiguration configs) {
        this.schemaRegistrySerDeConfigs = configs;
        this.avroRecordType = configs.getAvroRecordType();
        this.datumReaderCache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new DatumReaderCache());
    }

    public Object deserialize(@NonNull ByteBuffer buffer, @NonNull String schema) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer is marked non-null but is null");
        }
        if (schema == null) {
            throw new IllegalArgumentException("schema is marked non-null but is null");
        }
        try {
            byte[] data = DESERIALIZER_DATA_PARSER.getPlainData(buffer);
            log.debug("Length of actual message: {}", (Object)data.length);
            DatumReader datumReader = (DatumReader)this.datumReaderCache.get((Object)schema);
            BinaryDecoder binaryDecoder = this.getBinaryDecoder(data, 0, data.length);
            Object result = datumReader.read(null, (Decoder)binaryDecoder);
            log.debug("Finished de-serializing Avro message");
            return result;
        }
        catch (Exception e) {
            String message = "Exception occurred while de-serializing Avro message";
            throw new AWSSchemaRegistryException(message, (Throwable)e);
        }
    }

    private BinaryDecoder getBinaryDecoder(byte[] data, int start, int end) {
        return DecoderFactory.get().binaryDecoder(data, start, end, null);
    }

    @Generated
    public static AvroDeserializerBuilder builder() {
        return new AvroDeserializerBuilder();
    }

    @Generated
    public GlueSchemaRegistryConfiguration getSchemaRegistrySerDeConfigs() {
        return this.schemaRegistrySerDeConfigs;
    }

    @Generated
    public void setSchemaRegistrySerDeConfigs(GlueSchemaRegistryConfiguration schemaRegistrySerDeConfigs) {
        this.schemaRegistrySerDeConfigs = schemaRegistrySerDeConfigs;
    }

    @Generated
    public void setAvroRecordType(AvroRecordType avroRecordType) {
        this.avroRecordType = avroRecordType;
    }

    @NonNull
    @Generated
    public LoadingCache<String, DatumReader<Object>> getDatumReaderCache() {
        return this.datumReaderCache;
    }

    @Generated
    public static class AvroDeserializerBuilder {
        @Generated
        private GlueSchemaRegistryConfiguration configs;

        @Generated
        AvroDeserializerBuilder() {
        }

        @Generated
        public AvroDeserializerBuilder configs(GlueSchemaRegistryConfiguration configs) {
            this.configs = configs;
            return this;
        }

        @Generated
        public AvroDeserializer build() {
            return new AvroDeserializer(this.configs);
        }

        @Generated
        public String toString() {
            return "AvroDeserializer.AvroDeserializerBuilder(configs=" + this.configs + ")";
        }
    }

    private class DatumReaderCache
    extends CacheLoader<String, DatumReader<Object>> {
        private DatumReaderCache() {
        }

        public DatumReader<Object> load(String schema) throws Exception {
            return DatumReaderInstance.from(schema, AvroDeserializer.this.avroRecordType);
        }
    }
}

