/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.deserializers.avro;

import com.amazonaws.services.schemaregistry.utils.AVROUtils;
import com.amazonaws.services.schemaregistry.utils.AvroRecordType;
import lombok.Generated;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatumReaderInstance {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DatumReaderInstance.class);
    private static final AVROUtils AVRO_UTILS = AVROUtils.getInstance();

    public static DatumReader<Object> from(String writerSchemaDefinition, AvroRecordType avroRecordType) throws InstantiationException, IllegalAccessException {
        Schema writerSchema = AVRO_UTILS.parseSchema(writerSchemaDefinition);
        switch (avroRecordType) {
            case SPECIFIC_RECORD: {
                Class readerClass = SpecificData.get().getClass(writerSchema);
                Schema readerSchema = ((SpecificRecord)readerClass.newInstance()).getSchema();
                log.debug("Using SpecificDatumReader for de-serializing Avro message, schema: {})", (Object)readerSchema.toString());
                return new SpecificDatumReader(writerSchema, readerSchema);
            }
            case GENERIC_RECORD: {
                log.debug("Using GenericDatumReader for de-serializing Avro message, schema: {})", (Object)writerSchema.toString());
                return new GenericDatumReader(writerSchema);
            }
        }
        String message = String.format("Unsupported AvroRecordType: %s", avroRecordType.getName());
        throw new UnsupportedOperationException(message);
    }
}

