/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.halo.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.halo.model.ActivitySession;
import software.amazon.halo.model.ActivitySummary;

@JsonDeserialize(builder=Builder.class)
public final class Activity {
    @JsonProperty(value="sessions")
    private List<ActivitySession> sessions = new ArrayList<ActivitySession>();
    @JsonProperty(value="summary")
    private ActivitySummary summary = null;

    public static Builder builder() {
        return new Builder();
    }

    private Activity(Builder builder) {
        if (builder.sessions != null) {
            this.sessions = builder.sessions;
        }
        if (builder.summary != null) {
            this.summary = builder.summary;
        }
    }

    @JsonProperty(value="sessions")
    public List<ActivitySession> getSessions() {
        return this.sessions;
    }

    @JsonProperty(value="summary")
    public ActivitySummary getSummary() {
        return this.summary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Activity activity = (Activity)o;
        return Objects.equals(this.sessions, activity.sessions) && Objects.equals(this.summary, activity.summary);
    }

    public int hashCode() {
        return Objects.hash(this.sessions, this.summary);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Activity {\n");
        sb.append("    sessions: ").append(this.toIndentedString(this.sessions)).append("\n");
        sb.append("    summary: ").append(this.toIndentedString(this.summary)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private List<ActivitySession> sessions;
        private ActivitySummary summary;

        private Builder() {
        }

        @JsonProperty(value="sessions")
        public Builder withSessions(List<ActivitySession> sessions) {
            this.sessions = sessions;
            return this;
        }

        public Builder addSessionsItem(ActivitySession sessionsItem) {
            if (this.sessions == null) {
                this.sessions = new ArrayList<ActivitySession>();
            }
            this.sessions.add(sessionsItem);
            return this;
        }

        @JsonProperty(value="summary")
        public Builder withSummary(ActivitySummary summary) {
            this.summary = summary;
            return this;
        }

        public Activity build() {
            return new Activity(this);
        }
    }
}

