/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.halo.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import software.amazon.halo.model.ActivitySessionDuration;
import software.amazon.halo.model.CalorieInfo;
import software.amazon.halo.model.HeartRate;
import software.amazon.halo.model.StepInfo;

@JsonDeserialize(builder=Builder.class)
public final class ActivitySession {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="type")
    private String type = null;
    @JsonProperty(value="startDateTime")
    private String startDateTime = null;
    @JsonProperty(value="endDateTime")
    private String endDateTime = null;
    @JsonProperty(value="modified")
    private Boolean modified = null;
    @JsonProperty(value="automatic")
    private Boolean automatic = null;
    @JsonProperty(value="stepInfo")
    private StepInfo stepInfo = null;
    @JsonProperty(value="heartRate")
    private HeartRate heartRate = null;
    @JsonProperty(value="timestamp")
    private String timestamp = null;
    @JsonProperty(value="calorieInfo")
    private CalorieInfo calorieInfo = null;
    @JsonProperty(value="duration")
    private ActivitySessionDuration duration = null;

    public static Builder builder() {
        return new Builder();
    }

    private ActivitySession(Builder builder) {
        if (builder.id != null) {
            this.id = builder.id;
        }
        if (builder.type != null) {
            this.type = builder.type;
        }
        if (builder.startDateTime != null) {
            this.startDateTime = builder.startDateTime;
        }
        if (builder.endDateTime != null) {
            this.endDateTime = builder.endDateTime;
        }
        if (builder.modified != null) {
            this.modified = builder.modified;
        }
        if (builder.automatic != null) {
            this.automatic = builder.automatic;
        }
        if (builder.stepInfo != null) {
            this.stepInfo = builder.stepInfo;
        }
        if (builder.heartRate != null) {
            this.heartRate = builder.heartRate;
        }
        if (builder.timestamp != null) {
            this.timestamp = builder.timestamp;
        }
        if (builder.calorieInfo != null) {
            this.calorieInfo = builder.calorieInfo;
        }
        if (builder.duration != null) {
            this.duration = builder.duration;
        }
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="startDateTime")
    public String getStartDateTime() {
        return this.startDateTime;
    }

    @JsonProperty(value="endDateTime")
    public String getEndDateTime() {
        return this.endDateTime;
    }

    @JsonProperty(value="modified")
    public Boolean getModified() {
        return this.modified;
    }

    @JsonProperty(value="automatic")
    public Boolean getAutomatic() {
        return this.automatic;
    }

    @JsonProperty(value="stepInfo")
    public StepInfo getStepInfo() {
        return this.stepInfo;
    }

    @JsonProperty(value="heartRate")
    public HeartRate getHeartRate() {
        return this.heartRate;
    }

    @JsonProperty(value="timestamp")
    public String getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="calorieInfo")
    public CalorieInfo getCalorieInfo() {
        return this.calorieInfo;
    }

    @JsonProperty(value="duration")
    public ActivitySessionDuration getDuration() {
        return this.duration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivitySession activitySession = (ActivitySession)o;
        return Objects.equals(this.id, activitySession.id) && Objects.equals(this.type, activitySession.type) && Objects.equals(this.startDateTime, activitySession.startDateTime) && Objects.equals(this.endDateTime, activitySession.endDateTime) && Objects.equals(this.modified, activitySession.modified) && Objects.equals(this.automatic, activitySession.automatic) && Objects.equals(this.stepInfo, activitySession.stepInfo) && Objects.equals(this.heartRate, activitySession.heartRate) && Objects.equals(this.timestamp, activitySession.timestamp) && Objects.equals(this.calorieInfo, activitySession.calorieInfo) && Objects.equals(this.duration, activitySession.duration);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type, this.startDateTime, this.endDateTime, this.modified, this.automatic, this.stepInfo, this.heartRate, this.timestamp, this.calorieInfo, this.duration);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActivitySession {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    startDateTime: ").append(this.toIndentedString(this.startDateTime)).append("\n");
        sb.append("    endDateTime: ").append(this.toIndentedString(this.endDateTime)).append("\n");
        sb.append("    modified: ").append(this.toIndentedString(this.modified)).append("\n");
        sb.append("    automatic: ").append(this.toIndentedString(this.automatic)).append("\n");
        sb.append("    stepInfo: ").append(this.toIndentedString(this.stepInfo)).append("\n");
        sb.append("    heartRate: ").append(this.toIndentedString(this.heartRate)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    calorieInfo: ").append(this.toIndentedString(this.calorieInfo)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String id;
        private String type;
        private String startDateTime;
        private String endDateTime;
        private Boolean modified;
        private Boolean automatic;
        private StepInfo stepInfo;
        private HeartRate heartRate;
        private String timestamp;
        private CalorieInfo calorieInfo;
        private ActivitySessionDuration duration;

        private Builder() {
        }

        @JsonProperty(value="id")
        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="type")
        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="startDateTime")
        public Builder withStartDateTime(String startDateTime) {
            this.startDateTime = startDateTime;
            return this;
        }

        @JsonProperty(value="endDateTime")
        public Builder withEndDateTime(String endDateTime) {
            this.endDateTime = endDateTime;
            return this;
        }

        @JsonProperty(value="modified")
        public Builder withModified(Boolean modified) {
            this.modified = modified;
            return this;
        }

        @JsonProperty(value="automatic")
        public Builder withAutomatic(Boolean automatic) {
            this.automatic = automatic;
            return this;
        }

        @JsonProperty(value="stepInfo")
        public Builder withStepInfo(StepInfo stepInfo) {
            this.stepInfo = stepInfo;
            return this;
        }

        @JsonProperty(value="heartRate")
        public Builder withHeartRate(HeartRate heartRate) {
            this.heartRate = heartRate;
            return this;
        }

        @JsonProperty(value="timestamp")
        public Builder withTimestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @JsonProperty(value="calorieInfo")
        public Builder withCalorieInfo(CalorieInfo calorieInfo) {
            this.calorieInfo = calorieInfo;
            return this;
        }

        @JsonProperty(value="duration")
        public Builder withDuration(ActivitySessionDuration duration) {
            this.duration = duration;
            return this;
        }

        public ActivitySession build() {
            return new ActivitySession(this);
        }
    }
}

