/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.halo.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class ActivitySessionDuration {
    @JsonProperty(value="intenseActivity")
    private BigDecimal intenseActivity = null;
    @JsonProperty(value="moderateActivity")
    private BigDecimal moderateActivity = null;
    @JsonProperty(value="lightActivity")
    private BigDecimal lightActivity = null;

    public static Builder builder() {
        return new Builder();
    }

    private ActivitySessionDuration(Builder builder) {
        if (builder.intenseActivity != null) {
            this.intenseActivity = builder.intenseActivity;
        }
        if (builder.moderateActivity != null) {
            this.moderateActivity = builder.moderateActivity;
        }
        if (builder.lightActivity != null) {
            this.lightActivity = builder.lightActivity;
        }
    }

    @JsonProperty(value="intenseActivity")
    public BigDecimal getIntenseActivity() {
        return this.intenseActivity;
    }

    @JsonProperty(value="moderateActivity")
    public BigDecimal getModerateActivity() {
        return this.moderateActivity;
    }

    @JsonProperty(value="lightActivity")
    public BigDecimal getLightActivity() {
        return this.lightActivity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivitySessionDuration activitySessionDuration = (ActivitySessionDuration)o;
        return Objects.equals(this.intenseActivity, activitySessionDuration.intenseActivity) && Objects.equals(this.moderateActivity, activitySessionDuration.moderateActivity) && Objects.equals(this.lightActivity, activitySessionDuration.lightActivity);
    }

    public int hashCode() {
        return Objects.hash(this.intenseActivity, this.moderateActivity, this.lightActivity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActivitySessionDuration {\n");
        sb.append("    intenseActivity: ").append(this.toIndentedString(this.intenseActivity)).append("\n");
        sb.append("    moderateActivity: ").append(this.toIndentedString(this.moderateActivity)).append("\n");
        sb.append("    lightActivity: ").append(this.toIndentedString(this.lightActivity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private BigDecimal intenseActivity;
        private BigDecimal moderateActivity;
        private BigDecimal lightActivity;

        private Builder() {
        }

        @JsonProperty(value="intenseActivity")
        public Builder withIntenseActivity(BigDecimal intenseActivity) {
            this.intenseActivity = intenseActivity;
            return this;
        }

        @JsonProperty(value="moderateActivity")
        public Builder withModerateActivity(BigDecimal moderateActivity) {
            this.moderateActivity = moderateActivity;
            return this;
        }

        @JsonProperty(value="lightActivity")
        public Builder withLightActivity(BigDecimal lightActivity) {
            this.lightActivity = lightActivity;
            return this;
        }

        public ActivitySessionDuration build() {
            return new ActivitySessionDuration(this);
        }
    }
}

