/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.halo.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import software.amazon.halo.model.ActivitySummaryDuration;

@JsonDeserialize(builder=Builder.class)
public final class ActivitySummary {
    @JsonProperty(value="timestamp")
    private String timestamp = null;
    @JsonProperty(value="duration")
    private ActivitySummaryDuration duration = null;

    public static Builder builder() {
        return new Builder();
    }

    private ActivitySummary(Builder builder) {
        if (builder.timestamp != null) {
            this.timestamp = builder.timestamp;
        }
        if (builder.duration != null) {
            this.duration = builder.duration;
        }
    }

    @JsonProperty(value="timestamp")
    public String getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="duration")
    public ActivitySummaryDuration getDuration() {
        return this.duration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivitySummary activitySummary = (ActivitySummary)o;
        return Objects.equals(this.timestamp, activitySummary.timestamp) && Objects.equals(this.duration, activitySummary.duration);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.duration);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActivitySummary {\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String timestamp;
        private ActivitySummaryDuration duration;

        private Builder() {
        }

        @JsonProperty(value="timestamp")
        public Builder withTimestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @JsonProperty(value="duration")
        public Builder withDuration(ActivitySummaryDuration duration) {
            this.duration = duration;
            return this;
        }

        public ActivitySummary build() {
            return new ActivitySummary(this);
        }
    }
}

