/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.halo.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class ActivitySummaryDuration {
    @JsonProperty(value="intenseActivity")
    private BigDecimal intenseActivity = null;
    @JsonProperty(value="moderateActivity")
    private BigDecimal moderateActivity = null;
    @JsonProperty(value="lightActivity")
    private BigDecimal lightActivity = null;
    @JsonProperty(value="sedentary")
    private BigDecimal sedentary = null;

    public static Builder builder() {
        return new Builder();
    }

    private ActivitySummaryDuration(Builder builder) {
        if (builder.intenseActivity != null) {
            this.intenseActivity = builder.intenseActivity;
        }
        if (builder.moderateActivity != null) {
            this.moderateActivity = builder.moderateActivity;
        }
        if (builder.lightActivity != null) {
            this.lightActivity = builder.lightActivity;
        }
        if (builder.sedentary != null) {
            this.sedentary = builder.sedentary;
        }
    }

    @JsonProperty(value="intenseActivity")
    public BigDecimal getIntenseActivity() {
        return this.intenseActivity;
    }

    @JsonProperty(value="moderateActivity")
    public BigDecimal getModerateActivity() {
        return this.moderateActivity;
    }

    @JsonProperty(value="lightActivity")
    public BigDecimal getLightActivity() {
        return this.lightActivity;
    }

    @JsonProperty(value="sedentary")
    public BigDecimal getSedentary() {
        return this.sedentary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivitySummaryDuration activitySummaryDuration = (ActivitySummaryDuration)o;
        return Objects.equals(this.intenseActivity, activitySummaryDuration.intenseActivity) && Objects.equals(this.moderateActivity, activitySummaryDuration.moderateActivity) && Objects.equals(this.lightActivity, activitySummaryDuration.lightActivity) && Objects.equals(this.sedentary, activitySummaryDuration.sedentary);
    }

    public int hashCode() {
        return Objects.hash(this.intenseActivity, this.moderateActivity, this.lightActivity, this.sedentary);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActivitySummaryDuration {\n");
        sb.append("    intenseActivity: ").append(this.toIndentedString(this.intenseActivity)).append("\n");
        sb.append("    moderateActivity: ").append(this.toIndentedString(this.moderateActivity)).append("\n");
        sb.append("    lightActivity: ").append(this.toIndentedString(this.lightActivity)).append("\n");
        sb.append("    sedentary: ").append(this.toIndentedString(this.sedentary)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private BigDecimal intenseActivity;
        private BigDecimal moderateActivity;
        private BigDecimal lightActivity;
        private BigDecimal sedentary;

        private Builder() {
        }

        @JsonProperty(value="intenseActivity")
        public Builder withIntenseActivity(BigDecimal intenseActivity) {
            this.intenseActivity = intenseActivity;
            return this;
        }

        @JsonProperty(value="moderateActivity")
        public Builder withModerateActivity(BigDecimal moderateActivity) {
            this.moderateActivity = moderateActivity;
            return this;
        }

        @JsonProperty(value="lightActivity")
        public Builder withLightActivity(BigDecimal lightActivity) {
            this.lightActivity = lightActivity;
            return this;
        }

        @JsonProperty(value="sedentary")
        public Builder withSedentary(BigDecimal sedentary) {
            this.sedentary = sedentary;
            return this;
        }

        public ActivitySummaryDuration build() {
            return new ActivitySummaryDuration(this);
        }
    }
}

