/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.halo.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Challenge {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="type")
    private String type = null;
    @JsonProperty(value="startDate")
    private String startDate = null;
    @JsonProperty(value="completionDate")
    private String completionDate = null;
    @JsonProperty(value="timestamp")
    private String timestamp = null;

    public static Builder builder() {
        return new Builder();
    }

    private Challenge(Builder builder) {
        if (builder.id != null) {
            this.id = builder.id;
        }
        if (builder.name != null) {
            this.name = builder.name;
        }
        if (builder.type != null) {
            this.type = builder.type;
        }
        if (builder.startDate != null) {
            this.startDate = builder.startDate;
        }
        if (builder.completionDate != null) {
            this.completionDate = builder.completionDate;
        }
        if (builder.timestamp != null) {
            this.timestamp = builder.timestamp;
        }
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="startDate")
    public String getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="completionDate")
    public String getCompletionDate() {
        return this.completionDate;
    }

    @JsonProperty(value="timestamp")
    public String getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Challenge challenge = (Challenge)o;
        return Objects.equals(this.id, challenge.id) && Objects.equals(this.name, challenge.name) && Objects.equals(this.type, challenge.type) && Objects.equals(this.startDate, challenge.startDate) && Objects.equals(this.completionDate, challenge.completionDate) && Objects.equals(this.timestamp, challenge.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.type, this.startDate, this.completionDate, this.timestamp);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Challenge {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    completionDate: ").append(this.toIndentedString(this.completionDate)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String id;
        private String name;
        private String type;
        private String startDate;
        private String completionDate;
        private String timestamp;

        private Builder() {
        }

        @JsonProperty(value="id")
        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="name")
        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="type")
        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="startDate")
        public Builder withStartDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        @JsonProperty(value="completionDate")
        public Builder withCompletionDate(String completionDate) {
            this.completionDate = completionDate;
            return this;
        }

        @JsonProperty(value="timestamp")
        public Builder withTimestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Challenge build() {
            return new Challenge(this);
        }
    }
}

