/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.halo.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.halo.model.Deauthorization;
import software.amazon.halo.model.Record;

@JsonDeserialize(builder=Builder.class)
public final class Data {
    @JsonProperty(value="records")
    private List<Record> records = new ArrayList<Record>();
    @JsonProperty(value="deauthorization")
    private Deauthorization deauthorization = null;

    public static Builder builder() {
        return new Builder();
    }

    private Data(Builder builder) {
        if (builder.records != null) {
            this.records = builder.records;
        }
        if (builder.deauthorization != null) {
            this.deauthorization = builder.deauthorization;
        }
    }

    @JsonProperty(value="records")
    public List<Record> getRecords() {
        return this.records;
    }

    @JsonProperty(value="deauthorization")
    public Deauthorization getDeauthorization() {
        return this.deauthorization;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Data data = (Data)o;
        return Objects.equals(this.records, data.records) && Objects.equals(this.deauthorization, data.deauthorization);
    }

    public int hashCode() {
        return Objects.hash(this.records, this.deauthorization);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Data {\n");
        sb.append("    records: ").append(this.toIndentedString(this.records)).append("\n");
        sb.append("    deauthorization: ").append(this.toIndentedString(this.deauthorization)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private List<Record> records;
        private Deauthorization deauthorization;

        private Builder() {
        }

        @JsonProperty(value="records")
        public Builder withRecords(List<Record> records) {
            this.records = records;
            return this;
        }

        public Builder addRecordsItem(Record recordsItem) {
            if (this.records == null) {
                this.records = new ArrayList<Record>();
            }
            this.records.add(recordsItem);
            return this;
        }

        @JsonProperty(value="deauthorization")
        public Builder withDeauthorization(Deauthorization deauthorization) {
            this.deauthorization = deauthorization;
            return this;
        }

        public Data build() {
            return new Data(this);
        }
    }
}

