/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.halo.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class HeartRate {
    @JsonProperty(value="average")
    private BigDecimal average = null;
    @JsonProperty(value="maximum")
    private BigDecimal maximum = null;
    @JsonProperty(value="resting")
    private BigDecimal resting = null;

    public static Builder builder() {
        return new Builder();
    }

    private HeartRate(Builder builder) {
        if (builder.average != null) {
            this.average = builder.average;
        }
        if (builder.maximum != null) {
            this.maximum = builder.maximum;
        }
        if (builder.resting != null) {
            this.resting = builder.resting;
        }
    }

    @JsonProperty(value="average")
    public BigDecimal getAverage() {
        return this.average;
    }

    @JsonProperty(value="maximum")
    public BigDecimal getMaximum() {
        return this.maximum;
    }

    @JsonProperty(value="resting")
    public BigDecimal getResting() {
        return this.resting;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HeartRate heartRate = (HeartRate)o;
        return Objects.equals(this.average, heartRate.average) && Objects.equals(this.maximum, heartRate.maximum) && Objects.equals(this.resting, heartRate.resting);
    }

    public int hashCode() {
        return Objects.hash(this.average, this.maximum, this.resting);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HeartRate {\n");
        sb.append("    average: ").append(this.toIndentedString(this.average)).append("\n");
        sb.append("    maximum: ").append(this.toIndentedString(this.maximum)).append("\n");
        sb.append("    resting: ").append(this.toIndentedString(this.resting)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private BigDecimal average;
        private BigDecimal maximum;
        private BigDecimal resting;

        private Builder() {
        }

        @JsonProperty(value="average")
        public Builder withAverage(BigDecimal average) {
            this.average = average;
            return this;
        }

        @JsonProperty(value="maximum")
        public Builder withMaximum(BigDecimal maximum) {
            this.maximum = maximum;
            return this;
        }

        @JsonProperty(value="resting")
        public Builder withResting(BigDecimal resting) {
            this.resting = resting;
            return this;
        }

        public HeartRate build() {
            return new HeartRate(this);
        }
    }
}

