/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.halo.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Measurement {
    @JsonProperty(value="value")
    private BigDecimal value = null;
    @JsonProperty(value="timestamp")
    private String timestamp = null;

    public static Builder builder() {
        return new Builder();
    }

    private Measurement(Builder builder) {
        if (builder.value != null) {
            this.value = builder.value;
        }
        if (builder.timestamp != null) {
            this.timestamp = builder.timestamp;
        }
    }

    @JsonProperty(value="value")
    public BigDecimal getValue() {
        return this.value;
    }

    @JsonProperty(value="timestamp")
    public String getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Measurement measurement = (Measurement)o;
        return Objects.equals(this.value, measurement.value) && Objects.equals(this.timestamp, measurement.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.timestamp);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Measurement {\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private BigDecimal value;
        private String timestamp;

        private Builder() {
        }

        @JsonProperty(value="value")
        public Builder withValue(BigDecimal value) {
            this.value = value;
            return this;
        }

        @JsonProperty(value="timestamp")
        public Builder withTimestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Measurement build() {
            return new Measurement(this);
        }
    }
}

