/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.halo.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.halo.model.Activity;
import software.amazon.halo.model.Body;
import software.amazon.halo.model.Challenge;
import software.amazon.halo.model.Sleep;
import software.amazon.halo.model.StepInfo;

@JsonDeserialize(builder=Builder.class)
public final class Record {
    @JsonProperty(value="date")
    private String date = null;
    @JsonProperty(value="sub")
    private String sub = null;
    @JsonProperty(value="stepInfo")
    private StepInfo stepInfo = null;
    @JsonProperty(value="sleep")
    private Sleep sleep = null;
    @JsonProperty(value="activity")
    private Activity activity = null;
    @JsonProperty(value="challenges")
    private List<Challenge> challenges = new ArrayList<Challenge>();
    @JsonProperty(value="body")
    private Body body = null;

    public static Builder builder() {
        return new Builder();
    }

    private Record(Builder builder) {
        if (builder.date != null) {
            this.date = builder.date;
        }
        if (builder.sub != null) {
            this.sub = builder.sub;
        }
        if (builder.stepInfo != null) {
            this.stepInfo = builder.stepInfo;
        }
        if (builder.sleep != null) {
            this.sleep = builder.sleep;
        }
        if (builder.activity != null) {
            this.activity = builder.activity;
        }
        if (builder.challenges != null) {
            this.challenges = builder.challenges;
        }
        if (builder.body != null) {
            this.body = builder.body;
        }
    }

    @JsonProperty(value="date")
    public String getDate() {
        return this.date;
    }

    @JsonProperty(value="sub")
    public String getSub() {
        return this.sub;
    }

    @JsonProperty(value="stepInfo")
    public StepInfo getStepInfo() {
        return this.stepInfo;
    }

    @JsonProperty(value="sleep")
    public Sleep getSleep() {
        return this.sleep;
    }

    @JsonProperty(value="activity")
    public Activity getActivity() {
        return this.activity;
    }

    @JsonProperty(value="challenges")
    public List<Challenge> getChallenges() {
        return this.challenges;
    }

    @JsonProperty(value="body")
    public Body getBody() {
        return this.body;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Record record = (Record)o;
        return Objects.equals(this.date, record.date) && Objects.equals(this.sub, record.sub) && Objects.equals(this.stepInfo, record.stepInfo) && Objects.equals(this.sleep, record.sleep) && Objects.equals(this.activity, record.activity) && Objects.equals(this.challenges, record.challenges) && Objects.equals(this.body, record.body);
    }

    public int hashCode() {
        return Objects.hash(this.date, this.sub, this.stepInfo, this.sleep, this.activity, this.challenges, this.body);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Record {\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    sub: ").append(this.toIndentedString(this.sub)).append("\n");
        sb.append("    stepInfo: ").append(this.toIndentedString(this.stepInfo)).append("\n");
        sb.append("    sleep: ").append(this.toIndentedString(this.sleep)).append("\n");
        sb.append("    activity: ").append(this.toIndentedString(this.activity)).append("\n");
        sb.append("    challenges: ").append(this.toIndentedString(this.challenges)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String date;
        private String sub;
        private StepInfo stepInfo;
        private Sleep sleep;
        private Activity activity;
        private List<Challenge> challenges;
        private Body body;

        private Builder() {
        }

        @JsonProperty(value="date")
        public Builder withDate(String date) {
            this.date = date;
            return this;
        }

        @JsonProperty(value="sub")
        public Builder withSub(String sub) {
            this.sub = sub;
            return this;
        }

        @JsonProperty(value="stepInfo")
        public Builder withStepInfo(StepInfo stepInfo) {
            this.stepInfo = stepInfo;
            return this;
        }

        @JsonProperty(value="sleep")
        public Builder withSleep(Sleep sleep) {
            this.sleep = sleep;
            return this;
        }

        @JsonProperty(value="activity")
        public Builder withActivity(Activity activity) {
            this.activity = activity;
            return this;
        }

        @JsonProperty(value="challenges")
        public Builder withChallenges(List<Challenge> challenges) {
            this.challenges = challenges;
            return this;
        }

        public Builder addChallengesItem(Challenge challengesItem) {
            if (this.challenges == null) {
                this.challenges = new ArrayList<Challenge>();
            }
            this.challenges.add(challengesItem);
            return this;
        }

        @JsonProperty(value="body")
        public Builder withBody(Body body) {
            this.body = body;
            return this;
        }

        public Record build() {
            return new Record(this);
        }
    }
}

