/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.halo.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import software.amazon.halo.model.Data;

@JsonDeserialize(builder=Builder.class)
public final class RequestEnvelope {
    @JsonProperty(value="version")
    private String version = null;
    @JsonProperty(value="timestamp")
    private String timestamp = null;
    @JsonProperty(value="type")
    private String type = null;
    @JsonProperty(value="data")
    private Data data = null;

    public static Builder builder() {
        return new Builder();
    }

    private RequestEnvelope(Builder builder) {
        if (builder.version != null) {
            this.version = builder.version;
        }
        if (builder.timestamp != null) {
            this.timestamp = builder.timestamp;
        }
        if (builder.type != null) {
            this.type = builder.type;
        }
        if (builder.data != null) {
            this.data = builder.data;
        }
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="timestamp")
    public String getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="data")
    public Data getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestEnvelope requestEnvelope = (RequestEnvelope)o;
        return Objects.equals(this.version, requestEnvelope.version) && Objects.equals(this.timestamp, requestEnvelope.timestamp) && Objects.equals(this.type, requestEnvelope.type) && Objects.equals(this.data, requestEnvelope.data);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.timestamp, this.type, this.data);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RequestEnvelope {\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String version;
        private String timestamp;
        private String type;
        private Data data;

        private Builder() {
        }

        @JsonProperty(value="version")
        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        @JsonProperty(value="timestamp")
        public Builder withTimestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @JsonProperty(value="type")
        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="data")
        public Builder withData(Data data) {
            this.data = data;
            return this;
        }

        public RequestEnvelope build() {
            return new RequestEnvelope(this);
        }
    }
}

