/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.halo.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.Objects;
import software.amazon.halo.model.SleepDuration;
import software.amazon.halo.model.SleepScore;

@JsonDeserialize(builder=Builder.class)
public final class Sleep {
    @JsonProperty(value="timestamp")
    private String timestamp = null;
    @JsonProperty(value="score")
    private SleepScore score = null;
    @JsonProperty(value="duration")
    private SleepDuration duration = null;
    @JsonProperty(value="efficiency")
    private BigDecimal efficiency = null;
    @JsonProperty(value="onsetLatency")
    private BigDecimal onsetLatency = null;
    @JsonProperty(value="numberOfAwakenings")
    private Integer numberOfAwakenings = null;
    @JsonProperty(value="modified")
    private Boolean modified = null;
    @JsonProperty(value="sessionStartTime")
    private String sessionStartTime = null;
    @JsonProperty(value="sessionEndTime")
    private String sessionEndTime = null;

    public static Builder builder() {
        return new Builder();
    }

    private Sleep(Builder builder) {
        if (builder.timestamp != null) {
            this.timestamp = builder.timestamp;
        }
        if (builder.score != null) {
            this.score = builder.score;
        }
        if (builder.duration != null) {
            this.duration = builder.duration;
        }
        if (builder.efficiency != null) {
            this.efficiency = builder.efficiency;
        }
        if (builder.onsetLatency != null) {
            this.onsetLatency = builder.onsetLatency;
        }
        if (builder.numberOfAwakenings != null) {
            this.numberOfAwakenings = builder.numberOfAwakenings;
        }
        if (builder.modified != null) {
            this.modified = builder.modified;
        }
        if (builder.sessionStartTime != null) {
            this.sessionStartTime = builder.sessionStartTime;
        }
        if (builder.sessionEndTime != null) {
            this.sessionEndTime = builder.sessionEndTime;
        }
    }

    @JsonProperty(value="timestamp")
    public String getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="score")
    public SleepScore getScore() {
        return this.score;
    }

    @JsonProperty(value="duration")
    public SleepDuration getDuration() {
        return this.duration;
    }

    @JsonProperty(value="efficiency")
    public BigDecimal getEfficiency() {
        return this.efficiency;
    }

    @JsonProperty(value="onsetLatency")
    public BigDecimal getOnsetLatency() {
        return this.onsetLatency;
    }

    @JsonProperty(value="numberOfAwakenings")
    public Integer getNumberOfAwakenings() {
        return this.numberOfAwakenings;
    }

    @JsonProperty(value="modified")
    public Boolean getModified() {
        return this.modified;
    }

    @JsonProperty(value="sessionStartTime")
    public String getSessionStartTime() {
        return this.sessionStartTime;
    }

    @JsonProperty(value="sessionEndTime")
    public String getSessionEndTime() {
        return this.sessionEndTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sleep sleep = (Sleep)o;
        return Objects.equals(this.timestamp, sleep.timestamp) && Objects.equals(this.score, sleep.score) && Objects.equals(this.duration, sleep.duration) && Objects.equals(this.efficiency, sleep.efficiency) && Objects.equals(this.onsetLatency, sleep.onsetLatency) && Objects.equals(this.numberOfAwakenings, sleep.numberOfAwakenings) && Objects.equals(this.modified, sleep.modified) && Objects.equals(this.sessionStartTime, sleep.sessionStartTime) && Objects.equals(this.sessionEndTime, sleep.sessionEndTime);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.score, this.duration, this.efficiency, this.onsetLatency, this.numberOfAwakenings, this.modified, this.sessionStartTime, this.sessionEndTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Sleep {\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    score: ").append(this.toIndentedString(this.score)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    efficiency: ").append(this.toIndentedString(this.efficiency)).append("\n");
        sb.append("    onsetLatency: ").append(this.toIndentedString(this.onsetLatency)).append("\n");
        sb.append("    numberOfAwakenings: ").append(this.toIndentedString(this.numberOfAwakenings)).append("\n");
        sb.append("    modified: ").append(this.toIndentedString(this.modified)).append("\n");
        sb.append("    sessionStartTime: ").append(this.toIndentedString(this.sessionStartTime)).append("\n");
        sb.append("    sessionEndTime: ").append(this.toIndentedString(this.sessionEndTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String timestamp;
        private SleepScore score;
        private SleepDuration duration;
        private BigDecimal efficiency;
        private BigDecimal onsetLatency;
        private Integer numberOfAwakenings;
        private Boolean modified;
        private String sessionStartTime;
        private String sessionEndTime;

        private Builder() {
        }

        @JsonProperty(value="timestamp")
        public Builder withTimestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @JsonProperty(value="score")
        public Builder withScore(SleepScore score) {
            this.score = score;
            return this;
        }

        @JsonProperty(value="duration")
        public Builder withDuration(SleepDuration duration) {
            this.duration = duration;
            return this;
        }

        @JsonProperty(value="efficiency")
        public Builder withEfficiency(BigDecimal efficiency) {
            this.efficiency = efficiency;
            return this;
        }

        @JsonProperty(value="onsetLatency")
        public Builder withOnsetLatency(BigDecimal onsetLatency) {
            this.onsetLatency = onsetLatency;
            return this;
        }

        @JsonProperty(value="numberOfAwakenings")
        public Builder withNumberOfAwakenings(Integer numberOfAwakenings) {
            this.numberOfAwakenings = numberOfAwakenings;
            return this;
        }

        @JsonProperty(value="modified")
        public Builder withModified(Boolean modified) {
            this.modified = modified;
            return this;
        }

        @JsonProperty(value="sessionStartTime")
        public Builder withSessionStartTime(String sessionStartTime) {
            this.sessionStartTime = sessionStartTime;
            return this;
        }

        @JsonProperty(value="sessionEndTime")
        public Builder withSessionEndTime(String sessionEndTime) {
            this.sessionEndTime = sessionEndTime;
            return this;
        }

        public Sleep build() {
            return new Sleep(this);
        }
    }
}

