/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.halo.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class SleepDuration {
    @JsonProperty(value="total")
    private BigDecimal total = null;
    @JsonProperty(value="inBed")
    private BigDecimal inBed = null;
    @JsonProperty(value="awakeAfterSleep")
    private BigDecimal awakeAfterSleep = null;
    @JsonProperty(value="lightSleep")
    private BigDecimal lightSleep = null;
    @JsonProperty(value="deepSleep")
    private BigDecimal deepSleep = null;
    @JsonProperty(value="remSleep")
    private BigDecimal remSleep = null;

    public static Builder builder() {
        return new Builder();
    }

    private SleepDuration(Builder builder) {
        if (builder.total != null) {
            this.total = builder.total;
        }
        if (builder.inBed != null) {
            this.inBed = builder.inBed;
        }
        if (builder.awakeAfterSleep != null) {
            this.awakeAfterSleep = builder.awakeAfterSleep;
        }
        if (builder.lightSleep != null) {
            this.lightSleep = builder.lightSleep;
        }
        if (builder.deepSleep != null) {
            this.deepSleep = builder.deepSleep;
        }
        if (builder.remSleep != null) {
            this.remSleep = builder.remSleep;
        }
    }

    @JsonProperty(value="total")
    public BigDecimal getTotal() {
        return this.total;
    }

    @JsonProperty(value="inBed")
    public BigDecimal getInBed() {
        return this.inBed;
    }

    @JsonProperty(value="awakeAfterSleep")
    public BigDecimal getAwakeAfterSleep() {
        return this.awakeAfterSleep;
    }

    @JsonProperty(value="lightSleep")
    public BigDecimal getLightSleep() {
        return this.lightSleep;
    }

    @JsonProperty(value="deepSleep")
    public BigDecimal getDeepSleep() {
        return this.deepSleep;
    }

    @JsonProperty(value="remSleep")
    public BigDecimal getRemSleep() {
        return this.remSleep;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SleepDuration sleepDuration = (SleepDuration)o;
        return Objects.equals(this.total, sleepDuration.total) && Objects.equals(this.inBed, sleepDuration.inBed) && Objects.equals(this.awakeAfterSleep, sleepDuration.awakeAfterSleep) && Objects.equals(this.lightSleep, sleepDuration.lightSleep) && Objects.equals(this.deepSleep, sleepDuration.deepSleep) && Objects.equals(this.remSleep, sleepDuration.remSleep);
    }

    public int hashCode() {
        return Objects.hash(this.total, this.inBed, this.awakeAfterSleep, this.lightSleep, this.deepSleep, this.remSleep);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SleepDuration {\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    inBed: ").append(this.toIndentedString(this.inBed)).append("\n");
        sb.append("    awakeAfterSleep: ").append(this.toIndentedString(this.awakeAfterSleep)).append("\n");
        sb.append("    lightSleep: ").append(this.toIndentedString(this.lightSleep)).append("\n");
        sb.append("    deepSleep: ").append(this.toIndentedString(this.deepSleep)).append("\n");
        sb.append("    remSleep: ").append(this.toIndentedString(this.remSleep)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private BigDecimal total;
        private BigDecimal inBed;
        private BigDecimal awakeAfterSleep;
        private BigDecimal lightSleep;
        private BigDecimal deepSleep;
        private BigDecimal remSleep;

        private Builder() {
        }

        @JsonProperty(value="total")
        public Builder withTotal(BigDecimal total) {
            this.total = total;
            return this;
        }

        @JsonProperty(value="inBed")
        public Builder withInBed(BigDecimal inBed) {
            this.inBed = inBed;
            return this;
        }

        @JsonProperty(value="awakeAfterSleep")
        public Builder withAwakeAfterSleep(BigDecimal awakeAfterSleep) {
            this.awakeAfterSleep = awakeAfterSleep;
            return this;
        }

        @JsonProperty(value="lightSleep")
        public Builder withLightSleep(BigDecimal lightSleep) {
            this.lightSleep = lightSleep;
            return this;
        }

        @JsonProperty(value="deepSleep")
        public Builder withDeepSleep(BigDecimal deepSleep) {
            this.deepSleep = deepSleep;
            return this;
        }

        @JsonProperty(value="remSleep")
        public Builder withRemSleep(BigDecimal remSleep) {
            this.remSleep = remSleep;
            return this;
        }

        public SleepDuration build() {
            return new SleepDuration(this);
        }
    }
}

