package software.amazon.jsii;

import static software.amazon.jsii.Util.extractResource;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

@javax.annotation.Generated(value = "BundledRuntime.t.js", date = "2022-09-22T19:38:35.681Z")
final class BundledRuntime {
    /**
     * Extracts all files needed for jsii-runtime.js from JAR into a temporary
     * directory.
     *
     * @param klass the {@link Class} that requests the extraction (it will be
     *              used to determine the appropriate {@link ClassLoader})
     *
     * @return The full path for jsii-runtime.js
     */
    static String extract(final Class<?> klass) {
        try {
            final Path directory = Files.createTempDirectory("jsii-java-runtime");
            directory.toFile().deleteOnExit();

            final Path entrypoint = extractResource(klass, "bin/jsii-runtime.js", directory);
            entrypoint.toFile().deleteOnExit();
            extractResource(klass, "bin/jsii-runtime.js.map", directory).toFile().deleteOnExit();
            extractResource(klass, "lib/program.js", directory).toFile().deleteOnExit();
            extractResource(klass, "lib/program.js.map", directory).toFile().deleteOnExit();

            return entrypoint.toString();
        } catch (final IOException ioe) {
            throw new JsiiError("Unable to extract bundled @jsii/runtime library", ioe);
        }
    }

    private BundledRuntime() {}
}
