/*
 *  Copyright 2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Amazon Software License (the "License").
 *  You may not use this file except in compliance with the License.
 *  A copy of the License is located at
 *
 *  http://aws.amazon.com/asl/
 *
 *  or in the "license" file accompanying this file. This file is distributed
 *  on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 *  express or implied. See the License for the specific language governing
 *  permissions and limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: messages.proto

package software.amazon.kinesis.retrieval.kpl;

public final class Messages {
  private Messages() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
  }
  public interface TagOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Tag)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required string key = 1;</code>
     */
    boolean hasKey();
    /**
     * <code>required string key = 1;</code>
     */
    java.lang.String getKey();
    /**
     * <code>required string key = 1;</code>
     */
    com.google.protobuf.ByteString
        getKeyBytes();

    /**
     * <code>optional string value = 2;</code>
     */
    boolean hasValue();
    /**
     * <code>optional string value = 2;</code>
     */
    java.lang.String getValue();
    /**
     * <code>optional string value = 2;</code>
     */
    com.google.protobuf.ByteString
        getValueBytes();
  }
  /**
   * Protobuf type {@code Tag}
   */
  public static final class Tag extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Tag)
      TagOrBuilder {
    // Use Tag.newBuilder() to construct.
    private Tag(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Tag(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Tag defaultInstance;
    public static Tag getDefaultInstance() {
      return defaultInstance;
    }

    public Tag getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Tag(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              key_ = bs;
              break;
            }
            case 18: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000002;
              value_ = bs;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return Messages.internal_static_Tag_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return Messages.internal_static_Tag_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              Messages.Tag.class, Messages.Tag.Builder.class);
    }

    public static com.google.protobuf.Parser<Tag> PARSER =
        new com.google.protobuf.AbstractParser<Tag>() {
      public Tag parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Tag(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Tag> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int KEY_FIELD_NUMBER = 1;
    private java.lang.Object key_;
    /**
     * <code>required string key = 1;</code>
     */
    public boolean hasKey() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required string key = 1;</code>
     */
    public java.lang.String getKey() {
      java.lang.Object ref = key_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          key_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string key = 1;</code>
     */
    public com.google.protobuf.ByteString
        getKeyBytes() {
      java.lang.Object ref = key_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        key_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VALUE_FIELD_NUMBER = 2;
    private java.lang.Object value_;
    /**
     * <code>optional string value = 2;</code>
     */
    public boolean hasValue() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional string value = 2;</code>
     */
    public java.lang.String getValue() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          value_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string value = 2;</code>
     */
    public com.google.protobuf.ByteString
        getValueBytes() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        value_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private void initFields() {
      key_ = "";
      value_ = "";
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasKey()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getKeyBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeBytes(2, getValueBytes());
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getKeyBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(2, getValueBytes());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static Messages.Tag parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static Messages.Tag parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static Messages.Tag parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static Messages.Tag parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static Messages.Tag parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static Messages.Tag parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static Messages.Tag parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static Messages.Tag parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static Messages.Tag parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static Messages.Tag parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(Messages.Tag prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Tag}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Tag)
        Messages.TagOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return Messages.internal_static_Tag_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return Messages.internal_static_Tag_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                Messages.Tag.class, Messages.Tag.Builder.class);
      }

      // Construct using Messages.Tag.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        key_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        value_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return Messages.internal_static_Tag_descriptor;
      }

      public Messages.Tag getDefaultInstanceForType() {
        return Messages.Tag.getDefaultInstance();
      }

      public Messages.Tag build() {
        Messages.Tag result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public Messages.Tag buildPartial() {
        Messages.Tag result = new Messages.Tag(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.key_ = key_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.value_ = value_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof Messages.Tag) {
          return mergeFrom((Messages.Tag)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(Messages.Tag other) {
        if (other == Messages.Tag.getDefaultInstance()) return this;
        if (other.hasKey()) {
          bitField0_ |= 0x00000001;
          key_ = other.key_;
          onChanged();
        }
        if (other.hasValue()) {
          bitField0_ |= 0x00000002;
          value_ = other.value_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasKey()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        Messages.Tag parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (Messages.Tag) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object key_ = "";
      /**
       * <code>required string key = 1;</code>
       */
      public boolean hasKey() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required string key = 1;</code>
       */
      public java.lang.String getKey() {
        java.lang.Object ref = key_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            key_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string key = 1;</code>
       */
      public com.google.protobuf.ByteString
          getKeyBytes() {
        java.lang.Object ref = key_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          key_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>required string key = 1;</code>
       */
      public Builder setKey(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        key_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required string key = 1;</code>
       */
      public Builder clearKey() {
        bitField0_ = (bitField0_ & ~0x00000001);
        key_ = getDefaultInstance().getKey();
        onChanged();
        return this;
      }
      /**
       * <code>required string key = 1;</code>
       */
      public Builder setKeyBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        key_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object value_ = "";
      /**
       * <code>optional string value = 2;</code>
       */
      public boolean hasValue() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional string value = 2;</code>
       */
      public java.lang.String getValue() {
        java.lang.Object ref = value_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            value_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string value = 2;</code>
       */
      public com.google.protobuf.ByteString
          getValueBytes() {
        java.lang.Object ref = value_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          value_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string value = 2;</code>
       */
      public Builder setValue(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        value_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string value = 2;</code>
       */
      public Builder clearValue() {
        bitField0_ = (bitField0_ & ~0x00000002);
        value_ = getDefaultInstance().getValue();
        onChanged();
        return this;
      }
      /**
       * <code>optional string value = 2;</code>
       */
      public Builder setValueBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        value_ = value;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Tag)
    }

    static {
      defaultInstance = new Tag(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Tag)
  }

  public interface RecordOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Record)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required uint64 partition_key_index = 1;</code>
     */
    boolean hasPartitionKeyIndex();
    /**
     * <code>required uint64 partition_key_index = 1;</code>
     */
    long getPartitionKeyIndex();

    /**
     * <code>optional uint64 explicit_hash_key_index = 2;</code>
     */
    boolean hasExplicitHashKeyIndex();
    /**
     * <code>optional uint64 explicit_hash_key_index = 2;</code>
     */
    long getExplicitHashKeyIndex();

    /**
     * <code>required bytes data = 3;</code>
     */
    boolean hasData();
    /**
     * <code>required bytes data = 3;</code>
     */
    com.google.protobuf.ByteString getData();

    /**
     * <code>repeated .Tag tags = 4;</code>
     */
    java.util.List<Messages.Tag> 
        getTagsList();
    /**
     * <code>repeated .Tag tags = 4;</code>
     */
    Messages.Tag getTags(int index);
    /**
     * <code>repeated .Tag tags = 4;</code>
     */
    int getTagsCount();
    /**
     * <code>repeated .Tag tags = 4;</code>
     */
    java.util.List<? extends Messages.TagOrBuilder> 
        getTagsOrBuilderList();
    /**
     * <code>repeated .Tag tags = 4;</code>
     */
    Messages.TagOrBuilder getTagsOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code Record}
   */
  public static final class Record extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Record)
      RecordOrBuilder {
    // Use Record.newBuilder() to construct.
    private Record(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Record(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Record defaultInstance;
    public static Record getDefaultInstance() {
      return defaultInstance;
    }

    public Record getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Record(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              bitField0_ |= 0x00000001;
              partitionKeyIndex_ = input.readUInt64();
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              explicitHashKeyIndex_ = input.readUInt64();
              break;
            }
            case 26: {
              bitField0_ |= 0x00000004;
              data_ = input.readBytes();
              break;
            }
            case 34: {
              if (!((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
                tags_ = new java.util.ArrayList<Messages.Tag>();
                mutable_bitField0_ |= 0x00000008;
              }
              tags_.add(input.readMessage(Messages.Tag.PARSER, extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
          tags_ = java.util.Collections.unmodifiableList(tags_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return Messages.internal_static_Record_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return Messages.internal_static_Record_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              Messages.Record.class, Messages.Record.Builder.class);
    }

    public static com.google.protobuf.Parser<Record> PARSER =
        new com.google.protobuf.AbstractParser<Record>() {
      public Record parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Record(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Record> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int PARTITION_KEY_INDEX_FIELD_NUMBER = 1;
    private long partitionKeyIndex_;
    /**
     * <code>required uint64 partition_key_index = 1;</code>
     */
    public boolean hasPartitionKeyIndex() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required uint64 partition_key_index = 1;</code>
     */
    public long getPartitionKeyIndex() {
      return partitionKeyIndex_;
    }

    public static final int EXPLICIT_HASH_KEY_INDEX_FIELD_NUMBER = 2;
    private long explicitHashKeyIndex_;
    /**
     * <code>optional uint64 explicit_hash_key_index = 2;</code>
     */
    public boolean hasExplicitHashKeyIndex() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional uint64 explicit_hash_key_index = 2;</code>
     */
    public long getExplicitHashKeyIndex() {
      return explicitHashKeyIndex_;
    }

    public static final int DATA_FIELD_NUMBER = 3;
    private com.google.protobuf.ByteString data_;
    /**
     * <code>required bytes data = 3;</code>
     */
    public boolean hasData() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>required bytes data = 3;</code>
     */
    public com.google.protobuf.ByteString getData() {
      return data_;
    }

    public static final int TAGS_FIELD_NUMBER = 4;
    private java.util.List<Messages.Tag> tags_;
    /**
     * <code>repeated .Tag tags = 4;</code>
     */
    public java.util.List<Messages.Tag> getTagsList() {
      return tags_;
    }
    /**
     * <code>repeated .Tag tags = 4;</code>
     */
    public java.util.List<? extends Messages.TagOrBuilder> 
        getTagsOrBuilderList() {
      return tags_;
    }
    /**
     * <code>repeated .Tag tags = 4;</code>
     */
    public int getTagsCount() {
      return tags_.size();
    }
    /**
     * <code>repeated .Tag tags = 4;</code>
     */
    public Messages.Tag getTags(int index) {
      return tags_.get(index);
    }
    /**
     * <code>repeated .Tag tags = 4;</code>
     */
    public Messages.TagOrBuilder getTagsOrBuilder(
        int index) {
      return tags_.get(index);
    }

    private void initFields() {
      partitionKeyIndex_ = 0L;
      explicitHashKeyIndex_ = 0L;
      data_ = com.google.protobuf.ByteString.EMPTY;
      tags_ = java.util.Collections.emptyList();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasPartitionKeyIndex()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasData()) {
        memoizedIsInitialized = 0;
        return false;
      }
      for (int i = 0; i < getTagsCount(); i++) {
        if (!getTags(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeUInt64(1, partitionKeyIndex_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeUInt64(2, explicitHashKeyIndex_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeBytes(3, data_);
      }
      for (int i = 0; i < tags_.size(); i++) {
        output.writeMessage(4, tags_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(1, partitionKeyIndex_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(2, explicitHashKeyIndex_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(3, data_);
      }
      for (int i = 0; i < tags_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, tags_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static Messages.Record parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static Messages.Record parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static Messages.Record parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static Messages.Record parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static Messages.Record parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static Messages.Record parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static Messages.Record parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static Messages.Record parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static Messages.Record parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static Messages.Record parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(Messages.Record prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Record}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Record)
        Messages.RecordOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return Messages.internal_static_Record_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return Messages.internal_static_Record_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                Messages.Record.class, Messages.Record.Builder.class);
      }

      // Construct using Messages.Record.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getTagsFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        partitionKeyIndex_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000001);
        explicitHashKeyIndex_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000002);
        data_ = com.google.protobuf.ByteString.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000004);
        if (tagsBuilder_ == null) {
          tags_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
        } else {
          tagsBuilder_.clear();
        }
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return Messages.internal_static_Record_descriptor;
      }

      public Messages.Record getDefaultInstanceForType() {
        return Messages.Record.getDefaultInstance();
      }

      public Messages.Record build() {
        Messages.Record result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public Messages.Record buildPartial() {
        Messages.Record result = new Messages.Record(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.partitionKeyIndex_ = partitionKeyIndex_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.explicitHashKeyIndex_ = explicitHashKeyIndex_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.data_ = data_;
        if (tagsBuilder_ == null) {
          if (((bitField0_ & 0x00000008) == 0x00000008)) {
            tags_ = java.util.Collections.unmodifiableList(tags_);
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.tags_ = tags_;
        } else {
          result.tags_ = tagsBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof Messages.Record) {
          return mergeFrom((Messages.Record)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(Messages.Record other) {
        if (other == Messages.Record.getDefaultInstance()) return this;
        if (other.hasPartitionKeyIndex()) {
          setPartitionKeyIndex(other.getPartitionKeyIndex());
        }
        if (other.hasExplicitHashKeyIndex()) {
          setExplicitHashKeyIndex(other.getExplicitHashKeyIndex());
        }
        if (other.hasData()) {
          setData(other.getData());
        }
        if (tagsBuilder_ == null) {
          if (!other.tags_.isEmpty()) {
            if (tags_.isEmpty()) {
              tags_ = other.tags_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensureTagsIsMutable();
              tags_.addAll(other.tags_);
            }
            onChanged();
          }
        } else {
          if (!other.tags_.isEmpty()) {
            if (tagsBuilder_.isEmpty()) {
              tagsBuilder_.dispose();
              tagsBuilder_ = null;
              tags_ = other.tags_;
              bitField0_ = (bitField0_ & ~0x00000008);
              tagsBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getTagsFieldBuilder() : null;
            } else {
              tagsBuilder_.addAllMessages(other.tags_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasPartitionKeyIndex()) {
          
          return false;
        }
        if (!hasData()) {
          
          return false;
        }
        for (int i = 0; i < getTagsCount(); i++) {
          if (!getTags(i).isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        Messages.Record parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (Messages.Record) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private long partitionKeyIndex_ ;
      /**
       * <code>required uint64 partition_key_index = 1;</code>
       */
      public boolean hasPartitionKeyIndex() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required uint64 partition_key_index = 1;</code>
       */
      public long getPartitionKeyIndex() {
        return partitionKeyIndex_;
      }
      /**
       * <code>required uint64 partition_key_index = 1;</code>
       */
      public Builder setPartitionKeyIndex(long value) {
        bitField0_ |= 0x00000001;
        partitionKeyIndex_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required uint64 partition_key_index = 1;</code>
       */
      public Builder clearPartitionKeyIndex() {
        bitField0_ = (bitField0_ & ~0x00000001);
        partitionKeyIndex_ = 0L;
        onChanged();
        return this;
      }

      private long explicitHashKeyIndex_ ;
      /**
       * <code>optional uint64 explicit_hash_key_index = 2;</code>
       */
      public boolean hasExplicitHashKeyIndex() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional uint64 explicit_hash_key_index = 2;</code>
       */
      public long getExplicitHashKeyIndex() {
        return explicitHashKeyIndex_;
      }
      /**
       * <code>optional uint64 explicit_hash_key_index = 2;</code>
       */
      public Builder setExplicitHashKeyIndex(long value) {
        bitField0_ |= 0x00000002;
        explicitHashKeyIndex_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 explicit_hash_key_index = 2;</code>
       */
      public Builder clearExplicitHashKeyIndex() {
        bitField0_ = (bitField0_ & ~0x00000002);
        explicitHashKeyIndex_ = 0L;
        onChanged();
        return this;
      }

      private com.google.protobuf.ByteString data_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <code>required bytes data = 3;</code>
       */
      public boolean hasData() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>required bytes data = 3;</code>
       */
      public com.google.protobuf.ByteString getData() {
        return data_;
      }
      /**
       * <code>required bytes data = 3;</code>
       */
      public Builder setData(com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        data_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required bytes data = 3;</code>
       */
      public Builder clearData() {
        bitField0_ = (bitField0_ & ~0x00000004);
        data_ = getDefaultInstance().getData();
        onChanged();
        return this;
      }

      private java.util.List<Messages.Tag> tags_ =
        java.util.Collections.emptyList();
      private void ensureTagsIsMutable() {
        if (!((bitField0_ & 0x00000008) == 0x00000008)) {
          tags_ = new java.util.ArrayList<Messages.Tag>(tags_);
          bitField0_ |= 0x00000008;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          Messages.Tag, Messages.Tag.Builder, Messages.TagOrBuilder> tagsBuilder_;

      /**
       * <code>repeated .Tag tags = 4;</code>
       */
      public java.util.List<Messages.Tag> getTagsList() {
        if (tagsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(tags_);
        } else {
          return tagsBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .Tag tags = 4;</code>
       */
      public int getTagsCount() {
        if (tagsBuilder_ == null) {
          return tags_.size();
        } else {
          return tagsBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .Tag tags = 4;</code>
       */
      public Messages.Tag getTags(int index) {
        if (tagsBuilder_ == null) {
          return tags_.get(index);
        } else {
          return tagsBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .Tag tags = 4;</code>
       */
      public Builder setTags(
          int index, Messages.Tag value) {
        if (tagsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTagsIsMutable();
          tags_.set(index, value);
          onChanged();
        } else {
          tagsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Tag tags = 4;</code>
       */
      public Builder setTags(
          int index, Messages.Tag.Builder builderForValue) {
        if (tagsBuilder_ == null) {
          ensureTagsIsMutable();
          tags_.set(index, builderForValue.build());
          onChanged();
        } else {
          tagsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Tag tags = 4;</code>
       */
      public Builder addTags(Messages.Tag value) {
        if (tagsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTagsIsMutable();
          tags_.add(value);
          onChanged();
        } else {
          tagsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .Tag tags = 4;</code>
       */
      public Builder addTags(
          int index, Messages.Tag value) {
        if (tagsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTagsIsMutable();
          tags_.add(index, value);
          onChanged();
        } else {
          tagsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Tag tags = 4;</code>
       */
      public Builder addTags(
          Messages.Tag.Builder builderForValue) {
        if (tagsBuilder_ == null) {
          ensureTagsIsMutable();
          tags_.add(builderForValue.build());
          onChanged();
        } else {
          tagsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Tag tags = 4;</code>
       */
      public Builder addTags(
          int index, Messages.Tag.Builder builderForValue) {
        if (tagsBuilder_ == null) {
          ensureTagsIsMutable();
          tags_.add(index, builderForValue.build());
          onChanged();
        } else {
          tagsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Tag tags = 4;</code>
       */
      public Builder addAllTags(
          java.lang.Iterable<? extends Messages.Tag> values) {
        if (tagsBuilder_ == null) {
          ensureTagsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, tags_);
          onChanged();
        } else {
          tagsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .Tag tags = 4;</code>
       */
      public Builder clearTags() {
        if (tagsBuilder_ == null) {
          tags_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
        } else {
          tagsBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .Tag tags = 4;</code>
       */
      public Builder removeTags(int index) {
        if (tagsBuilder_ == null) {
          ensureTagsIsMutable();
          tags_.remove(index);
          onChanged();
        } else {
          tagsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .Tag tags = 4;</code>
       */
      public Messages.Tag.Builder getTagsBuilder(
          int index) {
        return getTagsFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .Tag tags = 4;</code>
       */
      public Messages.TagOrBuilder getTagsOrBuilder(
          int index) {
        if (tagsBuilder_ == null) {
          return tags_.get(index);  } else {
          return tagsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .Tag tags = 4;</code>
       */
      public java.util.List<? extends Messages.TagOrBuilder> 
           getTagsOrBuilderList() {
        if (tagsBuilder_ != null) {
          return tagsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(tags_);
        }
      }
      /**
       * <code>repeated .Tag tags = 4;</code>
       */
      public Messages.Tag.Builder addTagsBuilder() {
        return getTagsFieldBuilder().addBuilder(
            Messages.Tag.getDefaultInstance());
      }
      /**
       * <code>repeated .Tag tags = 4;</code>
       */
      public Messages.Tag.Builder addTagsBuilder(
          int index) {
        return getTagsFieldBuilder().addBuilder(
            index, Messages.Tag.getDefaultInstance());
      }
      /**
       * <code>repeated .Tag tags = 4;</code>
       */
      public java.util.List<Messages.Tag.Builder> 
           getTagsBuilderList() {
        return getTagsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          Messages.Tag, Messages.Tag.Builder, Messages.TagOrBuilder> 
          getTagsFieldBuilder() {
        if (tagsBuilder_ == null) {
          tagsBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              Messages.Tag, Messages.Tag.Builder, Messages.TagOrBuilder>(
                  tags_,
                  ((bitField0_ & 0x00000008) == 0x00000008),
                  getParentForChildren(),
                  isClean());
          tags_ = null;
        }
        return tagsBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:Record)
    }

    static {
      defaultInstance = new Record(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Record)
  }

  public interface AggregatedRecordOrBuilder extends
      // @@protoc_insertion_point(interface_extends:AggregatedRecord)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>repeated string partition_key_table = 1;</code>
     */
    com.google.protobuf.ProtocolStringList
        getPartitionKeyTableList();
    /**
     * <code>repeated string partition_key_table = 1;</code>
     */
    int getPartitionKeyTableCount();
    /**
     * <code>repeated string partition_key_table = 1;</code>
     */
    java.lang.String getPartitionKeyTable(int index);
    /**
     * <code>repeated string partition_key_table = 1;</code>
     */
    com.google.protobuf.ByteString
        getPartitionKeyTableBytes(int index);

    /**
     * <code>repeated string explicit_hash_key_table = 2;</code>
     */
    com.google.protobuf.ProtocolStringList
        getExplicitHashKeyTableList();
    /**
     * <code>repeated string explicit_hash_key_table = 2;</code>
     */
    int getExplicitHashKeyTableCount();
    /**
     * <code>repeated string explicit_hash_key_table = 2;</code>
     */
    java.lang.String getExplicitHashKeyTable(int index);
    /**
     * <code>repeated string explicit_hash_key_table = 2;</code>
     */
    com.google.protobuf.ByteString
        getExplicitHashKeyTableBytes(int index);

    /**
     * <code>repeated .Record records = 3;</code>
     */
    java.util.List<Messages.Record> 
        getRecordsList();
    /**
     * <code>repeated .Record records = 3;</code>
     */
    Messages.Record getRecords(int index);
    /**
     * <code>repeated .Record records = 3;</code>
     */
    int getRecordsCount();
    /**
     * <code>repeated .Record records = 3;</code>
     */
    java.util.List<? extends Messages.RecordOrBuilder> 
        getRecordsOrBuilderList();
    /**
     * <code>repeated .Record records = 3;</code>
     */
    Messages.RecordOrBuilder getRecordsOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code AggregatedRecord}
   */
  public static final class AggregatedRecord extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:AggregatedRecord)
      AggregatedRecordOrBuilder {
    // Use AggregatedRecord.newBuilder() to construct.
    private AggregatedRecord(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private AggregatedRecord(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final AggregatedRecord defaultInstance;
    public static AggregatedRecord getDefaultInstance() {
      return defaultInstance;
    }

    public AggregatedRecord getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private AggregatedRecord(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              com.google.protobuf.ByteString bs = input.readBytes();
              if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                partitionKeyTable_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000001;
              }
              partitionKeyTable_.add(bs);
              break;
            }
            case 18: {
              com.google.protobuf.ByteString bs = input.readBytes();
              if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
                explicitHashKeyTable_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000002;
              }
              explicitHashKeyTable_.add(bs);
              break;
            }
            case 26: {
              if (!((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
                records_ = new java.util.ArrayList<Messages.Record>();
                mutable_bitField0_ |= 0x00000004;
              }
              records_.add(input.readMessage(Messages.Record.PARSER, extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
          partitionKeyTable_ = partitionKeyTable_.getUnmodifiableView();
        }
        if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
          explicitHashKeyTable_ = explicitHashKeyTable_.getUnmodifiableView();
        }
        if (((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
          records_ = java.util.Collections.unmodifiableList(records_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return Messages.internal_static_AggregatedRecord_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return Messages.internal_static_AggregatedRecord_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              Messages.AggregatedRecord.class, Messages.AggregatedRecord.Builder.class);
    }

    public static com.google.protobuf.Parser<AggregatedRecord> PARSER =
        new com.google.protobuf.AbstractParser<AggregatedRecord>() {
      public AggregatedRecord parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new AggregatedRecord(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<AggregatedRecord> getParserForType() {
      return PARSER;
    }

    public static final int PARTITION_KEY_TABLE_FIELD_NUMBER = 1;
    private com.google.protobuf.LazyStringList partitionKeyTable_;
    /**
     * <code>repeated string partition_key_table = 1;</code>
     */
    public com.google.protobuf.ProtocolStringList
        getPartitionKeyTableList() {
      return partitionKeyTable_;
    }
    /**
     * <code>repeated string partition_key_table = 1;</code>
     */
    public int getPartitionKeyTableCount() {
      return partitionKeyTable_.size();
    }
    /**
     * <code>repeated string partition_key_table = 1;</code>
     */
    public java.lang.String getPartitionKeyTable(int index) {
      return partitionKeyTable_.get(index);
    }
    /**
     * <code>repeated string partition_key_table = 1;</code>
     */
    public com.google.protobuf.ByteString
        getPartitionKeyTableBytes(int index) {
      return partitionKeyTable_.getByteString(index);
    }

    public static final int EXPLICIT_HASH_KEY_TABLE_FIELD_NUMBER = 2;
    private com.google.protobuf.LazyStringList explicitHashKeyTable_;
    /**
     * <code>repeated string explicit_hash_key_table = 2;</code>
     */
    public com.google.protobuf.ProtocolStringList
        getExplicitHashKeyTableList() {
      return explicitHashKeyTable_;
    }
    /**
     * <code>repeated string explicit_hash_key_table = 2;</code>
     */
    public int getExplicitHashKeyTableCount() {
      return explicitHashKeyTable_.size();
    }
    /**
     * <code>repeated string explicit_hash_key_table = 2;</code>
     */
    public java.lang.String getExplicitHashKeyTable(int index) {
      return explicitHashKeyTable_.get(index);
    }
    /**
     * <code>repeated string explicit_hash_key_table = 2;</code>
     */
    public com.google.protobuf.ByteString
        getExplicitHashKeyTableBytes(int index) {
      return explicitHashKeyTable_.getByteString(index);
    }

    public static final int RECORDS_FIELD_NUMBER = 3;
    private java.util.List<Messages.Record> records_;
    /**
     * <code>repeated .Record records = 3;</code>
     */
    public java.util.List<Messages.Record> getRecordsList() {
      return records_;
    }
    /**
     * <code>repeated .Record records = 3;</code>
     */
    public java.util.List<? extends Messages.RecordOrBuilder> 
        getRecordsOrBuilderList() {
      return records_;
    }
    /**
     * <code>repeated .Record records = 3;</code>
     */
    public int getRecordsCount() {
      return records_.size();
    }
    /**
     * <code>repeated .Record records = 3;</code>
     */
    public Messages.Record getRecords(int index) {
      return records_.get(index);
    }
    /**
     * <code>repeated .Record records = 3;</code>
     */
    public Messages.RecordOrBuilder getRecordsOrBuilder(
        int index) {
      return records_.get(index);
    }

    private void initFields() {
      partitionKeyTable_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      explicitHashKeyTable_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      records_ = java.util.Collections.emptyList();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      for (int i = 0; i < getRecordsCount(); i++) {
        if (!getRecords(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      for (int i = 0; i < partitionKeyTable_.size(); i++) {
        output.writeBytes(1, partitionKeyTable_.getByteString(i));
      }
      for (int i = 0; i < explicitHashKeyTable_.size(); i++) {
        output.writeBytes(2, explicitHashKeyTable_.getByteString(i));
      }
      for (int i = 0; i < records_.size(); i++) {
        output.writeMessage(3, records_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < partitionKeyTable_.size(); i++) {
          dataSize += com.google.protobuf.CodedOutputStream
            .computeBytesSizeNoTag(partitionKeyTable_.getByteString(i));
        }
        size += dataSize;
        size += 1 * getPartitionKeyTableList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < explicitHashKeyTable_.size(); i++) {
          dataSize += com.google.protobuf.CodedOutputStream
            .computeBytesSizeNoTag(explicitHashKeyTable_.getByteString(i));
        }
        size += dataSize;
        size += 1 * getExplicitHashKeyTableList().size();
      }
      for (int i = 0; i < records_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, records_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static Messages.AggregatedRecord parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static Messages.AggregatedRecord parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static Messages.AggregatedRecord parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static Messages.AggregatedRecord parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static Messages.AggregatedRecord parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static Messages.AggregatedRecord parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static Messages.AggregatedRecord parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static Messages.AggregatedRecord parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static Messages.AggregatedRecord parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static Messages.AggregatedRecord parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(Messages.AggregatedRecord prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code AggregatedRecord}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:AggregatedRecord)
        Messages.AggregatedRecordOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return Messages.internal_static_AggregatedRecord_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return Messages.internal_static_AggregatedRecord_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                Messages.AggregatedRecord.class, Messages.AggregatedRecord.Builder.class);
      }

      // Construct using Messages.AggregatedRecord.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getRecordsFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        partitionKeyTable_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        explicitHashKeyTable_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        if (recordsBuilder_ == null) {
          records_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          recordsBuilder_.clear();
        }
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return Messages.internal_static_AggregatedRecord_descriptor;
      }

      public Messages.AggregatedRecord getDefaultInstanceForType() {
        return Messages.AggregatedRecord.getDefaultInstance();
      }

      public Messages.AggregatedRecord build() {
        Messages.AggregatedRecord result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public Messages.AggregatedRecord buildPartial() {
        Messages.AggregatedRecord result = new Messages.AggregatedRecord(this);
        int from_bitField0_ = bitField0_;
        if (((bitField0_ & 0x00000001) == 0x00000001)) {
          partitionKeyTable_ = partitionKeyTable_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.partitionKeyTable_ = partitionKeyTable_;
        if (((bitField0_ & 0x00000002) == 0x00000002)) {
          explicitHashKeyTable_ = explicitHashKeyTable_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.explicitHashKeyTable_ = explicitHashKeyTable_;
        if (recordsBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004)) {
            records_ = java.util.Collections.unmodifiableList(records_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.records_ = records_;
        } else {
          result.records_ = recordsBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof Messages.AggregatedRecord) {
          return mergeFrom((Messages.AggregatedRecord)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(Messages.AggregatedRecord other) {
        if (other == Messages.AggregatedRecord.getDefaultInstance()) return this;
        if (!other.partitionKeyTable_.isEmpty()) {
          if (partitionKeyTable_.isEmpty()) {
            partitionKeyTable_ = other.partitionKeyTable_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensurePartitionKeyTableIsMutable();
            partitionKeyTable_.addAll(other.partitionKeyTable_);
          }
          onChanged();
        }
        if (!other.explicitHashKeyTable_.isEmpty()) {
          if (explicitHashKeyTable_.isEmpty()) {
            explicitHashKeyTable_ = other.explicitHashKeyTable_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureExplicitHashKeyTableIsMutable();
            explicitHashKeyTable_.addAll(other.explicitHashKeyTable_);
          }
          onChanged();
        }
        if (recordsBuilder_ == null) {
          if (!other.records_.isEmpty()) {
            if (records_.isEmpty()) {
              records_ = other.records_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureRecordsIsMutable();
              records_.addAll(other.records_);
            }
            onChanged();
          }
        } else {
          if (!other.records_.isEmpty()) {
            if (recordsBuilder_.isEmpty()) {
              recordsBuilder_.dispose();
              recordsBuilder_ = null;
              records_ = other.records_;
              bitField0_ = (bitField0_ & ~0x00000004);
              recordsBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getRecordsFieldBuilder() : null;
            } else {
              recordsBuilder_.addAllMessages(other.records_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        for (int i = 0; i < getRecordsCount(); i++) {
          if (!getRecords(i).isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        Messages.AggregatedRecord parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (Messages.AggregatedRecord) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private com.google.protobuf.LazyStringList partitionKeyTable_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensurePartitionKeyTableIsMutable() {
        if (!((bitField0_ & 0x00000001) == 0x00000001)) {
          partitionKeyTable_ = new com.google.protobuf.LazyStringArrayList(partitionKeyTable_);
          bitField0_ |= 0x00000001;
         }
      }
      /**
       * <code>repeated string partition_key_table = 1;</code>
       */
      public com.google.protobuf.ProtocolStringList
          getPartitionKeyTableList() {
        return partitionKeyTable_.getUnmodifiableView();
      }
      /**
       * <code>repeated string partition_key_table = 1;</code>
       */
      public int getPartitionKeyTableCount() {
        return partitionKeyTable_.size();
      }
      /**
       * <code>repeated string partition_key_table = 1;</code>
       */
      public java.lang.String getPartitionKeyTable(int index) {
        return partitionKeyTable_.get(index);
      }
      /**
       * <code>repeated string partition_key_table = 1;</code>
       */
      public com.google.protobuf.ByteString
          getPartitionKeyTableBytes(int index) {
        return partitionKeyTable_.getByteString(index);
      }
      /**
       * <code>repeated string partition_key_table = 1;</code>
       */
      public Builder setPartitionKeyTable(
          int index, java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensurePartitionKeyTableIsMutable();
        partitionKeyTable_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string partition_key_table = 1;</code>
       */
      public Builder addPartitionKeyTable(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensurePartitionKeyTableIsMutable();
        partitionKeyTable_.add(value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string partition_key_table = 1;</code>
       */
      public Builder addAllPartitionKeyTable(
          java.lang.Iterable<java.lang.String> values) {
        ensurePartitionKeyTableIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, partitionKeyTable_);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string partition_key_table = 1;</code>
       */
      public Builder clearPartitionKeyTable() {
        partitionKeyTable_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string partition_key_table = 1;</code>
       */
      public Builder addPartitionKeyTableBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensurePartitionKeyTableIsMutable();
        partitionKeyTable_.add(value);
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList explicitHashKeyTable_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensureExplicitHashKeyTableIsMutable() {
        if (!((bitField0_ & 0x00000002) == 0x00000002)) {
          explicitHashKeyTable_ = new com.google.protobuf.LazyStringArrayList(explicitHashKeyTable_);
          bitField0_ |= 0x00000002;
         }
      }
      /**
       * <code>repeated string explicit_hash_key_table = 2;</code>
       */
      public com.google.protobuf.ProtocolStringList
          getExplicitHashKeyTableList() {
        return explicitHashKeyTable_.getUnmodifiableView();
      }
      /**
       * <code>repeated string explicit_hash_key_table = 2;</code>
       */
      public int getExplicitHashKeyTableCount() {
        return explicitHashKeyTable_.size();
      }
      /**
       * <code>repeated string explicit_hash_key_table = 2;</code>
       */
      public java.lang.String getExplicitHashKeyTable(int index) {
        return explicitHashKeyTable_.get(index);
      }
      /**
       * <code>repeated string explicit_hash_key_table = 2;</code>
       */
      public com.google.protobuf.ByteString
          getExplicitHashKeyTableBytes(int index) {
        return explicitHashKeyTable_.getByteString(index);
      }
      /**
       * <code>repeated string explicit_hash_key_table = 2;</code>
       */
      public Builder setExplicitHashKeyTable(
          int index, java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureExplicitHashKeyTableIsMutable();
        explicitHashKeyTable_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string explicit_hash_key_table = 2;</code>
       */
      public Builder addExplicitHashKeyTable(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureExplicitHashKeyTableIsMutable();
        explicitHashKeyTable_.add(value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string explicit_hash_key_table = 2;</code>
       */
      public Builder addAllExplicitHashKeyTable(
          java.lang.Iterable<java.lang.String> values) {
        ensureExplicitHashKeyTableIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, explicitHashKeyTable_);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string explicit_hash_key_table = 2;</code>
       */
      public Builder clearExplicitHashKeyTable() {
        explicitHashKeyTable_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string explicit_hash_key_table = 2;</code>
       */
      public Builder addExplicitHashKeyTableBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureExplicitHashKeyTableIsMutable();
        explicitHashKeyTable_.add(value);
        onChanged();
        return this;
      }

      private java.util.List<Messages.Record> records_ =
        java.util.Collections.emptyList();
      private void ensureRecordsIsMutable() {
        if (!((bitField0_ & 0x00000004) == 0x00000004)) {
          records_ = new java.util.ArrayList<Messages.Record>(records_);
          bitField0_ |= 0x00000004;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          Messages.Record, Messages.Record.Builder, Messages.RecordOrBuilder> recordsBuilder_;

      /**
       * <code>repeated .Record records = 3;</code>
       */
      public java.util.List<Messages.Record> getRecordsList() {
        if (recordsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(records_);
        } else {
          return recordsBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .Record records = 3;</code>
       */
      public int getRecordsCount() {
        if (recordsBuilder_ == null) {
          return records_.size();
        } else {
          return recordsBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .Record records = 3;</code>
       */
      public Messages.Record getRecords(int index) {
        if (recordsBuilder_ == null) {
          return records_.get(index);
        } else {
          return recordsBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .Record records = 3;</code>
       */
      public Builder setRecords(
          int index, Messages.Record value) {
        if (recordsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRecordsIsMutable();
          records_.set(index, value);
          onChanged();
        } else {
          recordsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Record records = 3;</code>
       */
      public Builder setRecords(
          int index, Messages.Record.Builder builderForValue) {
        if (recordsBuilder_ == null) {
          ensureRecordsIsMutable();
          records_.set(index, builderForValue.build());
          onChanged();
        } else {
          recordsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Record records = 3;</code>
       */
      public Builder addRecords(Messages.Record value) {
        if (recordsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRecordsIsMutable();
          records_.add(value);
          onChanged();
        } else {
          recordsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .Record records = 3;</code>
       */
      public Builder addRecords(
          int index, Messages.Record value) {
        if (recordsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRecordsIsMutable();
          records_.add(index, value);
          onChanged();
        } else {
          recordsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Record records = 3;</code>
       */
      public Builder addRecords(
          Messages.Record.Builder builderForValue) {
        if (recordsBuilder_ == null) {
          ensureRecordsIsMutable();
          records_.add(builderForValue.build());
          onChanged();
        } else {
          recordsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Record records = 3;</code>
       */
      public Builder addRecords(
          int index, Messages.Record.Builder builderForValue) {
        if (recordsBuilder_ == null) {
          ensureRecordsIsMutable();
          records_.add(index, builderForValue.build());
          onChanged();
        } else {
          recordsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Record records = 3;</code>
       */
      public Builder addAllRecords(
          java.lang.Iterable<? extends Messages.Record> values) {
        if (recordsBuilder_ == null) {
          ensureRecordsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, records_);
          onChanged();
        } else {
          recordsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .Record records = 3;</code>
       */
      public Builder clearRecords() {
        if (recordsBuilder_ == null) {
          records_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          recordsBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .Record records = 3;</code>
       */
      public Builder removeRecords(int index) {
        if (recordsBuilder_ == null) {
          ensureRecordsIsMutable();
          records_.remove(index);
          onChanged();
        } else {
          recordsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .Record records = 3;</code>
       */
      public Messages.Record.Builder getRecordsBuilder(
          int index) {
        return getRecordsFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .Record records = 3;</code>
       */
      public Messages.RecordOrBuilder getRecordsOrBuilder(
          int index) {
        if (recordsBuilder_ == null) {
          return records_.get(index);  } else {
          return recordsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .Record records = 3;</code>
       */
      public java.util.List<? extends Messages.RecordOrBuilder> 
           getRecordsOrBuilderList() {
        if (recordsBuilder_ != null) {
          return recordsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(records_);
        }
      }
      /**
       * <code>repeated .Record records = 3;</code>
       */
      public Messages.Record.Builder addRecordsBuilder() {
        return getRecordsFieldBuilder().addBuilder(
            Messages.Record.getDefaultInstance());
      }
      /**
       * <code>repeated .Record records = 3;</code>
       */
      public Messages.Record.Builder addRecordsBuilder(
          int index) {
        return getRecordsFieldBuilder().addBuilder(
            index, Messages.Record.getDefaultInstance());
      }
      /**
       * <code>repeated .Record records = 3;</code>
       */
      public java.util.List<Messages.Record.Builder> 
           getRecordsBuilderList() {
        return getRecordsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          Messages.Record, Messages.Record.Builder, Messages.RecordOrBuilder> 
          getRecordsFieldBuilder() {
        if (recordsBuilder_ == null) {
          recordsBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              Messages.Record, Messages.Record.Builder, Messages.RecordOrBuilder>(
                  records_,
                  ((bitField0_ & 0x00000004) == 0x00000004),
                  getParentForChildren(),
                  isClean());
          records_ = null;
        }
        return recordsBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:AggregatedRecord)
    }

    static {
      defaultInstance = new AggregatedRecord(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:AggregatedRecord)
  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Tag_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Tag_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Record_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Record_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_AggregatedRecord_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_AggregatedRecord_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\016messages.proto\"!\n\003Tag\022\013\n\003key\030\001 \002(\t\022\r\n\005" +
      "value\030\002 \001(\t\"h\n\006Record\022\033\n\023partition_key_i" +
      "ndex\030\001 \002(\004\022\037\n\027explicit_hash_key_index\030\002 " +
      "\001(\004\022\014\n\004data\030\003 \002(\014\022\022\n\004tags\030\004 \003(\0132\004.Tag\"j\n" +
      "\020AggregatedRecord\022\033\n\023partition_key_table" +
      "\030\001 \003(\t\022\037\n\027explicit_hash_key_table\030\002 \003(\t\022" +
      "\030\n\007records\030\003 \003(\0132\007.Record"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
        }, assigner);
    internal_static_Tag_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_Tag_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Tag_descriptor,
        new java.lang.String[] { "Key", "Value", });
    internal_static_Record_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_Record_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Record_descriptor,
        new java.lang.String[] { "PartitionKeyIndex", "ExplicitHashKeyIndex", "Data", "Tags", });
    internal_static_AggregatedRecord_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_AggregatedRecord_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_AggregatedRecord_descriptor,
        new java.lang.String[] { "PartitionKeyTable", "ExplicitHashKeyTable", "Records", });
  }

  // @@protoc_insertion_point(outer_class_scope)
}
