/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.leases;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import software.amazon.kinesis.retrieval.kpl.ExtendedSequenceNumber;

public class Lease {
    private static final long MAX_ABS_AGE_NANOS = TimeUnit.DAYS.toNanos(365L);
    private String leaseKey;
    private String leaseOwner;
    private Long leaseCounter = 0L;
    private UUID concurrencyToken;
    private Long lastCounterIncrementNanos;
    private ExtendedSequenceNumber checkpoint;
    private ExtendedSequenceNumber pendingCheckpoint;
    private Long ownerSwitchesSinceCheckpoint = 0L;
    private Set<String> parentShardIds = new HashSet<String>();

    protected Lease(Lease lease) {
        this(lease.leaseKey(), lease.leaseOwner(), lease.leaseCounter(), lease.concurrencyToken(), lease.lastCounterIncrementNanos(), lease.checkpoint(), lease.pendingCheckpoint(), lease.ownerSwitchesSinceCheckpoint(), lease.parentShardIds());
    }

    public Lease(String leaseKey, String leaseOwner, Long leaseCounter, UUID concurrencyToken, Long lastCounterIncrementNanos, ExtendedSequenceNumber checkpoint, ExtendedSequenceNumber pendingCheckpoint, Long ownerSwitchesSinceCheckpoint, Set<String> parentShardIds) {
        this.leaseKey = leaseKey;
        this.leaseOwner = leaseOwner;
        this.leaseCounter = leaseCounter;
        this.concurrencyToken = concurrencyToken;
        this.lastCounterIncrementNanos = lastCounterIncrementNanos;
        this.checkpoint = checkpoint;
        this.pendingCheckpoint = pendingCheckpoint;
        this.ownerSwitchesSinceCheckpoint = ownerSwitchesSinceCheckpoint;
        if (parentShardIds != null) {
            this.parentShardIds.addAll(parentShardIds);
        }
    }

    public Set<String> parentShardIds() {
        return new HashSet<String>(this.parentShardIds);
    }

    public void update(Lease lease) {
        this.ownerSwitchesSinceCheckpoint(lease.ownerSwitchesSinceCheckpoint());
        this.checkpoint(lease.checkpoint);
        this.pendingCheckpoint(lease.pendingCheckpoint);
        this.parentShardIds(lease.parentShardIds);
    }

    public boolean isExpired(long leaseDurationNanos, long asOfNanos) {
        if (this.lastCounterIncrementNanos == null) {
            return true;
        }
        long age = asOfNanos - this.lastCounterIncrementNanos;
        if (Math.abs(age) > MAX_ABS_AGE_NANOS) {
            return true;
        }
        return age > leaseDurationNanos;
    }

    public void lastCounterIncrementNanos(Long lastCounterIncrementNanos) {
        this.lastCounterIncrementNanos = lastCounterIncrementNanos;
    }

    public void concurrencyToken(@NonNull UUID concurrencyToken) {
        if (concurrencyToken == null) {
            throw new NullPointerException("concurrencyToken");
        }
        this.concurrencyToken = concurrencyToken;
    }

    public void leaseKey(@NonNull String leaseKey) {
        if (leaseKey == null) {
            throw new NullPointerException("leaseKey");
        }
        if (this.leaseKey != null) {
            throw new IllegalArgumentException("LeaseKey is immutable once set");
        }
        this.leaseKey = leaseKey;
    }

    public void leaseCounter(@NonNull Long leaseCounter) {
        if (leaseCounter == null) {
            throw new NullPointerException("leaseCounter");
        }
        this.leaseCounter = leaseCounter;
    }

    public void checkpoint(@NonNull ExtendedSequenceNumber checkpoint) {
        if (checkpoint == null) {
            throw new NullPointerException("checkpoint");
        }
        this.checkpoint = checkpoint;
    }

    public void pendingCheckpoint(ExtendedSequenceNumber pendingCheckpoint) {
        this.pendingCheckpoint = pendingCheckpoint;
    }

    public void ownerSwitchesSinceCheckpoint(@NonNull Long ownerSwitchesSinceCheckpoint) {
        if (ownerSwitchesSinceCheckpoint == null) {
            throw new NullPointerException("ownerSwitchesSinceCheckpoint");
        }
        this.ownerSwitchesSinceCheckpoint = ownerSwitchesSinceCheckpoint;
    }

    public void parentShardIds(@NonNull Collection<String> parentShardIds) {
        if (parentShardIds == null) {
            throw new NullPointerException("parentShardIds");
        }
        this.parentShardIds.clear();
        this.parentShardIds.addAll(parentShardIds);
    }

    public void leaseOwner(String leaseOwner) {
        this.leaseOwner = leaseOwner;
    }

    public Lease copy() {
        return new Lease(this);
    }

    public Lease() {
    }

    public String leaseKey() {
        return this.leaseKey;
    }

    public String leaseOwner() {
        return this.leaseOwner;
    }

    public Long leaseCounter() {
        return this.leaseCounter;
    }

    public UUID concurrencyToken() {
        return this.concurrencyToken;
    }

    public Long lastCounterIncrementNanos() {
        return this.lastCounterIncrementNanos;
    }

    public ExtendedSequenceNumber checkpoint() {
        return this.checkpoint;
    }

    public ExtendedSequenceNumber pendingCheckpoint() {
        return this.pendingCheckpoint;
    }

    public Long ownerSwitchesSinceCheckpoint() {
        return this.ownerSwitchesSinceCheckpoint;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Lease)) {
            return false;
        }
        Lease other = (Lease)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$leaseKey = this.leaseKey();
        String other$leaseKey = other.leaseKey();
        if (this$leaseKey == null ? other$leaseKey != null : !this$leaseKey.equals(other$leaseKey)) {
            return false;
        }
        String this$leaseOwner = this.leaseOwner();
        String other$leaseOwner = other.leaseOwner();
        if (this$leaseOwner == null ? other$leaseOwner != null : !this$leaseOwner.equals(other$leaseOwner)) {
            return false;
        }
        Long this$leaseCounter = this.leaseCounter();
        Long other$leaseCounter = other.leaseCounter();
        if (this$leaseCounter == null ? other$leaseCounter != null : !((Object)this$leaseCounter).equals(other$leaseCounter)) {
            return false;
        }
        ExtendedSequenceNumber this$checkpoint = this.checkpoint();
        ExtendedSequenceNumber other$checkpoint = other.checkpoint();
        if (this$checkpoint == null ? other$checkpoint != null : !((Object)this$checkpoint).equals(other$checkpoint)) {
            return false;
        }
        ExtendedSequenceNumber this$pendingCheckpoint = this.pendingCheckpoint();
        ExtendedSequenceNumber other$pendingCheckpoint = other.pendingCheckpoint();
        if (this$pendingCheckpoint == null ? other$pendingCheckpoint != null : !((Object)this$pendingCheckpoint).equals(other$pendingCheckpoint)) {
            return false;
        }
        Long this$ownerSwitchesSinceCheckpoint = this.ownerSwitchesSinceCheckpoint();
        Long other$ownerSwitchesSinceCheckpoint = other.ownerSwitchesSinceCheckpoint();
        if (this$ownerSwitchesSinceCheckpoint == null ? other$ownerSwitchesSinceCheckpoint != null : !((Object)this$ownerSwitchesSinceCheckpoint).equals(other$ownerSwitchesSinceCheckpoint)) {
            return false;
        }
        Set<String> this$parentShardIds = this.parentShardIds();
        Set<String> other$parentShardIds = other.parentShardIds();
        return !(this$parentShardIds == null ? other$parentShardIds != null : !((Object)this$parentShardIds).equals(other$parentShardIds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Lease;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $leaseKey = this.leaseKey();
        result = result * 59 + ($leaseKey == null ? 43 : $leaseKey.hashCode());
        String $leaseOwner = this.leaseOwner();
        result = result * 59 + ($leaseOwner == null ? 43 : $leaseOwner.hashCode());
        Long $leaseCounter = this.leaseCounter();
        result = result * 59 + ($leaseCounter == null ? 43 : ((Object)$leaseCounter).hashCode());
        ExtendedSequenceNumber $checkpoint = this.checkpoint();
        result = result * 59 + ($checkpoint == null ? 43 : ((Object)$checkpoint).hashCode());
        ExtendedSequenceNumber $pendingCheckpoint = this.pendingCheckpoint();
        result = result * 59 + ($pendingCheckpoint == null ? 43 : ((Object)$pendingCheckpoint).hashCode());
        Long $ownerSwitchesSinceCheckpoint = this.ownerSwitchesSinceCheckpoint();
        result = result * 59 + ($ownerSwitchesSinceCheckpoint == null ? 43 : ((Object)$ownerSwitchesSinceCheckpoint).hashCode());
        Set<String> $parentShardIds = this.parentShardIds();
        result = result * 59 + ($parentShardIds == null ? 43 : ((Object)$parentShardIds).hashCode());
        return result;
    }

    public String toString() {
        return "Lease(leaseKey=" + this.leaseKey() + ", leaseOwner=" + this.leaseOwner() + ", leaseCounter=" + this.leaseCounter() + ", concurrencyToken=" + this.concurrencyToken() + ", lastCounterIncrementNanos=" + this.lastCounterIncrementNanos() + ", checkpoint=" + this.checkpoint() + ", pendingCheckpoint=" + this.pendingCheckpoint() + ", ownerSwitchesSinceCheckpoint=" + this.ownerSwitchesSinceCheckpoint() + ", parentShardIds=" + this.parentShardIds() + ")";
    }
}

