/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.leases;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.kinesis.common.InitialPositionInStream;
import software.amazon.kinesis.common.InitialPositionInStreamExtended;
import software.amazon.kinesis.leases.HierarchicalShardSyncer;
import software.amazon.kinesis.leases.LeaseManagementFactory;
import software.amazon.kinesis.leases.dynamodb.DynamoDBLeaseManagementFactory;
import software.amazon.kinesis.leases.dynamodb.TableCreatorCallback;
import software.amazon.kinesis.metrics.MetricsFactory;
import software.amazon.kinesis.metrics.NullMetricsFactory;

public class LeaseManagementConfig {
    @NonNull
    private final String tableName;
    @NonNull
    private final DynamoDbAsyncClient dynamoDBClient;
    @NonNull
    private final KinesisAsyncClient kinesisClient;
    @NonNull
    private final String streamName;
    @NonNull
    private final String workerIdentifier;
    private long failoverTimeMillis = 10000L;
    private long shardSyncIntervalMillis = 60000L;
    private boolean cleanupLeasesUponShardCompletion = true;
    private int maxLeasesForWorker = Integer.MAX_VALUE;
    private int maxLeasesToStealAtOneTime = 1;
    private int initialLeaseTableReadCapacity = 10;
    private int initialLeaseTableWriteCapacity = 10;
    private int maxLeaseRenewalThreads = 20;
    private boolean ignoreUnexpectedChildShards = false;
    private boolean consistentReads = false;
    private long listShardsBackoffTimeInMillis = 1500L;
    private int maxListShardsRetryAttempts = 50;
    public long epsilonMillis = 25L;
    private InitialPositionInStreamExtended initialPositionInStream = InitialPositionInStreamExtended.newInitialPosition(InitialPositionInStream.TRIM_HORIZON);
    private int maxCacheMissesBeforeReload = 1000;
    private long listShardsCacheAllowedAgeInSeconds = 30L;
    private int cacheMissWarningModulus = 250;
    private MetricsFactory metricsFactory = new NullMetricsFactory();
    private ExecutorService executorService = new LeaseManagementThreadPool(new ThreadFactoryBuilder().setNameFormat("ShardSyncTaskManager-%04d").build());
    private TableCreatorCallback tableCreatorCallback = TableCreatorCallback.NOOP_TABLE_CREATOR_CALLBACK;
    private HierarchicalShardSyncer hierarchicalShardSyncer = new HierarchicalShardSyncer();
    private LeaseManagementFactory leaseManagementFactory;

    @Deprecated
    public MetricsFactory metricsFactory() {
        return this.metricsFactory;
    }

    @Deprecated
    public LeaseManagementConfig metricsFactory(MetricsFactory metricsFactory) {
        this.metricsFactory = metricsFactory;
        return this;
    }

    public LeaseManagementFactory leaseManagementFactory() {
        if (this.leaseManagementFactory == null) {
            this.leaseManagementFactory = new DynamoDBLeaseManagementFactory(this.kinesisClient(), this.streamName(), this.dynamoDBClient(), this.tableName(), this.workerIdentifier(), this.executorService(), this.initialPositionInStream(), this.failoverTimeMillis(), this.epsilonMillis(), this.maxLeasesForWorker(), this.maxLeasesToStealAtOneTime(), this.maxLeaseRenewalThreads(), this.cleanupLeasesUponShardCompletion(), this.ignoreUnexpectedChildShards(), this.shardSyncIntervalMillis(), this.consistentReads(), this.listShardsBackoffTimeInMillis(), this.maxListShardsRetryAttempts(), this.maxCacheMissesBeforeReload(), this.listShardsCacheAllowedAgeInSeconds(), this.cacheMissWarningModulus(), this.initialLeaseTableReadCapacity(), this.initialLeaseTableWriteCapacity(), this.hierarchicalShardSyncer(), this.tableCreatorCallback());
        }
        return this.leaseManagementFactory;
    }

    public LeaseManagementConfig(@NonNull String tableName, @NonNull DynamoDbAsyncClient dynamoDBClient, @NonNull KinesisAsyncClient kinesisClient, @NonNull String streamName, @NonNull String workerIdentifier) {
        if (tableName == null) {
            throw new NullPointerException("tableName");
        }
        if (dynamoDBClient == null) {
            throw new NullPointerException("dynamoDBClient");
        }
        if (kinesisClient == null) {
            throw new NullPointerException("kinesisClient");
        }
        if (streamName == null) {
            throw new NullPointerException("streamName");
        }
        if (workerIdentifier == null) {
            throw new NullPointerException("workerIdentifier");
        }
        this.tableName = tableName;
        this.dynamoDBClient = dynamoDBClient;
        this.kinesisClient = kinesisClient;
        this.streamName = streamName;
        this.workerIdentifier = workerIdentifier;
    }

    @NonNull
    public String tableName() {
        return this.tableName;
    }

    @NonNull
    public DynamoDbAsyncClient dynamoDBClient() {
        return this.dynamoDBClient;
    }

    @NonNull
    public KinesisAsyncClient kinesisClient() {
        return this.kinesisClient;
    }

    @NonNull
    public String streamName() {
        return this.streamName;
    }

    @NonNull
    public String workerIdentifier() {
        return this.workerIdentifier;
    }

    public long failoverTimeMillis() {
        return this.failoverTimeMillis;
    }

    public long shardSyncIntervalMillis() {
        return this.shardSyncIntervalMillis;
    }

    public boolean cleanupLeasesUponShardCompletion() {
        return this.cleanupLeasesUponShardCompletion;
    }

    public int maxLeasesForWorker() {
        return this.maxLeasesForWorker;
    }

    public int maxLeasesToStealAtOneTime() {
        return this.maxLeasesToStealAtOneTime;
    }

    public int initialLeaseTableReadCapacity() {
        return this.initialLeaseTableReadCapacity;
    }

    public int initialLeaseTableWriteCapacity() {
        return this.initialLeaseTableWriteCapacity;
    }

    public int maxLeaseRenewalThreads() {
        return this.maxLeaseRenewalThreads;
    }

    public boolean ignoreUnexpectedChildShards() {
        return this.ignoreUnexpectedChildShards;
    }

    public boolean consistentReads() {
        return this.consistentReads;
    }

    public long listShardsBackoffTimeInMillis() {
        return this.listShardsBackoffTimeInMillis;
    }

    public int maxListShardsRetryAttempts() {
        return this.maxListShardsRetryAttempts;
    }

    public long epsilonMillis() {
        return this.epsilonMillis;
    }

    public InitialPositionInStreamExtended initialPositionInStream() {
        return this.initialPositionInStream;
    }

    public int maxCacheMissesBeforeReload() {
        return this.maxCacheMissesBeforeReload;
    }

    public long listShardsCacheAllowedAgeInSeconds() {
        return this.listShardsCacheAllowedAgeInSeconds;
    }

    public int cacheMissWarningModulus() {
        return this.cacheMissWarningModulus;
    }

    public ExecutorService executorService() {
        return this.executorService;
    }

    public TableCreatorCallback tableCreatorCallback() {
        return this.tableCreatorCallback;
    }

    public HierarchicalShardSyncer hierarchicalShardSyncer() {
        return this.hierarchicalShardSyncer;
    }

    public LeaseManagementConfig failoverTimeMillis(long failoverTimeMillis) {
        this.failoverTimeMillis = failoverTimeMillis;
        return this;
    }

    public LeaseManagementConfig shardSyncIntervalMillis(long shardSyncIntervalMillis) {
        this.shardSyncIntervalMillis = shardSyncIntervalMillis;
        return this;
    }

    public LeaseManagementConfig cleanupLeasesUponShardCompletion(boolean cleanupLeasesUponShardCompletion) {
        this.cleanupLeasesUponShardCompletion = cleanupLeasesUponShardCompletion;
        return this;
    }

    public LeaseManagementConfig maxLeasesForWorker(int maxLeasesForWorker) {
        this.maxLeasesForWorker = maxLeasesForWorker;
        return this;
    }

    public LeaseManagementConfig maxLeasesToStealAtOneTime(int maxLeasesToStealAtOneTime) {
        this.maxLeasesToStealAtOneTime = maxLeasesToStealAtOneTime;
        return this;
    }

    public LeaseManagementConfig initialLeaseTableReadCapacity(int initialLeaseTableReadCapacity) {
        this.initialLeaseTableReadCapacity = initialLeaseTableReadCapacity;
        return this;
    }

    public LeaseManagementConfig initialLeaseTableWriteCapacity(int initialLeaseTableWriteCapacity) {
        this.initialLeaseTableWriteCapacity = initialLeaseTableWriteCapacity;
        return this;
    }

    public LeaseManagementConfig maxLeaseRenewalThreads(int maxLeaseRenewalThreads) {
        this.maxLeaseRenewalThreads = maxLeaseRenewalThreads;
        return this;
    }

    public LeaseManagementConfig ignoreUnexpectedChildShards(boolean ignoreUnexpectedChildShards) {
        this.ignoreUnexpectedChildShards = ignoreUnexpectedChildShards;
        return this;
    }

    public LeaseManagementConfig consistentReads(boolean consistentReads) {
        this.consistentReads = consistentReads;
        return this;
    }

    public LeaseManagementConfig listShardsBackoffTimeInMillis(long listShardsBackoffTimeInMillis) {
        this.listShardsBackoffTimeInMillis = listShardsBackoffTimeInMillis;
        return this;
    }

    public LeaseManagementConfig maxListShardsRetryAttempts(int maxListShardsRetryAttempts) {
        this.maxListShardsRetryAttempts = maxListShardsRetryAttempts;
        return this;
    }

    public LeaseManagementConfig epsilonMillis(long epsilonMillis) {
        this.epsilonMillis = epsilonMillis;
        return this;
    }

    public LeaseManagementConfig initialPositionInStream(InitialPositionInStreamExtended initialPositionInStream) {
        this.initialPositionInStream = initialPositionInStream;
        return this;
    }

    public LeaseManagementConfig maxCacheMissesBeforeReload(int maxCacheMissesBeforeReload) {
        this.maxCacheMissesBeforeReload = maxCacheMissesBeforeReload;
        return this;
    }

    public LeaseManagementConfig listShardsCacheAllowedAgeInSeconds(long listShardsCacheAllowedAgeInSeconds) {
        this.listShardsCacheAllowedAgeInSeconds = listShardsCacheAllowedAgeInSeconds;
        return this;
    }

    public LeaseManagementConfig cacheMissWarningModulus(int cacheMissWarningModulus) {
        this.cacheMissWarningModulus = cacheMissWarningModulus;
        return this;
    }

    public LeaseManagementConfig executorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public LeaseManagementConfig tableCreatorCallback(TableCreatorCallback tableCreatorCallback) {
        this.tableCreatorCallback = tableCreatorCallback;
        return this;
    }

    public LeaseManagementConfig hierarchicalShardSyncer(HierarchicalShardSyncer hierarchicalShardSyncer) {
        this.hierarchicalShardSyncer = hierarchicalShardSyncer;
        return this;
    }

    public LeaseManagementConfig leaseManagementFactory(LeaseManagementFactory leaseManagementFactory) {
        this.leaseManagementFactory = leaseManagementFactory;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LeaseManagementConfig)) {
            return false;
        }
        LeaseManagementConfig other = (LeaseManagementConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$tableName = this.tableName();
        String other$tableName = other.tableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        DynamoDbAsyncClient this$dynamoDBClient = this.dynamoDBClient();
        DynamoDbAsyncClient other$dynamoDBClient = other.dynamoDBClient();
        if (this$dynamoDBClient == null ? other$dynamoDBClient != null : !this$dynamoDBClient.equals(other$dynamoDBClient)) {
            return false;
        }
        KinesisAsyncClient this$kinesisClient = this.kinesisClient();
        KinesisAsyncClient other$kinesisClient = other.kinesisClient();
        if (this$kinesisClient == null ? other$kinesisClient != null : !this$kinesisClient.equals(other$kinesisClient)) {
            return false;
        }
        String this$streamName = this.streamName();
        String other$streamName = other.streamName();
        if (this$streamName == null ? other$streamName != null : !this$streamName.equals(other$streamName)) {
            return false;
        }
        String this$workerIdentifier = this.workerIdentifier();
        String other$workerIdentifier = other.workerIdentifier();
        if (this$workerIdentifier == null ? other$workerIdentifier != null : !this$workerIdentifier.equals(other$workerIdentifier)) {
            return false;
        }
        if (this.failoverTimeMillis() != other.failoverTimeMillis()) {
            return false;
        }
        if (this.shardSyncIntervalMillis() != other.shardSyncIntervalMillis()) {
            return false;
        }
        if (this.cleanupLeasesUponShardCompletion() != other.cleanupLeasesUponShardCompletion()) {
            return false;
        }
        if (this.maxLeasesForWorker() != other.maxLeasesForWorker()) {
            return false;
        }
        if (this.maxLeasesToStealAtOneTime() != other.maxLeasesToStealAtOneTime()) {
            return false;
        }
        if (this.initialLeaseTableReadCapacity() != other.initialLeaseTableReadCapacity()) {
            return false;
        }
        if (this.initialLeaseTableWriteCapacity() != other.initialLeaseTableWriteCapacity()) {
            return false;
        }
        if (this.maxLeaseRenewalThreads() != other.maxLeaseRenewalThreads()) {
            return false;
        }
        if (this.ignoreUnexpectedChildShards() != other.ignoreUnexpectedChildShards()) {
            return false;
        }
        if (this.consistentReads() != other.consistentReads()) {
            return false;
        }
        if (this.listShardsBackoffTimeInMillis() != other.listShardsBackoffTimeInMillis()) {
            return false;
        }
        if (this.maxListShardsRetryAttempts() != other.maxListShardsRetryAttempts()) {
            return false;
        }
        if (this.epsilonMillis() != other.epsilonMillis()) {
            return false;
        }
        InitialPositionInStreamExtended this$initialPositionInStream = this.initialPositionInStream();
        InitialPositionInStreamExtended other$initialPositionInStream = other.initialPositionInStream();
        if (this$initialPositionInStream == null ? other$initialPositionInStream != null : !this$initialPositionInStream.equals(other$initialPositionInStream)) {
            return false;
        }
        if (this.maxCacheMissesBeforeReload() != other.maxCacheMissesBeforeReload()) {
            return false;
        }
        if (this.listShardsCacheAllowedAgeInSeconds() != other.listShardsCacheAllowedAgeInSeconds()) {
            return false;
        }
        if (this.cacheMissWarningModulus() != other.cacheMissWarningModulus()) {
            return false;
        }
        MetricsFactory this$metricsFactory = this.metricsFactory();
        MetricsFactory other$metricsFactory = other.metricsFactory();
        if (this$metricsFactory == null ? other$metricsFactory != null : !this$metricsFactory.equals(other$metricsFactory)) {
            return false;
        }
        ExecutorService this$executorService = this.executorService();
        ExecutorService other$executorService = other.executorService();
        if (this$executorService == null ? other$executorService != null : !this$executorService.equals(other$executorService)) {
            return false;
        }
        TableCreatorCallback this$tableCreatorCallback = this.tableCreatorCallback();
        TableCreatorCallback other$tableCreatorCallback = other.tableCreatorCallback();
        if (this$tableCreatorCallback == null ? other$tableCreatorCallback != null : !this$tableCreatorCallback.equals(other$tableCreatorCallback)) {
            return false;
        }
        HierarchicalShardSyncer this$hierarchicalShardSyncer = this.hierarchicalShardSyncer();
        HierarchicalShardSyncer other$hierarchicalShardSyncer = other.hierarchicalShardSyncer();
        if (this$hierarchicalShardSyncer == null ? other$hierarchicalShardSyncer != null : !this$hierarchicalShardSyncer.equals(other$hierarchicalShardSyncer)) {
            return false;
        }
        LeaseManagementFactory this$leaseManagementFactory = this.leaseManagementFactory();
        LeaseManagementFactory other$leaseManagementFactory = other.leaseManagementFactory();
        return !(this$leaseManagementFactory == null ? other$leaseManagementFactory != null : !this$leaseManagementFactory.equals(other$leaseManagementFactory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LeaseManagementConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tableName = this.tableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        DynamoDbAsyncClient $dynamoDBClient = this.dynamoDBClient();
        result = result * 59 + ($dynamoDBClient == null ? 43 : $dynamoDBClient.hashCode());
        KinesisAsyncClient $kinesisClient = this.kinesisClient();
        result = result * 59 + ($kinesisClient == null ? 43 : $kinesisClient.hashCode());
        String $streamName = this.streamName();
        result = result * 59 + ($streamName == null ? 43 : $streamName.hashCode());
        String $workerIdentifier = this.workerIdentifier();
        result = result * 59 + ($workerIdentifier == null ? 43 : $workerIdentifier.hashCode());
        long $failoverTimeMillis = this.failoverTimeMillis();
        result = result * 59 + (int)($failoverTimeMillis >>> 32 ^ $failoverTimeMillis);
        long $shardSyncIntervalMillis = this.shardSyncIntervalMillis();
        result = result * 59 + (int)($shardSyncIntervalMillis >>> 32 ^ $shardSyncIntervalMillis);
        result = result * 59 + (this.cleanupLeasesUponShardCompletion() ? 79 : 97);
        result = result * 59 + this.maxLeasesForWorker();
        result = result * 59 + this.maxLeasesToStealAtOneTime();
        result = result * 59 + this.initialLeaseTableReadCapacity();
        result = result * 59 + this.initialLeaseTableWriteCapacity();
        result = result * 59 + this.maxLeaseRenewalThreads();
        result = result * 59 + (this.ignoreUnexpectedChildShards() ? 79 : 97);
        result = result * 59 + (this.consistentReads() ? 79 : 97);
        long $listShardsBackoffTimeInMillis = this.listShardsBackoffTimeInMillis();
        result = result * 59 + (int)($listShardsBackoffTimeInMillis >>> 32 ^ $listShardsBackoffTimeInMillis);
        result = result * 59 + this.maxListShardsRetryAttempts();
        long $epsilonMillis = this.epsilonMillis();
        result = result * 59 + (int)($epsilonMillis >>> 32 ^ $epsilonMillis);
        InitialPositionInStreamExtended $initialPositionInStream = this.initialPositionInStream();
        result = result * 59 + ($initialPositionInStream == null ? 43 : $initialPositionInStream.hashCode());
        result = result * 59 + this.maxCacheMissesBeforeReload();
        long $listShardsCacheAllowedAgeInSeconds = this.listShardsCacheAllowedAgeInSeconds();
        result = result * 59 + (int)($listShardsCacheAllowedAgeInSeconds >>> 32 ^ $listShardsCacheAllowedAgeInSeconds);
        result = result * 59 + this.cacheMissWarningModulus();
        MetricsFactory $metricsFactory = this.metricsFactory();
        result = result * 59 + ($metricsFactory == null ? 43 : $metricsFactory.hashCode());
        ExecutorService $executorService = this.executorService();
        result = result * 59 + ($executorService == null ? 43 : $executorService.hashCode());
        TableCreatorCallback $tableCreatorCallback = this.tableCreatorCallback();
        result = result * 59 + ($tableCreatorCallback == null ? 43 : $tableCreatorCallback.hashCode());
        HierarchicalShardSyncer $hierarchicalShardSyncer = this.hierarchicalShardSyncer();
        result = result * 59 + ($hierarchicalShardSyncer == null ? 43 : $hierarchicalShardSyncer.hashCode());
        LeaseManagementFactory $leaseManagementFactory = this.leaseManagementFactory();
        result = result * 59 + ($leaseManagementFactory == null ? 43 : $leaseManagementFactory.hashCode());
        return result;
    }

    public String toString() {
        return "LeaseManagementConfig(tableName=" + this.tableName() + ", dynamoDBClient=" + this.dynamoDBClient() + ", kinesisClient=" + this.kinesisClient() + ", streamName=" + this.streamName() + ", workerIdentifier=" + this.workerIdentifier() + ", failoverTimeMillis=" + this.failoverTimeMillis() + ", shardSyncIntervalMillis=" + this.shardSyncIntervalMillis() + ", cleanupLeasesUponShardCompletion=" + this.cleanupLeasesUponShardCompletion() + ", maxLeasesForWorker=" + this.maxLeasesForWorker() + ", maxLeasesToStealAtOneTime=" + this.maxLeasesToStealAtOneTime() + ", initialLeaseTableReadCapacity=" + this.initialLeaseTableReadCapacity() + ", initialLeaseTableWriteCapacity=" + this.initialLeaseTableWriteCapacity() + ", maxLeaseRenewalThreads=" + this.maxLeaseRenewalThreads() + ", ignoreUnexpectedChildShards=" + this.ignoreUnexpectedChildShards() + ", consistentReads=" + this.consistentReads() + ", listShardsBackoffTimeInMillis=" + this.listShardsBackoffTimeInMillis() + ", maxListShardsRetryAttempts=" + this.maxListShardsRetryAttempts() + ", epsilonMillis=" + this.epsilonMillis() + ", initialPositionInStream=" + this.initialPositionInStream() + ", maxCacheMissesBeforeReload=" + this.maxCacheMissesBeforeReload() + ", listShardsCacheAllowedAgeInSeconds=" + this.listShardsCacheAllowedAgeInSeconds() + ", cacheMissWarningModulus=" + this.cacheMissWarningModulus() + ", metricsFactory=" + this.metricsFactory() + ", executorService=" + this.executorService() + ", tableCreatorCallback=" + this.tableCreatorCallback() + ", hierarchicalShardSyncer=" + this.hierarchicalShardSyncer() + ", leaseManagementFactory=" + this.leaseManagementFactory() + ")";
    }

    static class LeaseManagementThreadPool
    extends ThreadPoolExecutor {
        private static final long DEFAULT_KEEP_ALIVE_TIME = 60L;

        LeaseManagementThreadPool(ThreadFactory threadFactory) {
            super(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
        }
    }
}

