/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.lifecycle.events;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import software.amazon.kinesis.processor.RecordProcessorCheckpointer;
import software.amazon.kinesis.retrieval.KinesisClientRecord;

public class ProcessRecordsInput {
    private Instant cacheEntryTime;
    private Instant cacheExitTime;
    private boolean isAtShardEnd;
    private List<KinesisClientRecord> records;
    private RecordProcessorCheckpointer checkpointer;
    private Long millisBehindLatest;

    public Duration timeSpentInCache() {
        if (this.cacheEntryTime == null || this.cacheExitTime == null) {
            return Duration.ZERO;
        }
        return Duration.between(this.cacheEntryTime, this.cacheExitTime);
    }

    ProcessRecordsInput(Instant cacheEntryTime, Instant cacheExitTime, boolean isAtShardEnd, List<KinesisClientRecord> records, RecordProcessorCheckpointer checkpointer, Long millisBehindLatest) {
        this.cacheEntryTime = cacheEntryTime;
        this.cacheExitTime = cacheExitTime;
        this.isAtShardEnd = isAtShardEnd;
        this.records = records;
        this.checkpointer = checkpointer;
        this.millisBehindLatest = millisBehindLatest;
    }

    public static ProcessRecordsInputBuilder builder() {
        return new ProcessRecordsInputBuilder();
    }

    public ProcessRecordsInputBuilder toBuilder() {
        return new ProcessRecordsInputBuilder().cacheEntryTime(this.cacheEntryTime).cacheExitTime(this.cacheExitTime).isAtShardEnd(this.isAtShardEnd).records(this.records).checkpointer(this.checkpointer).millisBehindLatest(this.millisBehindLatest);
    }

    public Instant cacheEntryTime() {
        return this.cacheEntryTime;
    }

    public Instant cacheExitTime() {
        return this.cacheExitTime;
    }

    public boolean isAtShardEnd() {
        return this.isAtShardEnd;
    }

    public List<KinesisClientRecord> records() {
        return this.records;
    }

    public RecordProcessorCheckpointer checkpointer() {
        return this.checkpointer;
    }

    public Long millisBehindLatest() {
        return this.millisBehindLatest;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessRecordsInput)) {
            return false;
        }
        ProcessRecordsInput other = (ProcessRecordsInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Instant this$cacheEntryTime = this.cacheEntryTime();
        Instant other$cacheEntryTime = other.cacheEntryTime();
        if (this$cacheEntryTime == null ? other$cacheEntryTime != null : !((Object)this$cacheEntryTime).equals(other$cacheEntryTime)) {
            return false;
        }
        Instant this$cacheExitTime = this.cacheExitTime();
        Instant other$cacheExitTime = other.cacheExitTime();
        if (this$cacheExitTime == null ? other$cacheExitTime != null : !((Object)this$cacheExitTime).equals(other$cacheExitTime)) {
            return false;
        }
        if (this.isAtShardEnd() != other.isAtShardEnd()) {
            return false;
        }
        List<KinesisClientRecord> this$records = this.records();
        List<KinesisClientRecord> other$records = other.records();
        if (this$records == null ? other$records != null : !((Object)this$records).equals(other$records)) {
            return false;
        }
        RecordProcessorCheckpointer this$checkpointer = this.checkpointer();
        RecordProcessorCheckpointer other$checkpointer = other.checkpointer();
        if (this$checkpointer == null ? other$checkpointer != null : !this$checkpointer.equals(other$checkpointer)) {
            return false;
        }
        Long this$millisBehindLatest = this.millisBehindLatest();
        Long other$millisBehindLatest = other.millisBehindLatest();
        return !(this$millisBehindLatest == null ? other$millisBehindLatest != null : !((Object)this$millisBehindLatest).equals(other$millisBehindLatest));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProcessRecordsInput;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Instant $cacheEntryTime = this.cacheEntryTime();
        result = result * 59 + ($cacheEntryTime == null ? 43 : ((Object)$cacheEntryTime).hashCode());
        Instant $cacheExitTime = this.cacheExitTime();
        result = result * 59 + ($cacheExitTime == null ? 43 : ((Object)$cacheExitTime).hashCode());
        result = result * 59 + (this.isAtShardEnd() ? 79 : 97);
        List<KinesisClientRecord> $records = this.records();
        result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
        RecordProcessorCheckpointer $checkpointer = this.checkpointer();
        result = result * 59 + ($checkpointer == null ? 43 : $checkpointer.hashCode());
        Long $millisBehindLatest = this.millisBehindLatest();
        result = result * 59 + ($millisBehindLatest == null ? 43 : ((Object)$millisBehindLatest).hashCode());
        return result;
    }

    public String toString() {
        return "ProcessRecordsInput(cacheEntryTime=" + this.cacheEntryTime() + ", cacheExitTime=" + this.cacheExitTime() + ", isAtShardEnd=" + this.isAtShardEnd() + ", records=" + this.records() + ", checkpointer=" + this.checkpointer() + ", millisBehindLatest=" + this.millisBehindLatest() + ")";
    }

    public static class ProcessRecordsInputBuilder {
        private Instant cacheEntryTime;
        private Instant cacheExitTime;
        private boolean isAtShardEnd;
        private List<KinesisClientRecord> records;
        private RecordProcessorCheckpointer checkpointer;
        private Long millisBehindLatest;

        ProcessRecordsInputBuilder() {
        }

        public ProcessRecordsInputBuilder cacheEntryTime(Instant cacheEntryTime) {
            this.cacheEntryTime = cacheEntryTime;
            return this;
        }

        public ProcessRecordsInputBuilder cacheExitTime(Instant cacheExitTime) {
            this.cacheExitTime = cacheExitTime;
            return this;
        }

        public ProcessRecordsInputBuilder isAtShardEnd(boolean isAtShardEnd) {
            this.isAtShardEnd = isAtShardEnd;
            return this;
        }

        public ProcessRecordsInputBuilder records(List<KinesisClientRecord> records) {
            this.records = records;
            return this;
        }

        public ProcessRecordsInputBuilder checkpointer(RecordProcessorCheckpointer checkpointer) {
            this.checkpointer = checkpointer;
            return this;
        }

        public ProcessRecordsInputBuilder millisBehindLatest(Long millisBehindLatest) {
            this.millisBehindLatest = millisBehindLatest;
            return this;
        }

        public ProcessRecordsInput build() {
            return new ProcessRecordsInput(this.cacheEntryTime, this.cacheExitTime, this.isAtShardEnd, this.records, this.checkpointer, this.millisBehindLatest);
        }

        public String toString() {
            return "ProcessRecordsInput.ProcessRecordsInputBuilder(cacheEntryTime=" + this.cacheEntryTime + ", cacheExitTime=" + this.cacheExitTime + ", isAtShardEnd=" + this.isAtShardEnd + ", records=" + this.records + ", checkpointer=" + this.checkpointer + ", millisBehindLatest=" + this.millisBehindLatest + ")";
        }
    }
}

