/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.retrieval.polling;

import java.util.List;
import java.util.stream.Collectors;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.services.kinesis.model.GetRecordsResponse;
import software.amazon.kinesis.annotations.KinesisClientInternalApi;
import software.amazon.kinesis.common.InitialPositionInStreamExtended;
import software.amazon.kinesis.lifecycle.events.ProcessRecordsInput;
import software.amazon.kinesis.retrieval.GetRecordsRetrievalStrategy;
import software.amazon.kinesis.retrieval.KinesisClientRecord;
import software.amazon.kinesis.retrieval.RecordsPublisher;
import software.amazon.kinesis.retrieval.kpl.ExtendedSequenceNumber;

@KinesisClientInternalApi
public class BlockingRecordsPublisher
implements RecordsPublisher {
    private final int maxRecordsPerCall;
    private final GetRecordsRetrievalStrategy getRecordsRetrievalStrategy;
    private Subscriber<? super ProcessRecordsInput> subscriber;

    public BlockingRecordsPublisher(int maxRecordsPerCall, GetRecordsRetrievalStrategy getRecordsRetrievalStrategy) {
        this.maxRecordsPerCall = maxRecordsPerCall;
        this.getRecordsRetrievalStrategy = getRecordsRetrievalStrategy;
    }

    @Override
    public void start(ExtendedSequenceNumber extendedSequenceNumber, InitialPositionInStreamExtended initialPositionInStreamExtended) {
    }

    public ProcessRecordsInput getNextResult() {
        GetRecordsResponse getRecordsResult = this.getRecordsRetrievalStrategy.getRecords(this.maxRecordsPerCall);
        List<KinesisClientRecord> records = getRecordsResult.records().stream().map(KinesisClientRecord::fromRecord).collect(Collectors.toList());
        return ProcessRecordsInput.builder().records(records).millisBehindLatest(getRecordsResult.millisBehindLatest()).build();
    }

    @Override
    public void shutdown() {
        this.getRecordsRetrievalStrategy.shutdown();
    }

    public void subscribe(Subscriber<? super ProcessRecordsInput> s) {
        this.subscriber = s;
    }
}

