/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.coordinator;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.kinesis.annotations.KinesisClientInternalApi;
import software.amazon.kinesis.coordinator.DiagnosticEvent;
import software.amazon.kinesis.coordinator.DiagnosticEventHandler;
import software.amazon.kinesis.coordinator.ExecutorStateEvent;

@KinesisClientInternalApi
class RejectedTaskEvent
implements DiagnosticEvent {
    private static final Logger log = LoggerFactory.getLogger(RejectedTaskEvent.class);
    private static final String MESSAGE = "Review your thread configuration to prevent task rejections. Until next release, KCL will not be resilient to task rejections. ";
    private ExecutorStateEvent executorStateEvent;
    private Throwable throwable;

    RejectedTaskEvent(ExecutorStateEvent executorStateEvent, Throwable throwable) {
        this.executorStateEvent = executorStateEvent;
        this.throwable = throwable;
    }

    @Override
    public void accept(DiagnosticEventHandler visitor) {
        visitor.visit(this);
    }

    @Override
    public String message() {
        return MESSAGE + this.executorStateEvent.message();
    }

    public ExecutorStateEvent getExecutorStateEvent() {
        return this.executorStateEvent;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String toString() {
        return "RejectedTaskEvent(executorStateEvent=" + this.getExecutorStateEvent() + ", throwable=" + this.getThrowable() + ")";
    }
}

