/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.coordinator;

import com.google.common.annotations.VisibleForTesting;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.kinesis.checkpoint.CheckpointConfig;
import software.amazon.kinesis.checkpoint.ShardRecordProcessorCheckpointer;
import software.amazon.kinesis.common.InitialPositionInStreamExtended;
import software.amazon.kinesis.coordinator.CoordinatorConfig;
import software.amazon.kinesis.coordinator.DiagnosticEventFactory;
import software.amazon.kinesis.coordinator.DiagnosticEventHandler;
import software.amazon.kinesis.coordinator.DiagnosticEventLogger;
import software.amazon.kinesis.coordinator.ExecutorStateEvent;
import software.amazon.kinesis.coordinator.GracefulShutdownContext;
import software.amazon.kinesis.coordinator.GracefulShutdownCoordinator;
import software.amazon.kinesis.coordinator.RejectedTaskEvent;
import software.amazon.kinesis.coordinator.SchedulerCoordinatorFactory;
import software.amazon.kinesis.coordinator.WorkerStateChangeListener;
import software.amazon.kinesis.leases.HierarchicalShardSyncer;
import software.amazon.kinesis.leases.Lease;
import software.amazon.kinesis.leases.LeaseCoordinator;
import software.amazon.kinesis.leases.LeaseManagementConfig;
import software.amazon.kinesis.leases.LeaseRefresher;
import software.amazon.kinesis.leases.ShardDetector;
import software.amazon.kinesis.leases.ShardInfo;
import software.amazon.kinesis.leases.ShardPrioritization;
import software.amazon.kinesis.leases.ShardSyncTask;
import software.amazon.kinesis.leases.ShardSyncTaskManager;
import software.amazon.kinesis.leases.dynamodb.DynamoDBLeaseCoordinator;
import software.amazon.kinesis.leases.exceptions.LeasingException;
import software.amazon.kinesis.lifecycle.LifecycleConfig;
import software.amazon.kinesis.lifecycle.ShardConsumer;
import software.amazon.kinesis.lifecycle.ShardConsumerArgument;
import software.amazon.kinesis.lifecycle.ShardConsumerShutdownNotification;
import software.amazon.kinesis.lifecycle.ShutdownReason;
import software.amazon.kinesis.lifecycle.TaskResult;
import software.amazon.kinesis.metrics.CloudWatchMetricsFactory;
import software.amazon.kinesis.metrics.MetricsCollectingTaskDecorator;
import software.amazon.kinesis.metrics.MetricsConfig;
import software.amazon.kinesis.metrics.MetricsFactory;
import software.amazon.kinesis.processor.Checkpointer;
import software.amazon.kinesis.processor.ProcessorConfig;
import software.amazon.kinesis.processor.ShardRecordProcessorFactory;
import software.amazon.kinesis.retrieval.AggregatorUtil;
import software.amazon.kinesis.retrieval.RecordsPublisher;
import software.amazon.kinesis.retrieval.RetrievalConfig;

public class Scheduler
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(Scheduler.class);
    private SchedulerLog slog = new SchedulerLog();
    private final CheckpointConfig checkpointConfig;
    private final CoordinatorConfig coordinatorConfig;
    private final LeaseManagementConfig leaseManagementConfig;
    private final LifecycleConfig lifecycleConfig;
    private final MetricsConfig metricsConfig;
    private final ProcessorConfig processorConfig;
    private final RetrievalConfig retrievalConfig;
    private final String applicationName;
    private final int maxInitializationAttempts;
    private final Checkpointer checkpoint;
    private final long shardConsumerDispatchPollIntervalMillis;
    private final long parentShardPollIntervalMillis;
    private final ExecutorService executorService;
    private final DiagnosticEventFactory diagnosticEventFactory;
    private final DiagnosticEventHandler diagnosticEventHandler;
    private final LeaseCoordinator leaseCoordinator;
    private final ShardSyncTaskManager shardSyncTaskManager;
    private final ShardPrioritization shardPrioritization;
    private final boolean cleanupLeasesUponShardCompletion;
    private final boolean skipShardSyncAtWorkerInitializationIfLeasesExist;
    private final GracefulShutdownCoordinator gracefulShutdownCoordinator;
    private final WorkerStateChangeListener workerStateChangeListener;
    private final InitialPositionInStreamExtended initialPosition;
    private final MetricsFactory metricsFactory;
    private final long failoverTimeMillis;
    private final long taskBackoffTimeMillis;
    private final String streamName;
    private final long listShardsBackoffTimeMillis;
    private final int maxListShardsRetryAttempts;
    private final LeaseRefresher leaseRefresher;
    private final ShardDetector shardDetector;
    private final boolean ignoreUnexpetedChildShards;
    private final AggregatorUtil aggregatorUtil;
    private final HierarchicalShardSyncer hierarchicalShardSyncer;
    private ConcurrentMap<ShardInfo, ShardConsumer> shardInfoShardConsumerMap = new ConcurrentHashMap<ShardInfo, ShardConsumer>();
    private volatile boolean shutdown;
    private volatile long shutdownStartTimeMillis;
    private volatile boolean shutdownComplete = false;
    private final Object lock = new Object();
    private Future<Boolean> gracefulShutdownFuture;
    @VisibleForTesting
    protected boolean gracefuleShutdownStarted = false;

    public Scheduler(@NonNull CheckpointConfig checkpointConfig, @NonNull CoordinatorConfig coordinatorConfig, @NonNull LeaseManagementConfig leaseManagementConfig, @NonNull LifecycleConfig lifecycleConfig, @NonNull MetricsConfig metricsConfig, @NonNull ProcessorConfig processorConfig, @NonNull RetrievalConfig retrievalConfig) {
        this(checkpointConfig, coordinatorConfig, leaseManagementConfig, lifecycleConfig, metricsConfig, processorConfig, retrievalConfig, new DiagnosticEventFactory());
        if (checkpointConfig == null) {
            throw new NullPointerException("checkpointConfig");
        }
        if (coordinatorConfig == null) {
            throw new NullPointerException("coordinatorConfig");
        }
        if (leaseManagementConfig == null) {
            throw new NullPointerException("leaseManagementConfig");
        }
        if (lifecycleConfig == null) {
            throw new NullPointerException("lifecycleConfig");
        }
        if (metricsConfig == null) {
            throw new NullPointerException("metricsConfig");
        }
        if (processorConfig == null) {
            throw new NullPointerException("processorConfig");
        }
        if (retrievalConfig == null) {
            throw new NullPointerException("retrievalConfig");
        }
    }

    @VisibleForTesting
    protected Scheduler(@NonNull CheckpointConfig checkpointConfig, @NonNull CoordinatorConfig coordinatorConfig, @NonNull LeaseManagementConfig leaseManagementConfig, @NonNull LifecycleConfig lifecycleConfig, @NonNull MetricsConfig metricsConfig, @NonNull ProcessorConfig processorConfig, @NonNull RetrievalConfig retrievalConfig, @NonNull DiagnosticEventFactory diagnosticEventFactory) {
        if (checkpointConfig == null) {
            throw new NullPointerException("checkpointConfig");
        }
        if (coordinatorConfig == null) {
            throw new NullPointerException("coordinatorConfig");
        }
        if (leaseManagementConfig == null) {
            throw new NullPointerException("leaseManagementConfig");
        }
        if (lifecycleConfig == null) {
            throw new NullPointerException("lifecycleConfig");
        }
        if (metricsConfig == null) {
            throw new NullPointerException("metricsConfig");
        }
        if (processorConfig == null) {
            throw new NullPointerException("processorConfig");
        }
        if (retrievalConfig == null) {
            throw new NullPointerException("retrievalConfig");
        }
        if (diagnosticEventFactory == null) {
            throw new NullPointerException("diagnosticEventFactory");
        }
        this.checkpointConfig = checkpointConfig;
        this.coordinatorConfig = coordinatorConfig;
        this.leaseManagementConfig = leaseManagementConfig;
        this.lifecycleConfig = lifecycleConfig;
        this.metricsConfig = metricsConfig;
        this.processorConfig = processorConfig;
        this.retrievalConfig = retrievalConfig;
        this.applicationName = this.coordinatorConfig.applicationName();
        this.maxInitializationAttempts = this.coordinatorConfig.maxInitializationAttempts();
        this.metricsFactory = this.metricsConfig.metricsFactory();
        this.leaseCoordinator = this.leaseManagementConfig.leaseManagementFactory().createLeaseCoordinator(this.metricsFactory);
        this.leaseRefresher = this.leaseCoordinator.leaseRefresher();
        this.checkpoint = this.checkpointConfig.checkpointFactory().createCheckpointer(this.leaseCoordinator, this.leaseRefresher);
        this.shardConsumerDispatchPollIntervalMillis = this.coordinatorConfig.shardConsumerDispatchPollIntervalMillis();
        this.parentShardPollIntervalMillis = this.coordinatorConfig.parentShardPollIntervalMillis();
        this.executorService = this.coordinatorConfig.coordinatorFactory().createExecutorService();
        this.diagnosticEventFactory = diagnosticEventFactory;
        this.diagnosticEventHandler = new DiagnosticEventLogger();
        this.shardSyncTaskManager = this.leaseManagementConfig.leaseManagementFactory().createShardSyncTaskManager(this.metricsFactory);
        this.shardPrioritization = this.coordinatorConfig.shardPrioritization();
        this.cleanupLeasesUponShardCompletion = this.leaseManagementConfig.cleanupLeasesUponShardCompletion();
        this.skipShardSyncAtWorkerInitializationIfLeasesExist = this.coordinatorConfig.skipShardSyncAtWorkerInitializationIfLeasesExist();
        this.gracefulShutdownCoordinator = coordinatorConfig.gracefulShutdownCoordinator() != null ? coordinatorConfig.gracefulShutdownCoordinator() : this.coordinatorConfig.coordinatorFactory().createGracefulShutdownCoordinator();
        this.workerStateChangeListener = coordinatorConfig.workerStateChangeListener() != null ? coordinatorConfig.workerStateChangeListener() : this.coordinatorConfig.coordinatorFactory().createWorkerStateChangeListener();
        this.initialPosition = retrievalConfig.initialPositionInStreamExtended();
        this.failoverTimeMillis = this.leaseManagementConfig.failoverTimeMillis();
        this.taskBackoffTimeMillis = this.lifecycleConfig.taskBackoffTimeMillis();
        this.streamName = this.retrievalConfig.streamName();
        this.listShardsBackoffTimeMillis = this.retrievalConfig.listShardsBackoffTimeInMillis();
        this.maxListShardsRetryAttempts = this.retrievalConfig.maxListShardsRetryAttempts();
        this.shardDetector = this.shardSyncTaskManager.shardDetector();
        this.ignoreUnexpetedChildShards = this.leaseManagementConfig.ignoreUnexpectedChildShards();
        this.aggregatorUtil = this.lifecycleConfig.aggregatorUtil();
        this.hierarchicalShardSyncer = leaseManagementConfig.hierarchicalShardSyncer();
    }

    @Override
    public void run() {
        if (this.shutdown) {
            return;
        }
        try {
            this.initialize();
            log.info("Initialization complete. Starting worker loop.");
        }
        catch (RuntimeException e) {
            log.error("Unable to initialize after {} attempts. Shutting down.", (Object)this.maxInitializationAttempts, (Object)e);
            this.workerStateChangeListener.onAllInitializationAttemptsFailed(e);
            this.shutdown();
        }
        while (!this.shouldShutdown()) {
            this.runProcessLoop();
        }
        this.finalShutdown();
        log.info("Worker loop is complete. Exiting from worker.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void initialize() {
        Object object = this.lock;
        synchronized (object) {
            this.registerErrorHandlerForUndeliverableAsyncTaskExceptions();
            this.workerStateChangeListener.onWorkerStateChange(WorkerStateChangeListener.WorkerState.INITIALIZING);
            boolean isDone = false;
            Exception lastException = null;
            for (int i = 0; !isDone && i < this.maxInitializationAttempts; ++i) {
                try {
                    log.info("Initialization attempt {}", (Object)(i + 1));
                    log.info("Initializing LeaseCoordinator");
                    this.leaseCoordinator.initialize();
                    TaskResult result = null;
                    if (!this.skipShardSyncAtWorkerInitializationIfLeasesExist || this.leaseRefresher.isLeaseTableEmpty()) {
                        log.info("Syncing Kinesis shard info");
                        ShardSyncTask shardSyncTask = new ShardSyncTask(this.shardDetector, this.leaseRefresher, this.initialPosition, this.cleanupLeasesUponShardCompletion, this.ignoreUnexpetedChildShards, 0L, this.hierarchicalShardSyncer, this.metricsFactory);
                        result = new MetricsCollectingTaskDecorator(shardSyncTask, this.metricsFactory).call();
                    } else {
                        log.info("Skipping shard sync per configuration setting (and lease table is not empty)");
                    }
                    if (result == null || result.getException() == null) {
                        if (!this.leaseCoordinator.isRunning()) {
                            log.info("Starting LeaseCoordinator");
                            this.leaseCoordinator.start();
                        } else {
                            log.info("LeaseCoordinator is already running. No need to start it.");
                        }
                        isDone = true;
                    } else {
                        lastException = result.getException();
                    }
                }
                catch (LeasingException e) {
                    log.error("Caught exception when initializing LeaseCoordinator", (Throwable)e);
                    lastException = e;
                }
                catch (Exception e) {
                    lastException = e;
                }
                try {
                    Thread.sleep(this.parentShardPollIntervalMillis);
                    continue;
                }
                catch (InterruptedException e) {
                    log.debug("Sleep interrupted while initializing worker.");
                }
            }
            if (!isDone) {
                throw new RuntimeException(lastException);
            }
            this.workerStateChangeListener.onWorkerStateChange(WorkerStateChangeListener.WorkerState.STARTED);
        }
    }

    @VisibleForTesting
    void runProcessLoop() {
        try {
            boolean foundCompletedShard = false;
            HashSet<ShardInfo> assignedShards = new HashSet<ShardInfo>();
            for (ShardInfo shardInfo : this.getShardInfoForAssignments()) {
                ShardConsumer shardConsumer = this.createOrGetShardConsumer(shardInfo, this.processorConfig.shardRecordProcessorFactory());
                if (shardConsumer.isShutdown() && shardConsumer.shutdownReason().equals((Object)ShutdownReason.SHARD_END)) {
                    foundCompletedShard = true;
                } else {
                    shardConsumer.executeLifecycle();
                }
                assignedShards.add(shardInfo);
            }
            if (foundCompletedShard) {
                this.shardSyncTaskManager.syncShardAndLeaseInfo();
            }
            this.cleanupShardConsumers(assignedShards);
            this.logExecutorState();
            this.slog.info("Sleeping ...");
            Thread.sleep(this.shardConsumerDispatchPollIntervalMillis);
        }
        catch (Exception e) {
            log.error("Worker.run caught exception, sleeping for {} milli seconds!", (Object)String.valueOf(this.shardConsumerDispatchPollIntervalMillis), (Object)e);
            try {
                Thread.sleep(this.shardConsumerDispatchPollIntervalMillis);
            }
            catch (InterruptedException ex) {
                log.info("Worker: sleep interrupted after catching exception ", (Throwable)ex);
            }
        }
        this.slog.resetInfoLogging();
    }

    @VisibleForTesting
    boolean shouldShutdown() {
        if (this.executorService.isShutdown()) {
            log.error("Worker executor service has been shutdown, so record processors cannot be shutdown.");
            return true;
        }
        if (this.shutdown) {
            if (this.shardInfoShardConsumerMap.isEmpty()) {
                log.info("All record processors have been shutdown successfully.");
                return true;
            }
            if (System.currentTimeMillis() - this.shutdownStartTimeMillis >= this.failoverTimeMillis) {
                log.info("Lease failover time is reached, so forcing shutdown.");
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Boolean> startGracefulShutdown() {
        Scheduler scheduler = this;
        synchronized (scheduler) {
            if (this.gracefulShutdownFuture == null) {
                this.gracefulShutdownFuture = this.gracefulShutdownCoordinator.startGracefulShutdown(this.createGracefulShutdownCallable());
            }
        }
        return this.gracefulShutdownFuture;
    }

    public Callable<Boolean> createGracefulShutdownCallable() {
        if (this.shutdownComplete()) {
            return () -> true;
        }
        Callable<GracefulShutdownContext> startShutdown = this.createWorkerShutdownCallable();
        return this.gracefulShutdownCoordinator.createGracefulShutdownCallable(startShutdown);
    }

    public boolean hasGracefulShutdownStarted() {
        return this.gracefuleShutdownStarted;
    }

    @VisibleForTesting
    Callable<GracefulShutdownContext> createWorkerShutdownCallable() {
        return () -> {
            Scheduler scheduler = this;
            synchronized (scheduler) {
                if (this.gracefuleShutdownStarted) {
                    throw new IllegalStateException("Requested shutdown has already been started");
                }
                this.gracefuleShutdownStarted = true;
            }
            this.leaseCoordinator.stopLeaseTaker();
            Collection<Lease> leases = this.leaseCoordinator.getAssignments();
            if (leases == null || leases.isEmpty()) {
                this.shutdown();
                return GracefulShutdownContext.SHUTDOWN_ALREADY_COMPLETED;
            }
            CountDownLatch shutdownCompleteLatch = new CountDownLatch(leases.size());
            CountDownLatch notificationCompleteLatch = new CountDownLatch(leases.size());
            for (Lease lease : leases) {
                ShardConsumerShutdownNotification shutdownNotification = new ShardConsumerShutdownNotification(this.leaseCoordinator, lease, notificationCompleteLatch, shutdownCompleteLatch);
                ShardInfo shardInfo = DynamoDBLeaseCoordinator.convertLeaseToAssignment(lease);
                ShardConsumer consumer = (ShardConsumer)this.shardInfoShardConsumerMap.get(shardInfo);
                if (consumer != null) {
                    consumer.gracefulShutdown(shutdownNotification);
                    continue;
                }
                notificationCompleteLatch.countDown();
                shutdownCompleteLatch.countDown();
            }
            return new GracefulShutdownContext(shutdownCompleteLatch, notificationCompleteLatch, this);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                log.warn("Shutdown requested a second time.");
                return;
            }
            this.workerStateChangeListener.onWorkerStateChange(WorkerStateChangeListener.WorkerState.SHUT_DOWN_STARTED);
            log.info("Worker shutdown requested.");
            this.shutdown = true;
            this.shutdownStartTimeMillis = System.currentTimeMillis();
            this.leaseCoordinator.stop();
            this.workerStateChangeListener.onWorkerStateChange(WorkerStateChangeListener.WorkerState.SHUT_DOWN);
        }
    }

    private void finalShutdown() {
        log.info("Starting worker's final shutdown.");
        if (this.executorService instanceof SchedulerCoordinatorFactory.SchedulerThreadPoolExecutor) {
            this.executorService.shutdownNow();
        }
        if (this.metricsFactory instanceof CloudWatchMetricsFactory) {
            ((CloudWatchMetricsFactory)this.metricsFactory).shutdown();
        }
        this.shutdownComplete = true;
    }

    private List<ShardInfo> getShardInfoForAssignments() {
        List<ShardInfo> assignedStreamShards = this.leaseCoordinator.getCurrentAssignments();
        List<ShardInfo> prioritizedShards = this.shardPrioritization.prioritize(assignedStreamShards);
        if (prioritizedShards != null && !prioritizedShards.isEmpty()) {
            if (this.slog.isInfoEnabled()) {
                StringBuilder builder = new StringBuilder();
                boolean firstItem = true;
                for (ShardInfo shardInfo : prioritizedShards) {
                    if (!firstItem) {
                        builder.append(", ");
                    }
                    builder.append(shardInfo.shardId());
                    firstItem = false;
                }
                this.slog.info("Current stream shard assignments: " + builder.toString());
            }
        } else {
            this.slog.info("No activities assigned");
        }
        return prioritizedShards;
    }

    ShardConsumer createOrGetShardConsumer(@NonNull ShardInfo shardInfo, @NonNull ShardRecordProcessorFactory shardRecordProcessorFactory) {
        if (shardInfo == null) {
            throw new NullPointerException("shardInfo");
        }
        if (shardRecordProcessorFactory == null) {
            throw new NullPointerException("shardRecordProcessorFactory");
        }
        ShardConsumer consumer = (ShardConsumer)this.shardInfoShardConsumerMap.get(shardInfo);
        if (consumer == null || consumer.isShutdown() && consumer.shutdownReason().equals((Object)ShutdownReason.LEASE_LOST)) {
            consumer = this.buildConsumer(shardInfo, shardRecordProcessorFactory);
            this.shardInfoShardConsumerMap.put(shardInfo, consumer);
            this.slog.infoForce("Created new shardConsumer for : " + shardInfo);
        }
        return consumer;
    }

    protected ShardConsumer buildConsumer(@NonNull ShardInfo shardInfo, @NonNull ShardRecordProcessorFactory shardRecordProcessorFactory) {
        if (shardInfo == null) {
            throw new NullPointerException("shardInfo");
        }
        if (shardRecordProcessorFactory == null) {
            throw new NullPointerException("shardRecordProcessorFactory");
        }
        RecordsPublisher cache = this.retrievalConfig.retrievalFactory().createGetRecordsCache(shardInfo, this.metricsFactory);
        ShardRecordProcessorCheckpointer checkpointer = this.coordinatorConfig.coordinatorFactory().createRecordProcessorCheckpointer(shardInfo, this.checkpoint);
        ShardConsumerArgument argument = new ShardConsumerArgument(shardInfo, this.streamName, this.leaseRefresher, this.executorService, cache, shardRecordProcessorFactory.shardRecordProcessor(), this.checkpoint, checkpointer, this.parentShardPollIntervalMillis, this.taskBackoffTimeMillis, this.skipShardSyncAtWorkerInitializationIfLeasesExist, this.listShardsBackoffTimeMillis, this.maxListShardsRetryAttempts, this.processorConfig.callProcessRecordsEvenForEmptyRecordList(), this.shardConsumerDispatchPollIntervalMillis, this.initialPosition, this.cleanupLeasesUponShardCompletion, this.ignoreUnexpetedChildShards, this.shardDetector, this.aggregatorUtil, this.hierarchicalShardSyncer, this.metricsFactory);
        return new ShardConsumer(cache, this.executorService, shardInfo, this.lifecycleConfig.logWarningForTaskAfterMillis(), argument, this.lifecycleConfig.taskExecutionListener(), this.lifecycleConfig.readTimeoutsToIgnoreBeforeWarning());
    }

    void cleanupShardConsumers(Set<ShardInfo> assignedShards) {
        for (ShardInfo shard : this.shardInfoShardConsumerMap.keySet()) {
            if (assignedShards.contains(shard)) continue;
            ShardConsumer consumer = (ShardConsumer)this.shardInfoShardConsumerMap.get(shard);
            if (consumer.leaseLost()) {
                this.shardInfoShardConsumerMap.remove(shard);
                log.debug("Removed consumer for {} as lease has been lost", (Object)shard.shardId());
                continue;
            }
            consumer.executeLifecycle();
        }
    }

    private void registerErrorHandlerForUndeliverableAsyncTaskExceptions() {
        RxJavaPlugins.setErrorHandler(t -> {
            ExecutorStateEvent executorStateEvent = this.diagnosticEventFactory.executorStateEvent(this.executorService, this.leaseCoordinator);
            RejectedTaskEvent rejectedTaskEvent = this.diagnosticEventFactory.rejectedTaskEvent(executorStateEvent, (Throwable)t);
            rejectedTaskEvent.accept(this.diagnosticEventHandler);
        });
    }

    private void logExecutorState() {
        ExecutorStateEvent executorStateEvent = this.diagnosticEventFactory.executorStateEvent(this.executorService, this.leaseCoordinator);
        executorStateEvent.accept(this.diagnosticEventHandler);
    }

    @Deprecated
    public Future<Void> requestShutdown() {
        return null;
    }

    public SchedulerLog slog() {
        return this.slog;
    }

    public CheckpointConfig checkpointConfig() {
        return this.checkpointConfig;
    }

    public CoordinatorConfig coordinatorConfig() {
        return this.coordinatorConfig;
    }

    public LeaseManagementConfig leaseManagementConfig() {
        return this.leaseManagementConfig;
    }

    public LifecycleConfig lifecycleConfig() {
        return this.lifecycleConfig;
    }

    public MetricsConfig metricsConfig() {
        return this.metricsConfig;
    }

    public ProcessorConfig processorConfig() {
        return this.processorConfig;
    }

    public RetrievalConfig retrievalConfig() {
        return this.retrievalConfig;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public int maxInitializationAttempts() {
        return this.maxInitializationAttempts;
    }

    public Checkpointer checkpoint() {
        return this.checkpoint;
    }

    public long shardConsumerDispatchPollIntervalMillis() {
        return this.shardConsumerDispatchPollIntervalMillis;
    }

    public long parentShardPollIntervalMillis() {
        return this.parentShardPollIntervalMillis;
    }

    public ExecutorService executorService() {
        return this.executorService;
    }

    public DiagnosticEventFactory diagnosticEventFactory() {
        return this.diagnosticEventFactory;
    }

    public DiagnosticEventHandler diagnosticEventHandler() {
        return this.diagnosticEventHandler;
    }

    public LeaseCoordinator leaseCoordinator() {
        return this.leaseCoordinator;
    }

    public ShardSyncTaskManager shardSyncTaskManager() {
        return this.shardSyncTaskManager;
    }

    public ShardPrioritization shardPrioritization() {
        return this.shardPrioritization;
    }

    public boolean cleanupLeasesUponShardCompletion() {
        return this.cleanupLeasesUponShardCompletion;
    }

    public boolean skipShardSyncAtWorkerInitializationIfLeasesExist() {
        return this.skipShardSyncAtWorkerInitializationIfLeasesExist;
    }

    public GracefulShutdownCoordinator gracefulShutdownCoordinator() {
        return this.gracefulShutdownCoordinator;
    }

    public WorkerStateChangeListener workerStateChangeListener() {
        return this.workerStateChangeListener;
    }

    public InitialPositionInStreamExtended initialPosition() {
        return this.initialPosition;
    }

    public MetricsFactory metricsFactory() {
        return this.metricsFactory;
    }

    public long failoverTimeMillis() {
        return this.failoverTimeMillis;
    }

    public long taskBackoffTimeMillis() {
        return this.taskBackoffTimeMillis;
    }

    public String streamName() {
        return this.streamName;
    }

    public long listShardsBackoffTimeMillis() {
        return this.listShardsBackoffTimeMillis;
    }

    public int maxListShardsRetryAttempts() {
        return this.maxListShardsRetryAttempts;
    }

    public LeaseRefresher leaseRefresher() {
        return this.leaseRefresher;
    }

    public ShardDetector shardDetector() {
        return this.shardDetector;
    }

    public boolean ignoreUnexpetedChildShards() {
        return this.ignoreUnexpetedChildShards;
    }

    public AggregatorUtil aggregatorUtil() {
        return this.aggregatorUtil;
    }

    public HierarchicalShardSyncer hierarchicalShardSyncer() {
        return this.hierarchicalShardSyncer;
    }

    public ConcurrentMap<ShardInfo, ShardConsumer> shardInfoShardConsumerMap() {
        return this.shardInfoShardConsumerMap;
    }

    public long shutdownStartTimeMillis() {
        return this.shutdownStartTimeMillis;
    }

    public boolean shutdownComplete() {
        return this.shutdownComplete;
    }

    public Object lock() {
        return this.lock;
    }

    public Future<Boolean> gracefulShutdownFuture() {
        return this.gracefulShutdownFuture;
    }

    public boolean gracefuleShutdownStarted() {
        return this.gracefuleShutdownStarted;
    }

    private static class SchedulerLog {
        private long reportIntervalMillis = TimeUnit.MINUTES.toMillis(1L);
        private long nextReportTime = System.currentTimeMillis() + this.reportIntervalMillis;
        private boolean infoReporting;

        void info(Object message) {
            if (this.isInfoEnabled()) {
                log.info("{}", message);
            }
        }

        void infoForce(Object message) {
            log.info("{}", message);
        }

        private boolean isInfoEnabled() {
            return this.infoReporting;
        }

        private void resetInfoLogging() {
            if (this.infoReporting) {
                if (log.isInfoEnabled()) {
                    this.infoReporting = false;
                    this.nextReportTime = System.currentTimeMillis() + this.reportIntervalMillis;
                }
            } else if (this.nextReportTime <= System.currentTimeMillis()) {
                this.infoReporting = true;
            }
        }

        private SchedulerLog() {
        }
    }
}

