/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.leases;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import software.amazon.kinesis.leases.Lease;
import software.amazon.kinesis.leases.LeaseRefresher;
import software.amazon.kinesis.leases.ShardInfo;
import software.amazon.kinesis.leases.dynamodb.DynamoDBLeaseCoordinator;
import software.amazon.kinesis.leases.exceptions.DependencyException;
import software.amazon.kinesis.leases.exceptions.InvalidStateException;
import software.amazon.kinesis.leases.exceptions.ProvisionedThroughputException;

public interface LeaseCoordinator {
    public void initialize() throws ProvisionedThroughputException, DependencyException, IllegalStateException;

    public void start() throws DependencyException, InvalidStateException, ProvisionedThroughputException;

    public void runLeaseTaker() throws DependencyException, InvalidStateException;

    public void runLeaseRenewer() throws DependencyException, InvalidStateException;

    public boolean isRunning();

    public String workerIdentifier();

    public LeaseRefresher leaseRefresher();

    public Collection<Lease> getAssignments();

    public Lease getCurrentlyHeldLease(String var1);

    public boolean updateLease(Lease var1, UUID var2, String var3, String var4) throws DependencyException, InvalidStateException, ProvisionedThroughputException;

    public void stopLeaseTaker();

    public void dropLease(Lease var1);

    public void stop();

    public List<ShardInfo> getCurrentAssignments();

    default public List<Lease> allLeases() {
        return Collections.emptyList();
    }

    public DynamoDBLeaseCoordinator initialLeaseTableWriteCapacity(long var1);

    public DynamoDBLeaseCoordinator initialLeaseTableReadCapacity(long var1);
}

