/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.leases;

import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.kinesis.annotations.KinesisClientInternalApi;
import software.amazon.kinesis.common.InitialPositionInStreamExtended;
import software.amazon.kinesis.leases.HierarchicalShardSyncer;
import software.amazon.kinesis.leases.LeaseRefresher;
import software.amazon.kinesis.leases.ShardDetector;
import software.amazon.kinesis.lifecycle.ConsumerTask;
import software.amazon.kinesis.lifecycle.TaskResult;
import software.amazon.kinesis.lifecycle.TaskType;
import software.amazon.kinesis.metrics.MetricsFactory;
import software.amazon.kinesis.metrics.MetricsScope;
import software.amazon.kinesis.metrics.MetricsUtil;

@KinesisClientInternalApi
public class ShardSyncTask
implements ConsumerTask {
    private static final Logger log = LoggerFactory.getLogger(ShardSyncTask.class);
    private final String SHARD_SYNC_TASK_OPERATION = "ShardSyncTask";
    @NonNull
    private final ShardDetector shardDetector;
    @NonNull
    private final LeaseRefresher leaseRefresher;
    @NonNull
    private final InitialPositionInStreamExtended initialPosition;
    private final boolean cleanupLeasesUponShardCompletion;
    private final boolean ignoreUnexpectedChildShards;
    private final long shardSyncTaskIdleTimeMillis;
    @NonNull
    private final HierarchicalShardSyncer hierarchicalShardSyncer;
    @NonNull
    private final MetricsFactory metricsFactory;
    private final TaskType taskType = TaskType.SHARDSYNC;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskResult call() {
        Exception exception = null;
        MetricsScope scope = MetricsUtil.createMetricsWithOperation(this.metricsFactory, "ShardSyncTask");
        try {
            this.hierarchicalShardSyncer.checkAndCreateLeaseForNewShards(this.shardDetector, this.leaseRefresher, this.initialPosition, this.cleanupLeasesUponShardCompletion, this.ignoreUnexpectedChildShards, scope);
            if (this.shardSyncTaskIdleTimeMillis > 0L) {
                Thread.sleep(this.shardSyncTaskIdleTimeMillis);
            }
        }
        catch (Exception e) {
            log.error("Caught exception while sync'ing Kinesis shards and leases", (Throwable)e);
            exception = e;
        }
        finally {
            MetricsUtil.endScope(scope);
        }
        return new TaskResult(exception);
    }

    @Override
    public TaskType taskType() {
        return this.taskType;
    }

    public ShardSyncTask(@NonNull ShardDetector shardDetector, @NonNull LeaseRefresher leaseRefresher, @NonNull InitialPositionInStreamExtended initialPosition, boolean cleanupLeasesUponShardCompletion, boolean ignoreUnexpectedChildShards, long shardSyncTaskIdleTimeMillis, @NonNull HierarchicalShardSyncer hierarchicalShardSyncer, @NonNull MetricsFactory metricsFactory) {
        if (shardDetector == null) {
            throw new NullPointerException("shardDetector");
        }
        if (leaseRefresher == null) {
            throw new NullPointerException("leaseRefresher");
        }
        if (initialPosition == null) {
            throw new NullPointerException("initialPosition");
        }
        if (hierarchicalShardSyncer == null) {
            throw new NullPointerException("hierarchicalShardSyncer");
        }
        if (metricsFactory == null) {
            throw new NullPointerException("metricsFactory");
        }
        this.shardDetector = shardDetector;
        this.leaseRefresher = leaseRefresher;
        this.initialPosition = initialPosition;
        this.cleanupLeasesUponShardCompletion = cleanupLeasesUponShardCompletion;
        this.ignoreUnexpectedChildShards = ignoreUnexpectedChildShards;
        this.shardSyncTaskIdleTimeMillis = shardSyncTaskIdleTimeMillis;
        this.hierarchicalShardSyncer = hierarchicalShardSyncer;
        this.metricsFactory = metricsFactory;
    }
}

