/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.lifecycle;

import java.util.concurrent.ExecutorService;
import lombok.NonNull;
import software.amazon.kinesis.annotations.KinesisClientInternalApi;
import software.amazon.kinesis.checkpoint.ShardRecordProcessorCheckpointer;
import software.amazon.kinesis.common.InitialPositionInStreamExtended;
import software.amazon.kinesis.leases.HierarchicalShardSyncer;
import software.amazon.kinesis.leases.LeaseRefresher;
import software.amazon.kinesis.leases.ShardDetector;
import software.amazon.kinesis.leases.ShardInfo;
import software.amazon.kinesis.metrics.MetricsFactory;
import software.amazon.kinesis.processor.Checkpointer;
import software.amazon.kinesis.processor.ShardRecordProcessor;
import software.amazon.kinesis.retrieval.AggregatorUtil;
import software.amazon.kinesis.retrieval.RecordsPublisher;

@KinesisClientInternalApi
public class ShardConsumerArgument {
    @NonNull
    private final ShardInfo shardInfo;
    @NonNull
    private final String streamName;
    @NonNull
    private final LeaseRefresher leaseRefresher;
    @NonNull
    private final ExecutorService executorService;
    @NonNull
    private final RecordsPublisher recordsPublisher;
    @NonNull
    private final ShardRecordProcessor shardRecordProcessor;
    @NonNull
    private final Checkpointer checkpoint;
    @NonNull
    private final ShardRecordProcessorCheckpointer recordProcessorCheckpointer;
    private final long parentShardPollIntervalMillis;
    private final long taskBackoffTimeMillis;
    private final boolean skipShardSyncAtWorkerInitializationIfLeasesExist;
    private final long listShardsBackoffTimeInMillis;
    private final int maxListShardsRetryAttempts;
    private final boolean shouldCallProcessRecordsEvenForEmptyRecordList;
    private final long idleTimeInMilliseconds;
    @NonNull
    private final InitialPositionInStreamExtended initialPositionInStream;
    private final boolean cleanupLeasesOfCompletedShards;
    private final boolean ignoreUnexpectedChildShards;
    @NonNull
    private final ShardDetector shardDetector;
    private final AggregatorUtil aggregatorUtil;
    private final HierarchicalShardSyncer hierarchicalShardSyncer;
    @NonNull
    private final MetricsFactory metricsFactory;

    public ShardConsumerArgument(@NonNull ShardInfo shardInfo, @NonNull String streamName, @NonNull LeaseRefresher leaseRefresher, @NonNull ExecutorService executorService, @NonNull RecordsPublisher recordsPublisher, @NonNull ShardRecordProcessor shardRecordProcessor, @NonNull Checkpointer checkpoint, @NonNull ShardRecordProcessorCheckpointer recordProcessorCheckpointer, long parentShardPollIntervalMillis, long taskBackoffTimeMillis, boolean skipShardSyncAtWorkerInitializationIfLeasesExist, long listShardsBackoffTimeInMillis, int maxListShardsRetryAttempts, boolean shouldCallProcessRecordsEvenForEmptyRecordList, long idleTimeInMilliseconds, @NonNull InitialPositionInStreamExtended initialPositionInStream, boolean cleanupLeasesOfCompletedShards, boolean ignoreUnexpectedChildShards, @NonNull ShardDetector shardDetector, AggregatorUtil aggregatorUtil, HierarchicalShardSyncer hierarchicalShardSyncer, @NonNull MetricsFactory metricsFactory) {
        if (shardInfo == null) {
            throw new NullPointerException("shardInfo");
        }
        if (streamName == null) {
            throw new NullPointerException("streamName");
        }
        if (leaseRefresher == null) {
            throw new NullPointerException("leaseRefresher");
        }
        if (executorService == null) {
            throw new NullPointerException("executorService");
        }
        if (recordsPublisher == null) {
            throw new NullPointerException("recordsPublisher");
        }
        if (shardRecordProcessor == null) {
            throw new NullPointerException("shardRecordProcessor");
        }
        if (checkpoint == null) {
            throw new NullPointerException("checkpoint");
        }
        if (recordProcessorCheckpointer == null) {
            throw new NullPointerException("recordProcessorCheckpointer");
        }
        if (initialPositionInStream == null) {
            throw new NullPointerException("initialPositionInStream");
        }
        if (shardDetector == null) {
            throw new NullPointerException("shardDetector");
        }
        if (metricsFactory == null) {
            throw new NullPointerException("metricsFactory");
        }
        this.shardInfo = shardInfo;
        this.streamName = streamName;
        this.leaseRefresher = leaseRefresher;
        this.executorService = executorService;
        this.recordsPublisher = recordsPublisher;
        this.shardRecordProcessor = shardRecordProcessor;
        this.checkpoint = checkpoint;
        this.recordProcessorCheckpointer = recordProcessorCheckpointer;
        this.parentShardPollIntervalMillis = parentShardPollIntervalMillis;
        this.taskBackoffTimeMillis = taskBackoffTimeMillis;
        this.skipShardSyncAtWorkerInitializationIfLeasesExist = skipShardSyncAtWorkerInitializationIfLeasesExist;
        this.listShardsBackoffTimeInMillis = listShardsBackoffTimeInMillis;
        this.maxListShardsRetryAttempts = maxListShardsRetryAttempts;
        this.shouldCallProcessRecordsEvenForEmptyRecordList = shouldCallProcessRecordsEvenForEmptyRecordList;
        this.idleTimeInMilliseconds = idleTimeInMilliseconds;
        this.initialPositionInStream = initialPositionInStream;
        this.cleanupLeasesOfCompletedShards = cleanupLeasesOfCompletedShards;
        this.ignoreUnexpectedChildShards = ignoreUnexpectedChildShards;
        this.shardDetector = shardDetector;
        this.aggregatorUtil = aggregatorUtil;
        this.hierarchicalShardSyncer = hierarchicalShardSyncer;
        this.metricsFactory = metricsFactory;
    }

    @NonNull
    public ShardInfo shardInfo() {
        return this.shardInfo;
    }

    @NonNull
    public String streamName() {
        return this.streamName;
    }

    @NonNull
    public LeaseRefresher leaseRefresher() {
        return this.leaseRefresher;
    }

    @NonNull
    public ExecutorService executorService() {
        return this.executorService;
    }

    @NonNull
    public RecordsPublisher recordsPublisher() {
        return this.recordsPublisher;
    }

    @NonNull
    public ShardRecordProcessor shardRecordProcessor() {
        return this.shardRecordProcessor;
    }

    @NonNull
    public Checkpointer checkpoint() {
        return this.checkpoint;
    }

    @NonNull
    public ShardRecordProcessorCheckpointer recordProcessorCheckpointer() {
        return this.recordProcessorCheckpointer;
    }

    public long parentShardPollIntervalMillis() {
        return this.parentShardPollIntervalMillis;
    }

    public long taskBackoffTimeMillis() {
        return this.taskBackoffTimeMillis;
    }

    public boolean skipShardSyncAtWorkerInitializationIfLeasesExist() {
        return this.skipShardSyncAtWorkerInitializationIfLeasesExist;
    }

    public long listShardsBackoffTimeInMillis() {
        return this.listShardsBackoffTimeInMillis;
    }

    public int maxListShardsRetryAttempts() {
        return this.maxListShardsRetryAttempts;
    }

    public boolean shouldCallProcessRecordsEvenForEmptyRecordList() {
        return this.shouldCallProcessRecordsEvenForEmptyRecordList;
    }

    public long idleTimeInMilliseconds() {
        return this.idleTimeInMilliseconds;
    }

    @NonNull
    public InitialPositionInStreamExtended initialPositionInStream() {
        return this.initialPositionInStream;
    }

    public boolean cleanupLeasesOfCompletedShards() {
        return this.cleanupLeasesOfCompletedShards;
    }

    public boolean ignoreUnexpectedChildShards() {
        return this.ignoreUnexpectedChildShards;
    }

    @NonNull
    public ShardDetector shardDetector() {
        return this.shardDetector;
    }

    public AggregatorUtil aggregatorUtil() {
        return this.aggregatorUtil;
    }

    public HierarchicalShardSyncer hierarchicalShardSyncer() {
        return this.hierarchicalShardSyncer;
    }

    @NonNull
    public MetricsFactory metricsFactory() {
        return this.metricsFactory;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShardConsumerArgument)) {
            return false;
        }
        ShardConsumerArgument other = (ShardConsumerArgument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ShardInfo this$shardInfo = this.shardInfo();
        ShardInfo other$shardInfo = other.shardInfo();
        if (this$shardInfo == null ? other$shardInfo != null : !((Object)this$shardInfo).equals(other$shardInfo)) {
            return false;
        }
        String this$streamName = this.streamName();
        String other$streamName = other.streamName();
        if (this$streamName == null ? other$streamName != null : !this$streamName.equals(other$streamName)) {
            return false;
        }
        LeaseRefresher this$leaseRefresher = this.leaseRefresher();
        LeaseRefresher other$leaseRefresher = other.leaseRefresher();
        if (this$leaseRefresher == null ? other$leaseRefresher != null : !this$leaseRefresher.equals(other$leaseRefresher)) {
            return false;
        }
        ExecutorService this$executorService = this.executorService();
        ExecutorService other$executorService = other.executorService();
        if (this$executorService == null ? other$executorService != null : !this$executorService.equals(other$executorService)) {
            return false;
        }
        RecordsPublisher this$recordsPublisher = this.recordsPublisher();
        RecordsPublisher other$recordsPublisher = other.recordsPublisher();
        if (this$recordsPublisher == null ? other$recordsPublisher != null : !this$recordsPublisher.equals(other$recordsPublisher)) {
            return false;
        }
        ShardRecordProcessor this$shardRecordProcessor = this.shardRecordProcessor();
        ShardRecordProcessor other$shardRecordProcessor = other.shardRecordProcessor();
        if (this$shardRecordProcessor == null ? other$shardRecordProcessor != null : !this$shardRecordProcessor.equals(other$shardRecordProcessor)) {
            return false;
        }
        Checkpointer this$checkpoint = this.checkpoint();
        Checkpointer other$checkpoint = other.checkpoint();
        if (this$checkpoint == null ? other$checkpoint != null : !this$checkpoint.equals(other$checkpoint)) {
            return false;
        }
        ShardRecordProcessorCheckpointer this$recordProcessorCheckpointer = this.recordProcessorCheckpointer();
        ShardRecordProcessorCheckpointer other$recordProcessorCheckpointer = other.recordProcessorCheckpointer();
        if (this$recordProcessorCheckpointer == null ? other$recordProcessorCheckpointer != null : !this$recordProcessorCheckpointer.equals(other$recordProcessorCheckpointer)) {
            return false;
        }
        if (this.parentShardPollIntervalMillis() != other.parentShardPollIntervalMillis()) {
            return false;
        }
        if (this.taskBackoffTimeMillis() != other.taskBackoffTimeMillis()) {
            return false;
        }
        if (this.skipShardSyncAtWorkerInitializationIfLeasesExist() != other.skipShardSyncAtWorkerInitializationIfLeasesExist()) {
            return false;
        }
        if (this.listShardsBackoffTimeInMillis() != other.listShardsBackoffTimeInMillis()) {
            return false;
        }
        if (this.maxListShardsRetryAttempts() != other.maxListShardsRetryAttempts()) {
            return false;
        }
        if (this.shouldCallProcessRecordsEvenForEmptyRecordList() != other.shouldCallProcessRecordsEvenForEmptyRecordList()) {
            return false;
        }
        if (this.idleTimeInMilliseconds() != other.idleTimeInMilliseconds()) {
            return false;
        }
        InitialPositionInStreamExtended this$initialPositionInStream = this.initialPositionInStream();
        InitialPositionInStreamExtended other$initialPositionInStream = other.initialPositionInStream();
        if (this$initialPositionInStream == null ? other$initialPositionInStream != null : !this$initialPositionInStream.equals(other$initialPositionInStream)) {
            return false;
        }
        if (this.cleanupLeasesOfCompletedShards() != other.cleanupLeasesOfCompletedShards()) {
            return false;
        }
        if (this.ignoreUnexpectedChildShards() != other.ignoreUnexpectedChildShards()) {
            return false;
        }
        ShardDetector this$shardDetector = this.shardDetector();
        ShardDetector other$shardDetector = other.shardDetector();
        if (this$shardDetector == null ? other$shardDetector != null : !this$shardDetector.equals(other$shardDetector)) {
            return false;
        }
        AggregatorUtil this$aggregatorUtil = this.aggregatorUtil();
        AggregatorUtil other$aggregatorUtil = other.aggregatorUtil();
        if (this$aggregatorUtil == null ? other$aggregatorUtil != null : !this$aggregatorUtil.equals(other$aggregatorUtil)) {
            return false;
        }
        HierarchicalShardSyncer this$hierarchicalShardSyncer = this.hierarchicalShardSyncer();
        HierarchicalShardSyncer other$hierarchicalShardSyncer = other.hierarchicalShardSyncer();
        if (this$hierarchicalShardSyncer == null ? other$hierarchicalShardSyncer != null : !this$hierarchicalShardSyncer.equals(other$hierarchicalShardSyncer)) {
            return false;
        }
        MetricsFactory this$metricsFactory = this.metricsFactory();
        MetricsFactory other$metricsFactory = other.metricsFactory();
        return !(this$metricsFactory == null ? other$metricsFactory != null : !this$metricsFactory.equals(other$metricsFactory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShardConsumerArgument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ShardInfo $shardInfo = this.shardInfo();
        result = result * 59 + ($shardInfo == null ? 43 : ((Object)$shardInfo).hashCode());
        String $streamName = this.streamName();
        result = result * 59 + ($streamName == null ? 43 : $streamName.hashCode());
        LeaseRefresher $leaseRefresher = this.leaseRefresher();
        result = result * 59 + ($leaseRefresher == null ? 43 : $leaseRefresher.hashCode());
        ExecutorService $executorService = this.executorService();
        result = result * 59 + ($executorService == null ? 43 : $executorService.hashCode());
        RecordsPublisher $recordsPublisher = this.recordsPublisher();
        result = result * 59 + ($recordsPublisher == null ? 43 : $recordsPublisher.hashCode());
        ShardRecordProcessor $shardRecordProcessor = this.shardRecordProcessor();
        result = result * 59 + ($shardRecordProcessor == null ? 43 : $shardRecordProcessor.hashCode());
        Checkpointer $checkpoint = this.checkpoint();
        result = result * 59 + ($checkpoint == null ? 43 : $checkpoint.hashCode());
        ShardRecordProcessorCheckpointer $recordProcessorCheckpointer = this.recordProcessorCheckpointer();
        result = result * 59 + ($recordProcessorCheckpointer == null ? 43 : $recordProcessorCheckpointer.hashCode());
        long $parentShardPollIntervalMillis = this.parentShardPollIntervalMillis();
        result = result * 59 + (int)($parentShardPollIntervalMillis >>> 32 ^ $parentShardPollIntervalMillis);
        long $taskBackoffTimeMillis = this.taskBackoffTimeMillis();
        result = result * 59 + (int)($taskBackoffTimeMillis >>> 32 ^ $taskBackoffTimeMillis);
        result = result * 59 + (this.skipShardSyncAtWorkerInitializationIfLeasesExist() ? 79 : 97);
        long $listShardsBackoffTimeInMillis = this.listShardsBackoffTimeInMillis();
        result = result * 59 + (int)($listShardsBackoffTimeInMillis >>> 32 ^ $listShardsBackoffTimeInMillis);
        result = result * 59 + this.maxListShardsRetryAttempts();
        result = result * 59 + (this.shouldCallProcessRecordsEvenForEmptyRecordList() ? 79 : 97);
        long $idleTimeInMilliseconds = this.idleTimeInMilliseconds();
        result = result * 59 + (int)($idleTimeInMilliseconds >>> 32 ^ $idleTimeInMilliseconds);
        InitialPositionInStreamExtended $initialPositionInStream = this.initialPositionInStream();
        result = result * 59 + ($initialPositionInStream == null ? 43 : $initialPositionInStream.hashCode());
        result = result * 59 + (this.cleanupLeasesOfCompletedShards() ? 79 : 97);
        result = result * 59 + (this.ignoreUnexpectedChildShards() ? 79 : 97);
        ShardDetector $shardDetector = this.shardDetector();
        result = result * 59 + ($shardDetector == null ? 43 : $shardDetector.hashCode());
        AggregatorUtil $aggregatorUtil = this.aggregatorUtil();
        result = result * 59 + ($aggregatorUtil == null ? 43 : $aggregatorUtil.hashCode());
        HierarchicalShardSyncer $hierarchicalShardSyncer = this.hierarchicalShardSyncer();
        result = result * 59 + ($hierarchicalShardSyncer == null ? 43 : $hierarchicalShardSyncer.hashCode());
        MetricsFactory $metricsFactory = this.metricsFactory();
        result = result * 59 + ($metricsFactory == null ? 43 : $metricsFactory.hashCode());
        return result;
    }

    public String toString() {
        return "ShardConsumerArgument(shardInfo=" + this.shardInfo() + ", streamName=" + this.streamName() + ", leaseRefresher=" + this.leaseRefresher() + ", executorService=" + this.executorService() + ", recordsPublisher=" + this.recordsPublisher() + ", shardRecordProcessor=" + this.shardRecordProcessor() + ", checkpoint=" + this.checkpoint() + ", recordProcessorCheckpointer=" + this.recordProcessorCheckpointer() + ", parentShardPollIntervalMillis=" + this.parentShardPollIntervalMillis() + ", taskBackoffTimeMillis=" + this.taskBackoffTimeMillis() + ", skipShardSyncAtWorkerInitializationIfLeasesExist=" + this.skipShardSyncAtWorkerInitializationIfLeasesExist() + ", listShardsBackoffTimeInMillis=" + this.listShardsBackoffTimeInMillis() + ", maxListShardsRetryAttempts=" + this.maxListShardsRetryAttempts() + ", shouldCallProcessRecordsEvenForEmptyRecordList=" + this.shouldCallProcessRecordsEvenForEmptyRecordList() + ", idleTimeInMilliseconds=" + this.idleTimeInMilliseconds() + ", initialPositionInStream=" + this.initialPositionInStream() + ", cleanupLeasesOfCompletedShards=" + this.cleanupLeasesOfCompletedShards() + ", ignoreUnexpectedChildShards=" + this.ignoreUnexpectedChildShards() + ", shardDetector=" + this.shardDetector() + ", aggregatorUtil=" + this.aggregatorUtil() + ", hierarchicalShardSyncer=" + this.hierarchicalShardSyncer() + ", metricsFactory=" + this.metricsFactory() + ")";
    }
}

