/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.metrics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import software.amazon.awssdk.services.cloudwatch.model.MetricDatum;
import software.amazon.awssdk.services.cloudwatch.model.StatisticSet;
import software.amazon.kinesis.metrics.MetricDatumWithKey;

public class MetricAccumulatingQueue<KeyType> {
    private BlockingQueue<MetricDatumWithKey<KeyType>> queue;
    private Map<KeyType, MetricDatumWithKey<KeyType>> map;

    public MetricAccumulatingQueue(int maxQueueSize) {
        this.queue = new LinkedBlockingQueue<MetricDatumWithKey<KeyType>>(maxQueueSize);
        this.map = new HashMap<KeyType, MetricDatumWithKey<KeyType>>();
    }

    public synchronized List<MetricDatumWithKey<KeyType>> drain(int maxItems) {
        ArrayList<MetricDatumWithKey<KeyType>> drainedItems = new ArrayList<MetricDatumWithKey<KeyType>>(maxItems);
        this.queue.drainTo(drainedItems, maxItems);
        drainedItems.forEach(datumWithKey -> this.map.remove(datumWithKey.key));
        return drainedItems;
    }

    public synchronized boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public synchronized int size() {
        return this.queue.size();
    }

    public synchronized boolean offer(KeyType key, MetricDatum datum) {
        MetricDatumWithKey<KeyType> metricDatumWithKey = this.map.get(key);
        if (metricDatumWithKey == null) {
            metricDatumWithKey = new MetricDatumWithKey<KeyType>(key, datum);
            boolean offered = this.queue.offer(metricDatumWithKey);
            if (offered) {
                this.map.put(key, metricDatumWithKey);
            }
            return offered;
        }
        this.accumulate(metricDatumWithKey, datum);
        return true;
    }

    private void accumulate(MetricDatumWithKey<KeyType> metricDatumWithKey, MetricDatum newDatum) {
        MetricDatum oldDatum = metricDatumWithKey.datum;
        if (!oldDatum.unit().equals((Object)newDatum.unit())) {
            throw new IllegalArgumentException("Unit mismatch for datum named " + oldDatum.metricName());
        }
        StatisticSet oldStats = oldDatum.statisticValues();
        StatisticSet newStats = newDatum.statisticValues();
        StatisticSet statisticSet = (StatisticSet)oldStats.toBuilder().sum(Double.valueOf(oldStats.sum() + newStats.sum())).minimum(Double.valueOf(Math.min(oldStats.minimum(), newStats.minimum()))).maximum(Double.valueOf(Math.max(oldStats.maximum(), newStats.maximum()))).sampleCount(Double.valueOf(oldStats.sampleCount() + newStats.sampleCount())).build();
        MetricDatum datum = (MetricDatum)oldDatum.toBuilder().statisticValues(statisticSet).build();
        metricDatumWithKey.datum(datum);
    }
}

