/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.retrieval.polling;

import java.time.Duration;
import java.util.Optional;
import lombok.NonNull;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.kinesis.retrieval.RecordsFetcherFactory;
import software.amazon.kinesis.retrieval.RetrievalFactory;
import software.amazon.kinesis.retrieval.RetrievalSpecificConfig;
import software.amazon.kinesis.retrieval.polling.SimpleRecordsFetcherFactory;
import software.amazon.kinesis.retrieval.polling.SynchronousBlockingRetrievalFactory;

public class PollingConfig
implements RetrievalSpecificConfig {
    public static final Duration DEFAULT_REQUEST_TIMEOUT = Duration.ofSeconds(30L);
    @NonNull
    private final String streamName;
    @NonNull
    private final KinesisAsyncClient kinesisClient;
    private int maxRecords = 10000;
    private long idleTimeBetweenReadsInMillis = 1000L;
    private Optional<Integer> retryGetRecordsInSeconds = Optional.empty();
    private Optional<Integer> maxGetRecordsThreadPool = Optional.empty();
    private RecordsFetcherFactory recordsFetcherFactory = new SimpleRecordsFetcherFactory();
    private Duration kinesisRequestTimeout = DEFAULT_REQUEST_TIMEOUT;

    @Override
    public RetrievalFactory retrievalFactory() {
        return new SynchronousBlockingRetrievalFactory(this.streamName(), this.kinesisClient(), this.recordsFetcherFactory, this.maxRecords(), this.kinesisRequestTimeout);
    }

    public PollingConfig(@NonNull String streamName, @NonNull KinesisAsyncClient kinesisClient) {
        if (streamName == null) {
            throw new NullPointerException("streamName");
        }
        if (kinesisClient == null) {
            throw new NullPointerException("kinesisClient");
        }
        this.streamName = streamName;
        this.kinesisClient = kinesisClient;
    }

    public PollingConfig maxRecords(int maxRecords) {
        this.maxRecords = maxRecords;
        return this;
    }

    public PollingConfig idleTimeBetweenReadsInMillis(long idleTimeBetweenReadsInMillis) {
        this.idleTimeBetweenReadsInMillis = idleTimeBetweenReadsInMillis;
        return this;
    }

    public PollingConfig retryGetRecordsInSeconds(Optional<Integer> retryGetRecordsInSeconds) {
        this.retryGetRecordsInSeconds = retryGetRecordsInSeconds;
        return this;
    }

    public PollingConfig maxGetRecordsThreadPool(Optional<Integer> maxGetRecordsThreadPool) {
        this.maxGetRecordsThreadPool = maxGetRecordsThreadPool;
        return this;
    }

    public PollingConfig recordsFetcherFactory(RecordsFetcherFactory recordsFetcherFactory) {
        this.recordsFetcherFactory = recordsFetcherFactory;
        return this;
    }

    public PollingConfig kinesisRequestTimeout(Duration kinesisRequestTimeout) {
        this.kinesisRequestTimeout = kinesisRequestTimeout;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PollingConfig)) {
            return false;
        }
        PollingConfig other = (PollingConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$streamName = this.streamName();
        String other$streamName = other.streamName();
        if (this$streamName == null ? other$streamName != null : !this$streamName.equals(other$streamName)) {
            return false;
        }
        KinesisAsyncClient this$kinesisClient = this.kinesisClient();
        KinesisAsyncClient other$kinesisClient = other.kinesisClient();
        if (this$kinesisClient == null ? other$kinesisClient != null : !this$kinesisClient.equals(other$kinesisClient)) {
            return false;
        }
        if (this.maxRecords() != other.maxRecords()) {
            return false;
        }
        if (this.idleTimeBetweenReadsInMillis() != other.idleTimeBetweenReadsInMillis()) {
            return false;
        }
        Optional<Integer> this$retryGetRecordsInSeconds = this.retryGetRecordsInSeconds();
        Optional<Integer> other$retryGetRecordsInSeconds = other.retryGetRecordsInSeconds();
        if (this$retryGetRecordsInSeconds == null ? other$retryGetRecordsInSeconds != null : !((Object)this$retryGetRecordsInSeconds).equals(other$retryGetRecordsInSeconds)) {
            return false;
        }
        Optional<Integer> this$maxGetRecordsThreadPool = this.maxGetRecordsThreadPool();
        Optional<Integer> other$maxGetRecordsThreadPool = other.maxGetRecordsThreadPool();
        if (this$maxGetRecordsThreadPool == null ? other$maxGetRecordsThreadPool != null : !((Object)this$maxGetRecordsThreadPool).equals(other$maxGetRecordsThreadPool)) {
            return false;
        }
        RecordsFetcherFactory this$recordsFetcherFactory = this.recordsFetcherFactory();
        RecordsFetcherFactory other$recordsFetcherFactory = other.recordsFetcherFactory();
        if (this$recordsFetcherFactory == null ? other$recordsFetcherFactory != null : !this$recordsFetcherFactory.equals(other$recordsFetcherFactory)) {
            return false;
        }
        Duration this$kinesisRequestTimeout = this.kinesisRequestTimeout();
        Duration other$kinesisRequestTimeout = other.kinesisRequestTimeout();
        return !(this$kinesisRequestTimeout == null ? other$kinesisRequestTimeout != null : !((Object)this$kinesisRequestTimeout).equals(other$kinesisRequestTimeout));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PollingConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $streamName = this.streamName();
        result = result * 59 + ($streamName == null ? 43 : $streamName.hashCode());
        KinesisAsyncClient $kinesisClient = this.kinesisClient();
        result = result * 59 + ($kinesisClient == null ? 43 : $kinesisClient.hashCode());
        result = result * 59 + this.maxRecords();
        long $idleTimeBetweenReadsInMillis = this.idleTimeBetweenReadsInMillis();
        result = result * 59 + (int)($idleTimeBetweenReadsInMillis >>> 32 ^ $idleTimeBetweenReadsInMillis);
        Optional<Integer> $retryGetRecordsInSeconds = this.retryGetRecordsInSeconds();
        result = result * 59 + ($retryGetRecordsInSeconds == null ? 43 : ((Object)$retryGetRecordsInSeconds).hashCode());
        Optional<Integer> $maxGetRecordsThreadPool = this.maxGetRecordsThreadPool();
        result = result * 59 + ($maxGetRecordsThreadPool == null ? 43 : ((Object)$maxGetRecordsThreadPool).hashCode());
        RecordsFetcherFactory $recordsFetcherFactory = this.recordsFetcherFactory();
        result = result * 59 + ($recordsFetcherFactory == null ? 43 : $recordsFetcherFactory.hashCode());
        Duration $kinesisRequestTimeout = this.kinesisRequestTimeout();
        result = result * 59 + ($kinesisRequestTimeout == null ? 43 : ((Object)$kinesisRequestTimeout).hashCode());
        return result;
    }

    public String toString() {
        return "PollingConfig(streamName=" + this.streamName() + ", kinesisClient=" + this.kinesisClient() + ", maxRecords=" + this.maxRecords() + ", idleTimeBetweenReadsInMillis=" + this.idleTimeBetweenReadsInMillis() + ", retryGetRecordsInSeconds=" + this.retryGetRecordsInSeconds() + ", maxGetRecordsThreadPool=" + this.maxGetRecordsThreadPool() + ", recordsFetcherFactory=" + this.recordsFetcherFactory() + ", kinesisRequestTimeout=" + this.kinesisRequestTimeout() + ")";
    }

    @NonNull
    public String streamName() {
        return this.streamName;
    }

    @NonNull
    public KinesisAsyncClient kinesisClient() {
        return this.kinesisClient;
    }

    public int maxRecords() {
        return this.maxRecords;
    }

    public long idleTimeBetweenReadsInMillis() {
        return this.idleTimeBetweenReadsInMillis;
    }

    public Optional<Integer> retryGetRecordsInSeconds() {
        return this.retryGetRecordsInSeconds;
    }

    public Optional<Integer> maxGetRecordsThreadPool() {
        return this.maxGetRecordsThreadPool;
    }

    public RecordsFetcherFactory recordsFetcherFactory() {
        return this.recordsFetcherFactory;
    }

    public Duration kinesisRequestTimeout() {
        return this.kinesisRequestTimeout;
    }
}

