/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.common;

import java.time.Duration;
import java.time.Instant;
import org.slf4j.Logger;
import software.amazon.kinesis.annotations.KinesisClientInternalApi;

@KinesisClientInternalApi
public class DiagnosticUtils {
    public static void takeDelayedDeliveryActionIfRequired(String shardId, Instant enqueueTimestamp, Logger log) {
        long durationBetweenEnqueueAndAckInMillis = Duration.between(enqueueTimestamp, Instant.now()).toMillis();
        if (durationBetweenEnqueueAndAckInMillis > 20000L) {
            log.warn("{}: Record delivery time to shard consumer is high at {} millis. Check the ExecutorStateEvent logs to see the state of the executor service. Also check if the RecordProcessor's processing time is high. ", (Object)shardId, (Object)durationBetweenEnqueueAndAckInMillis);
        } else if (log.isDebugEnabled()) {
            log.debug("{}: Record delivery time to shard consumer is {} millis", (Object)shardId, (Object)durationBetweenEnqueueAndAckInMillis);
        }
    }
}

