/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.coordinator;

import lombok.NonNull;
import software.amazon.kinesis.coordinator.CoordinatorFactory;
import software.amazon.kinesis.coordinator.GracefulShutdownCoordinator;
import software.amazon.kinesis.coordinator.NoOpWorkerStateChangeListener;
import software.amazon.kinesis.coordinator.SchedulerCoordinatorFactory;
import software.amazon.kinesis.coordinator.WorkerStateChangeListener;
import software.amazon.kinesis.leases.NoOpShardPrioritization;
import software.amazon.kinesis.leases.ShardPrioritization;

public class CoordinatorConfig {
    @NonNull
    private final String applicationName;
    private int maxInitializationAttempts = 20;
    private long parentShardPollIntervalMillis = 10000L;
    private boolean skipShardSyncAtWorkerInitializationIfLeasesExist = false;
    private long shardConsumerDispatchPollIntervalMillis = 1000L;
    private ShardPrioritization shardPrioritization = new NoOpShardPrioritization();
    private WorkerStateChangeListener workerStateChangeListener = new NoOpWorkerStateChangeListener();
    private GracefulShutdownCoordinator gracefulShutdownCoordinator = new GracefulShutdownCoordinator();
    private CoordinatorFactory coordinatorFactory = new SchedulerCoordinatorFactory();
    private long schedulerInitializationBackoffTimeMillis = 1000L;

    public CoordinatorConfig(@NonNull String applicationName) {
        if (applicationName == null) {
            throw new NullPointerException("applicationName");
        }
        this.applicationName = applicationName;
    }

    @NonNull
    public String applicationName() {
        return this.applicationName;
    }

    public int maxInitializationAttempts() {
        return this.maxInitializationAttempts;
    }

    public long parentShardPollIntervalMillis() {
        return this.parentShardPollIntervalMillis;
    }

    public boolean skipShardSyncAtWorkerInitializationIfLeasesExist() {
        return this.skipShardSyncAtWorkerInitializationIfLeasesExist;
    }

    public long shardConsumerDispatchPollIntervalMillis() {
        return this.shardConsumerDispatchPollIntervalMillis;
    }

    public ShardPrioritization shardPrioritization() {
        return this.shardPrioritization;
    }

    public WorkerStateChangeListener workerStateChangeListener() {
        return this.workerStateChangeListener;
    }

    public GracefulShutdownCoordinator gracefulShutdownCoordinator() {
        return this.gracefulShutdownCoordinator;
    }

    public CoordinatorFactory coordinatorFactory() {
        return this.coordinatorFactory;
    }

    public long schedulerInitializationBackoffTimeMillis() {
        return this.schedulerInitializationBackoffTimeMillis;
    }

    public CoordinatorConfig maxInitializationAttempts(int maxInitializationAttempts) {
        this.maxInitializationAttempts = maxInitializationAttempts;
        return this;
    }

    public CoordinatorConfig parentShardPollIntervalMillis(long parentShardPollIntervalMillis) {
        this.parentShardPollIntervalMillis = parentShardPollIntervalMillis;
        return this;
    }

    public CoordinatorConfig skipShardSyncAtWorkerInitializationIfLeasesExist(boolean skipShardSyncAtWorkerInitializationIfLeasesExist) {
        this.skipShardSyncAtWorkerInitializationIfLeasesExist = skipShardSyncAtWorkerInitializationIfLeasesExist;
        return this;
    }

    public CoordinatorConfig shardConsumerDispatchPollIntervalMillis(long shardConsumerDispatchPollIntervalMillis) {
        this.shardConsumerDispatchPollIntervalMillis = shardConsumerDispatchPollIntervalMillis;
        return this;
    }

    public CoordinatorConfig shardPrioritization(ShardPrioritization shardPrioritization) {
        this.shardPrioritization = shardPrioritization;
        return this;
    }

    public CoordinatorConfig workerStateChangeListener(WorkerStateChangeListener workerStateChangeListener) {
        this.workerStateChangeListener = workerStateChangeListener;
        return this;
    }

    public CoordinatorConfig gracefulShutdownCoordinator(GracefulShutdownCoordinator gracefulShutdownCoordinator) {
        this.gracefulShutdownCoordinator = gracefulShutdownCoordinator;
        return this;
    }

    public CoordinatorConfig coordinatorFactory(CoordinatorFactory coordinatorFactory) {
        this.coordinatorFactory = coordinatorFactory;
        return this;
    }

    public CoordinatorConfig schedulerInitializationBackoffTimeMillis(long schedulerInitializationBackoffTimeMillis) {
        this.schedulerInitializationBackoffTimeMillis = schedulerInitializationBackoffTimeMillis;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CoordinatorConfig)) {
            return false;
        }
        CoordinatorConfig other = (CoordinatorConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$applicationName = this.applicationName();
        String other$applicationName = other.applicationName();
        if (this$applicationName == null ? other$applicationName != null : !this$applicationName.equals(other$applicationName)) {
            return false;
        }
        if (this.maxInitializationAttempts() != other.maxInitializationAttempts()) {
            return false;
        }
        if (this.parentShardPollIntervalMillis() != other.parentShardPollIntervalMillis()) {
            return false;
        }
        if (this.skipShardSyncAtWorkerInitializationIfLeasesExist() != other.skipShardSyncAtWorkerInitializationIfLeasesExist()) {
            return false;
        }
        if (this.shardConsumerDispatchPollIntervalMillis() != other.shardConsumerDispatchPollIntervalMillis()) {
            return false;
        }
        ShardPrioritization this$shardPrioritization = this.shardPrioritization();
        ShardPrioritization other$shardPrioritization = other.shardPrioritization();
        if (this$shardPrioritization == null ? other$shardPrioritization != null : !this$shardPrioritization.equals(other$shardPrioritization)) {
            return false;
        }
        WorkerStateChangeListener this$workerStateChangeListener = this.workerStateChangeListener();
        WorkerStateChangeListener other$workerStateChangeListener = other.workerStateChangeListener();
        if (this$workerStateChangeListener == null ? other$workerStateChangeListener != null : !this$workerStateChangeListener.equals(other$workerStateChangeListener)) {
            return false;
        }
        GracefulShutdownCoordinator this$gracefulShutdownCoordinator = this.gracefulShutdownCoordinator();
        GracefulShutdownCoordinator other$gracefulShutdownCoordinator = other.gracefulShutdownCoordinator();
        if (this$gracefulShutdownCoordinator == null ? other$gracefulShutdownCoordinator != null : !this$gracefulShutdownCoordinator.equals(other$gracefulShutdownCoordinator)) {
            return false;
        }
        CoordinatorFactory this$coordinatorFactory = this.coordinatorFactory();
        CoordinatorFactory other$coordinatorFactory = other.coordinatorFactory();
        if (this$coordinatorFactory == null ? other$coordinatorFactory != null : !this$coordinatorFactory.equals(other$coordinatorFactory)) {
            return false;
        }
        return this.schedulerInitializationBackoffTimeMillis() == other.schedulerInitializationBackoffTimeMillis();
    }

    protected boolean canEqual(Object other) {
        return other instanceof CoordinatorConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $applicationName = this.applicationName();
        result = result * 59 + ($applicationName == null ? 43 : $applicationName.hashCode());
        result = result * 59 + this.maxInitializationAttempts();
        long $parentShardPollIntervalMillis = this.parentShardPollIntervalMillis();
        result = result * 59 + (int)($parentShardPollIntervalMillis >>> 32 ^ $parentShardPollIntervalMillis);
        result = result * 59 + (this.skipShardSyncAtWorkerInitializationIfLeasesExist() ? 79 : 97);
        long $shardConsumerDispatchPollIntervalMillis = this.shardConsumerDispatchPollIntervalMillis();
        result = result * 59 + (int)($shardConsumerDispatchPollIntervalMillis >>> 32 ^ $shardConsumerDispatchPollIntervalMillis);
        ShardPrioritization $shardPrioritization = this.shardPrioritization();
        result = result * 59 + ($shardPrioritization == null ? 43 : $shardPrioritization.hashCode());
        WorkerStateChangeListener $workerStateChangeListener = this.workerStateChangeListener();
        result = result * 59 + ($workerStateChangeListener == null ? 43 : $workerStateChangeListener.hashCode());
        GracefulShutdownCoordinator $gracefulShutdownCoordinator = this.gracefulShutdownCoordinator();
        result = result * 59 + ($gracefulShutdownCoordinator == null ? 43 : $gracefulShutdownCoordinator.hashCode());
        CoordinatorFactory $coordinatorFactory = this.coordinatorFactory();
        result = result * 59 + ($coordinatorFactory == null ? 43 : $coordinatorFactory.hashCode());
        long $schedulerInitializationBackoffTimeMillis = this.schedulerInitializationBackoffTimeMillis();
        result = result * 59 + (int)($schedulerInitializationBackoffTimeMillis >>> 32 ^ $schedulerInitializationBackoffTimeMillis);
        return result;
    }

    public String toString() {
        return "CoordinatorConfig(applicationName=" + this.applicationName() + ", maxInitializationAttempts=" + this.maxInitializationAttempts() + ", parentShardPollIntervalMillis=" + this.parentShardPollIntervalMillis() + ", skipShardSyncAtWorkerInitializationIfLeasesExist=" + this.skipShardSyncAtWorkerInitializationIfLeasesExist() + ", shardConsumerDispatchPollIntervalMillis=" + this.shardConsumerDispatchPollIntervalMillis() + ", shardPrioritization=" + this.shardPrioritization() + ", workerStateChangeListener=" + this.workerStateChangeListener() + ", gracefulShutdownCoordinator=" + this.gracefulShutdownCoordinator() + ", coordinatorFactory=" + this.coordinatorFactory() + ", schedulerInitializationBackoffTimeMillis=" + this.schedulerInitializationBackoffTimeMillis() + ")";
    }
}

