/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.leases;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.kinesis.model.Shard;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.kinesis.annotations.KinesisClientInternalApi;
import software.amazon.kinesis.common.InitialPositionInStream;
import software.amazon.kinesis.common.InitialPositionInStreamExtended;
import software.amazon.kinesis.exceptions.internal.KinesisClientLibIOException;
import software.amazon.kinesis.leases.Lease;
import software.amazon.kinesis.leases.LeaseRefresher;
import software.amazon.kinesis.leases.ShardDetector;
import software.amazon.kinesis.leases.exceptions.DependencyException;
import software.amazon.kinesis.leases.exceptions.InvalidStateException;
import software.amazon.kinesis.leases.exceptions.ProvisionedThroughputException;
import software.amazon.kinesis.metrics.MetricsLevel;
import software.amazon.kinesis.metrics.MetricsScope;
import software.amazon.kinesis.metrics.MetricsUtil;
import software.amazon.kinesis.retrieval.kpl.ExtendedSequenceNumber;

@KinesisClientInternalApi
public class HierarchicalShardSyncer {
    private static final Logger log = LoggerFactory.getLogger(HierarchicalShardSyncer.class);

    public synchronized void checkAndCreateLeaseForNewShards(@NonNull ShardDetector shardDetector, LeaseRefresher leaseRefresher, InitialPositionInStreamExtended initialPosition, boolean cleanupLeasesOfCompletedShards, boolean ignoreUnexpectedChildShards, MetricsScope scope) throws DependencyException, InvalidStateException, ProvisionedThroughputException, KinesisClientLibIOException {
        if (shardDetector == null) {
            throw new NullPointerException("shardDetector");
        }
        List<Shard> latestShards = HierarchicalShardSyncer.getShardList(shardDetector);
        this.checkAndCreateLeaseForNewShards(shardDetector, leaseRefresher, initialPosition, cleanupLeasesOfCompletedShards, ignoreUnexpectedChildShards, scope, latestShards);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkAndCreateLeaseForNewShards(@NonNull ShardDetector shardDetector, LeaseRefresher leaseRefresher, InitialPositionInStreamExtended initialPosition, boolean cleanupLeasesOfCompletedShards, boolean ignoreUnexpectedChildShards, MetricsScope scope, List<Shard> latestShards) throws DependencyException, InvalidStateException, ProvisionedThroughputException, KinesisClientLibIOException {
        if (shardDetector == null) {
            throw new NullPointerException("shardDetector");
        }
        if (!CollectionUtils.isNullOrEmpty(latestShards)) {
            log.debug("Num shards: {}", (Object)latestShards.size());
        }
        Map<String, Shard> shardIdToShardMap = HierarchicalShardSyncer.constructShardIdToShardMap(latestShards);
        Map<String, Set<String>> shardIdToChildShardIdsMap = HierarchicalShardSyncer.constructShardIdToChildShardIdsMap(shardIdToShardMap);
        Set<String> inconsistentShardIds = HierarchicalShardSyncer.findInconsistentShardIds(shardIdToChildShardIdsMap, shardIdToShardMap);
        if (!ignoreUnexpectedChildShards) {
            HierarchicalShardSyncer.assertAllParentShardsAreClosed(inconsistentShardIds);
        }
        List<Lease> currentLeases = leaseRefresher.listLeases();
        List<Lease> newLeasesToCreate = HierarchicalShardSyncer.determineNewLeasesToCreate(latestShards, currentLeases, initialPosition, inconsistentShardIds);
        log.debug("Num new leases to create: {}", (Object)newLeasesToCreate.size());
        for (Lease lease : newLeasesToCreate) {
            long startTime = System.currentTimeMillis();
            boolean success = false;
            try {
                leaseRefresher.createLeaseIfNotExists(lease);
                success = true;
            }
            finally {
                MetricsUtil.addSuccessAndLatency(scope, "CreateLease", success, startTime, MetricsLevel.DETAILED);
            }
        }
        ArrayList<Lease> trackedLeases = new ArrayList<Lease>(currentLeases);
        trackedLeases.addAll(newLeasesToCreate);
        HierarchicalShardSyncer.cleanupGarbageLeases(shardDetector, latestShards, trackedLeases, leaseRefresher);
        if (cleanupLeasesOfCompletedShards) {
            this.cleanupLeasesOfFinishedShards(currentLeases, shardIdToShardMap, shardIdToChildShardIdsMap, trackedLeases, leaseRefresher);
        }
    }

    private static void assertAllParentShardsAreClosed(Set<String> inconsistentShardIds) throws KinesisClientLibIOException {
        if (!CollectionUtils.isNullOrEmpty(inconsistentShardIds)) {
            String ids = StringUtils.join(inconsistentShardIds, (char)' ');
            throw new KinesisClientLibIOException(String.format("%d open child shards (%s) are inconsistent. This can happen due to a race condition between describeStream and a reshard operation.", inconsistentShardIds.size(), ids));
        }
    }

    private static Set<String> findInconsistentShardIds(Map<String, Set<String>> shardIdToChildShardIdsMap, Map<String, Shard> shardIdToShardMap) {
        return shardIdToChildShardIdsMap.entrySet().stream().filter(entry -> entry.getKey() == null || ((Shard)shardIdToShardMap.get(entry.getKey())).sequenceNumberRange().endingSequenceNumber() == null).flatMap(entry -> ((Set)shardIdToChildShardIdsMap.get(entry.getKey())).stream()).collect(Collectors.toSet());
    }

    synchronized void assertClosedShardsAreCoveredOrAbsent(Map<String, Shard> shardIdToShardMap, Map<String, Set<String>> shardIdToChildShardIdsMap, Set<String> shardIdsOfClosedShards) throws KinesisClientLibIOException {
        String exceptionMessageSuffix = "This can happen if we constructed the list of shards  while a reshard operation was in progress.";
        for (String shardId : shardIdsOfClosedShards) {
            Shard shard = shardIdToShardMap.get(shardId);
            if (shard == null) {
                log.info("Shard {} is not present in Kinesis anymore.", (Object)shardId);
                continue;
            }
            String endingSequenceNumber = shard.sequenceNumberRange().endingSequenceNumber();
            if (endingSequenceNumber == null) {
                throw new KinesisClientLibIOException("Shard " + shardIdsOfClosedShards + " is not closed. " + "This can happen if we constructed the list of shards  while a reshard operation was in progress.");
            }
            Set<String> childShardIds = shardIdToChildShardIdsMap.get(shardId);
            if (childShardIds == null) {
                throw new KinesisClientLibIOException("Incomplete shard list: Closed shard " + shardId + " has no children." + "This can happen if we constructed the list of shards  while a reshard operation was in progress.");
            }
            this.assertHashRangeOfClosedShardIsCovered(shard, shardIdToShardMap, childShardIds);
        }
    }

    private synchronized void assertHashRangeOfClosedShardIsCovered(Shard closedShard, Map<String, Shard> shardIdToShardMap, Set<String> childShardIds) throws KinesisClientLibIOException {
        BigInteger minStartingHashKeyOfChildren = null;
        BigInteger maxEndingHashKeyOfChildren = null;
        BigInteger startingHashKeyOfClosedShard = new BigInteger(closedShard.hashKeyRange().startingHashKey());
        BigInteger endingHashKeyOfClosedShard = new BigInteger(closedShard.hashKeyRange().endingHashKey());
        for (String childShardId : childShardIds) {
            Shard childShard = shardIdToShardMap.get(childShardId);
            BigInteger startingHashKey = new BigInteger(childShard.hashKeyRange().startingHashKey());
            if (minStartingHashKeyOfChildren == null || startingHashKey.compareTo(minStartingHashKeyOfChildren) < 0) {
                minStartingHashKeyOfChildren = startingHashKey;
            }
            BigInteger endingHashKey = new BigInteger(childShard.hashKeyRange().endingHashKey());
            if (maxEndingHashKeyOfChildren != null && endingHashKey.compareTo(maxEndingHashKeyOfChildren) <= 0) continue;
            maxEndingHashKeyOfChildren = endingHashKey;
        }
        if (minStartingHashKeyOfChildren == null || maxEndingHashKeyOfChildren == null || minStartingHashKeyOfChildren.compareTo(startingHashKeyOfClosedShard) > 0 || maxEndingHashKeyOfChildren.compareTo(endingHashKeyOfClosedShard) < 0) {
            throw new KinesisClientLibIOException(String.format("Incomplete shard list: hash key range of shard %s is not covered by its child shards.", closedShard.shardId()));
        }
    }

    static Map<String, Set<String>> constructShardIdToChildShardIdsMap(Map<String, Shard> shardIdToShardMap) {
        HashMap<String, Set<String>> shardIdToChildShardIdsMap = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Shard> entry : shardIdToShardMap.entrySet()) {
            String adjacentParentShardId;
            String shardId = entry.getKey();
            Shard shard = entry.getValue();
            String parentShardId = shard.parentShardId();
            if (parentShardId != null && shardIdToShardMap.containsKey(parentShardId)) {
                Set childShardIds = shardIdToChildShardIdsMap.computeIfAbsent(parentShardId, key -> new HashSet());
                childShardIds.add(shardId);
            }
            if ((adjacentParentShardId = shard.adjacentParentShardId()) == null || !shardIdToShardMap.containsKey(adjacentParentShardId)) continue;
            Set childShardIds = shardIdToChildShardIdsMap.computeIfAbsent(adjacentParentShardId, key -> new HashSet());
            childShardIds.add(shardId);
        }
        return shardIdToChildShardIdsMap;
    }

    private static List<Shard> getShardList(@NonNull ShardDetector shardDetector) throws KinesisClientLibIOException {
        if (shardDetector == null) {
            throw new NullPointerException("shardDetector");
        }
        List<Shard> shards = shardDetector.listShards();
        if (shards == null) {
            throw new KinesisClientLibIOException("Stream is not in ACTIVE OR UPDATING state - will retry getting the shard list.");
        }
        return shards;
    }

    static List<Lease> determineNewLeasesToCreate(List<Shard> shards, List<Lease> currentLeases, InitialPositionInStreamExtended initialPosition, Set<String> inconsistentShardIds) {
        HashMap<String, Lease> shardIdToNewLeaseMap = new HashMap<String, Lease>();
        Map<String, Shard> shardIdToShardMapOfAllKinesisShards = HierarchicalShardSyncer.constructShardIdToShardMap(shards);
        Set<String> shardIdsOfCurrentLeases = currentLeases.stream().peek(lease -> log.debug("Existing lease: {}", lease)).map(Lease::leaseKey).collect(Collectors.toSet());
        List<Shard> openShards = HierarchicalShardSyncer.getOpenShards(shards);
        HashMap<String, Boolean> memoizationContext = new HashMap<String, Boolean>();
        for (Shard shard : openShards) {
            String shardId = shard.shardId();
            log.debug("Evaluating leases for open shard {} and its ancestors.", (Object)shardId);
            if (shardIdsOfCurrentLeases.contains(shardId)) {
                log.debug("Lease for shardId {} already exists. Not creating a lease", (Object)shardId);
                continue;
            }
            if (inconsistentShardIds.contains(shardId)) {
                log.info("shardId {} is an inconsistent child.  Not creating a lease", (Object)shardId);
                continue;
            }
            log.debug("Need to create a lease for shardId {}", (Object)shardId);
            Lease newLease = HierarchicalShardSyncer.newKCLLease(shard);
            boolean isDescendant = HierarchicalShardSyncer.checkIfDescendantAndAddNewLeasesForAncestors(shardId, initialPosition, shardIdsOfCurrentLeases, shardIdToShardMapOfAllKinesisShards, shardIdToNewLeaseMap, memoizationContext);
            if (isDescendant && !initialPosition.getInitialPositionInStream().equals((Object)InitialPositionInStream.AT_TIMESTAMP)) {
                newLease.checkpoint(ExtendedSequenceNumber.TRIM_HORIZON);
            } else {
                newLease.checkpoint(HierarchicalShardSyncer.convertToCheckpoint(initialPosition));
            }
            log.debug("Set checkpoint of {} to {}", (Object)newLease.leaseKey(), (Object)newLease.checkpoint());
            shardIdToNewLeaseMap.put(shardId, newLease);
        }
        ArrayList<Lease> newLeasesToCreate = new ArrayList<Lease>(shardIdToNewLeaseMap.values());
        StartingSequenceNumberAndShardIdBasedComparator startingSequenceNumberComparator = new StartingSequenceNumberAndShardIdBasedComparator(shardIdToShardMapOfAllKinesisShards);
        newLeasesToCreate.sort(startingSequenceNumberComparator);
        return newLeasesToCreate;
    }

    static List<Lease> determineNewLeasesToCreate(List<Shard> shards, List<Lease> currentLeases, InitialPositionInStreamExtended initialPosition) {
        HashSet<String> inconsistentShardIds = new HashSet<String>();
        return HierarchicalShardSyncer.determineNewLeasesToCreate(shards, currentLeases, initialPosition, inconsistentShardIds);
    }

    static boolean checkIfDescendantAndAddNewLeasesForAncestors(String shardId, InitialPositionInStreamExtended initialPosition, Set<String> shardIdsOfCurrentLeases, Map<String, Shard> shardIdToShardMapOfAllKinesisShards, Map<String, Lease> shardIdToLeaseMapOfNewShards, Map<String, Boolean> memoizationContext) {
        Boolean previousValue = memoizationContext.get(shardId);
        if (previousValue != null) {
            return previousValue;
        }
        boolean isDescendant = false;
        HashSet<String> descendantParentShardIds = new HashSet<String>();
        if (shardId != null && shardIdToShardMapOfAllKinesisShards.containsKey(shardId)) {
            if (shardIdsOfCurrentLeases.contains(shardId)) {
                isDescendant = true;
            } else {
                Shard shard = shardIdToShardMapOfAllKinesisShards.get(shardId);
                Set<String> parentShardIds = HierarchicalShardSyncer.getParentShardIds(shard, shardIdToShardMapOfAllKinesisShards);
                for (String parentShardId : parentShardIds) {
                    if (HierarchicalShardSyncer.checkIfDescendantAndAddNewLeasesForAncestors(parentShardId, initialPosition, shardIdsOfCurrentLeases, shardIdToShardMapOfAllKinesisShards, shardIdToLeaseMapOfNewShards, memoizationContext)) {
                        isDescendant = true;
                        descendantParentShardIds.add(parentShardId);
                        log.debug("Parent shard {} is a descendant.", (Object)parentShardId);
                        continue;
                    }
                    log.debug("Parent shard {} is NOT a descendant.", (Object)parentShardId);
                }
                if (isDescendant) {
                    for (String parentShardId : parentShardIds) {
                        if (shardIdsOfCurrentLeases.contains(parentShardId)) continue;
                        log.debug("Need to create a lease for shardId {}", (Object)parentShardId);
                        Lease lease = shardIdToLeaseMapOfNewShards.get(parentShardId);
                        if (lease == null) {
                            lease = HierarchicalShardSyncer.newKCLLease(shardIdToShardMapOfAllKinesisShards.get(parentShardId));
                            shardIdToLeaseMapOfNewShards.put(parentShardId, lease);
                        }
                        if (descendantParentShardIds.contains(parentShardId) && !initialPosition.getInitialPositionInStream().equals((Object)InitialPositionInStream.AT_TIMESTAMP)) {
                            lease.checkpoint(ExtendedSequenceNumber.TRIM_HORIZON);
                            continue;
                        }
                        lease.checkpoint(HierarchicalShardSyncer.convertToCheckpoint(initialPosition));
                    }
                } else if (initialPosition.getInitialPositionInStream().equals((Object)InitialPositionInStream.TRIM_HORIZON) || initialPosition.getInitialPositionInStream().equals((Object)InitialPositionInStream.AT_TIMESTAMP)) {
                    isDescendant = true;
                }
            }
        }
        memoizationContext.put(shardId, isDescendant);
        return isDescendant;
    }

    static Set<String> getParentShardIds(Shard shard, Map<String, Shard> shardIdToShardMapOfAllKinesisShards) {
        String adjacentParentShardId;
        HashSet<String> parentShardIds = new HashSet<String>(2);
        String parentShardId = shard.parentShardId();
        if (parentShardId != null && shardIdToShardMapOfAllKinesisShards.containsKey(parentShardId)) {
            parentShardIds.add(parentShardId);
        }
        if ((adjacentParentShardId = shard.adjacentParentShardId()) != null && shardIdToShardMapOfAllKinesisShards.containsKey(adjacentParentShardId)) {
            parentShardIds.add(adjacentParentShardId);
        }
        return parentShardIds;
    }

    private static void cleanupGarbageLeases(@NonNull ShardDetector shardDetector, List<Shard> shards, List<Lease> trackedLeases, LeaseRefresher leaseRefresher) throws KinesisClientLibIOException, DependencyException, InvalidStateException, ProvisionedThroughputException {
        if (shardDetector == null) {
            throw new NullPointerException("shardDetector");
        }
        Set kinesisShards = shards.stream().map(Shard::shardId).collect(Collectors.toSet());
        List garbageLeases = trackedLeases.stream().filter(lease -> HierarchicalShardSyncer.isCandidateForCleanup(lease, kinesisShards)).collect(Collectors.toList());
        if (!CollectionUtils.isNullOrEmpty(garbageLeases)) {
            log.info("Found {} candidate leases for cleanup. Refreshing list of Kinesis shards to pick up recent/latest shards", (Object)garbageLeases.size());
            Set<String> currentKinesisShardIds = HierarchicalShardSyncer.getShardList(shardDetector).stream().map(Shard::shardId).collect(Collectors.toSet());
            for (Lease lease2 : garbageLeases) {
                if (!HierarchicalShardSyncer.isCandidateForCleanup(lease2, currentKinesisShardIds)) continue;
                log.info("Deleting lease for shard {} as it is not present in Kinesis stream.", (Object)lease2.leaseKey());
                leaseRefresher.deleteLease(lease2);
            }
        }
    }

    static boolean isCandidateForCleanup(Lease lease, Set<String> currentKinesisShardIds) throws KinesisClientLibIOException {
        boolean isCandidateForCleanup = true;
        if (currentKinesisShardIds.contains(lease.leaseKey())) {
            isCandidateForCleanup = false;
        } else {
            log.info("Found lease for non-existent shard: {}. Checking its parent shards", (Object)lease.leaseKey());
            Set<String> parentShardIds = lease.parentShardIds();
            for (String parentShardId : parentShardIds) {
                if (!currentKinesisShardIds.contains(parentShardId)) continue;
                String message = String.format("Parent shard %s exists but not the child shard %s", parentShardId, lease.leaseKey());
                log.info(message);
                throw new KinesisClientLibIOException(message);
            }
        }
        return isCandidateForCleanup;
    }

    private synchronized void cleanupLeasesOfFinishedShards(Collection<Lease> currentLeases, Map<String, Shard> shardIdToShardMap, Map<String, Set<String>> shardIdToChildShardIdsMap, List<Lease> trackedLeases, LeaseRefresher leaseRefresher) throws DependencyException, InvalidStateException, ProvisionedThroughputException, KinesisClientLibIOException {
        List leasesOfClosedShards = currentLeases.stream().filter(lease -> lease.checkpoint().equals(ExtendedSequenceNumber.SHARD_END)).collect(Collectors.toList());
        Set<String> shardIdsOfClosedShards = leasesOfClosedShards.stream().map(Lease::leaseKey).collect(Collectors.toSet());
        if (!CollectionUtils.isNullOrEmpty(leasesOfClosedShards)) {
            this.assertClosedShardsAreCoveredOrAbsent(shardIdToShardMap, shardIdToChildShardIdsMap, shardIdsOfClosedShards);
            StartingSequenceNumberAndShardIdBasedComparator startingSequenceNumberComparator = new StartingSequenceNumberAndShardIdBasedComparator(shardIdToShardMap);
            leasesOfClosedShards.sort(startingSequenceNumberComparator);
            Map<String, Lease> trackedLeaseMap = trackedLeases.stream().collect(Collectors.toMap(Lease::leaseKey, Function.identity()));
            for (Lease leaseOfClosedShard : leasesOfClosedShards) {
                String closedShardId = leaseOfClosedShard.leaseKey();
                Set<String> childShardIds = shardIdToChildShardIdsMap.get(closedShardId);
                if (closedShardId == null || CollectionUtils.isNullOrEmpty(childShardIds)) continue;
                this.cleanupLeaseForClosedShard(closedShardId, childShardIds, trackedLeaseMap, leaseRefresher);
            }
        }
    }

    synchronized void cleanupLeaseForClosedShard(String closedShardId, Set<String> childShardIds, Map<String, Lease> trackedLeases, LeaseRefresher leaseRefresher) throws DependencyException, InvalidStateException, ProvisionedThroughputException {
        Lease leaseForClosedShard = trackedLeases.get(closedShardId);
        List childShardLeases = childShardIds.stream().map(trackedLeases::get).filter(Objects::nonNull).collect(Collectors.toList());
        if (leaseForClosedShard != null && leaseForClosedShard.checkpoint().equals(ExtendedSequenceNumber.SHARD_END) && childShardLeases.size() == childShardIds.size()) {
            boolean okayToDelete = true;
            for (Lease lease : childShardLeases) {
                if (!lease.checkpoint().equals(ExtendedSequenceNumber.TRIM_HORIZON)) continue;
                okayToDelete = false;
                break;
            }
            if (okayToDelete) {
                log.info("Deleting lease for shard {} as it has been completely processed and processing of child shards has begun.", (Object)leaseForClosedShard.leaseKey());
                leaseRefresher.deleteLease(leaseForClosedShard);
            }
        }
    }

    private static Lease newKCLLease(Shard shard) {
        Lease newLease = new Lease();
        newLease.leaseKey(shard.shardId());
        ArrayList<String> parentShardIds = new ArrayList<String>(2);
        if (shard.parentShardId() != null) {
            parentShardIds.add(shard.parentShardId());
        }
        if (shard.adjacentParentShardId() != null) {
            parentShardIds.add(shard.adjacentParentShardId());
        }
        newLease.parentShardIds(parentShardIds);
        newLease.ownerSwitchesSinceCheckpoint(0L);
        return newLease;
    }

    static Map<String, Shard> constructShardIdToShardMap(List<Shard> shards) {
        return shards.stream().collect(Collectors.toMap(Shard::shardId, Function.identity()));
    }

    static List<Shard> getOpenShards(List<Shard> allShards) {
        return allShards.stream().filter(shard -> shard.sequenceNumberRange().endingSequenceNumber() == null).peek(shard -> log.debug("Found open shard: {}", (Object)shard.shardId())).collect(Collectors.toList());
    }

    private static ExtendedSequenceNumber convertToCheckpoint(InitialPositionInStreamExtended position) {
        ExtendedSequenceNumber checkpoint = null;
        if (position.getInitialPositionInStream().equals((Object)InitialPositionInStream.TRIM_HORIZON)) {
            checkpoint = ExtendedSequenceNumber.TRIM_HORIZON;
        } else if (position.getInitialPositionInStream().equals((Object)InitialPositionInStream.LATEST)) {
            checkpoint = ExtendedSequenceNumber.LATEST;
        } else if (position.getInitialPositionInStream().equals((Object)InitialPositionInStream.AT_TIMESTAMP)) {
            checkpoint = ExtendedSequenceNumber.AT_TIMESTAMP;
        }
        return checkpoint;
    }

    private static class StartingSequenceNumberAndShardIdBasedComparator
    implements Comparator<Lease>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Map<String, Shard> shardIdToShardMap;

        @Override
        public int compare(Lease lease1, Lease lease2) {
            int result = 0;
            String shardId1 = lease1.leaseKey();
            String shardId2 = lease2.leaseKey();
            Shard shard1 = this.shardIdToShardMap.get(shardId1);
            Shard shard2 = this.shardIdToShardMap.get(shardId2);
            if (shard1 != null && shard2 != null) {
                BigInteger sequenceNumber1 = new BigInteger(shard1.sequenceNumberRange().startingSequenceNumber());
                BigInteger sequenceNumber2 = new BigInteger(shard2.sequenceNumberRange().startingSequenceNumber());
                result = sequenceNumber1.compareTo(sequenceNumber2);
            }
            if (result == 0) {
                result = shardId1.compareTo(shardId2);
            }
            return result;
        }

        public StartingSequenceNumberAndShardIdBasedComparator(Map<String, Shard> shardIdToShardMap) {
            this.shardIdToShardMap = shardIdToShardMap;
        }
    }
}

