/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.leases;

import java.util.List;
import software.amazon.kinesis.leases.Lease;
import software.amazon.kinesis.leases.exceptions.DependencyException;
import software.amazon.kinesis.leases.exceptions.InvalidStateException;
import software.amazon.kinesis.leases.exceptions.ProvisionedThroughputException;
import software.amazon.kinesis.retrieval.kpl.ExtendedSequenceNumber;

public interface LeaseRefresher {
    public boolean createLeaseTableIfNotExists(Long var1, Long var2) throws ProvisionedThroughputException, DependencyException;

    public boolean leaseTableExists() throws DependencyException;

    public boolean waitUntilLeaseTableExists(long var1, long var3) throws DependencyException;

    public List<Lease> listLeases() throws DependencyException, InvalidStateException, ProvisionedThroughputException;

    public boolean createLeaseIfNotExists(Lease var1) throws DependencyException, InvalidStateException, ProvisionedThroughputException;

    public Lease getLease(String var1) throws DependencyException, InvalidStateException, ProvisionedThroughputException;

    public boolean renewLease(Lease var1) throws DependencyException, InvalidStateException, ProvisionedThroughputException;

    public boolean takeLease(Lease var1, String var2) throws DependencyException, InvalidStateException, ProvisionedThroughputException;

    public boolean evictLease(Lease var1) throws DependencyException, InvalidStateException, ProvisionedThroughputException;

    public void deleteLease(Lease var1) throws DependencyException, InvalidStateException, ProvisionedThroughputException;

    public void deleteAll() throws DependencyException, InvalidStateException, ProvisionedThroughputException;

    public boolean updateLease(Lease var1) throws DependencyException, InvalidStateException, ProvisionedThroughputException;

    public boolean isLeaseTableEmpty() throws DependencyException, InvalidStateException, ProvisionedThroughputException;

    public ExtendedSequenceNumber getCheckpoint(String var1) throws ProvisionedThroughputException, InvalidStateException, DependencyException;
}

