/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.metrics;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.MetricDatum;
import software.amazon.awssdk.services.cloudwatch.model.StatisticSet;
import software.amazon.kinesis.metrics.AccumulateByNameMetricsScope;

public class LogMetricsScope
extends AccumulateByNameMetricsScope {
    private static final Logger log = LoggerFactory.getLogger(LogMetricsScope.class);

    @Override
    public void end() {
        StringBuilder output = new StringBuilder();
        output.append("Metrics:\n");
        output.append("Dimensions: ");
        boolean needsComma = false;
        for (Dimension dimension : this.getDimensions()) {
            output.append(String.format("%s[%s: %s]", needsComma ? ", " : "", dimension.name(), dimension.value()));
            needsComma = true;
        }
        output.append("\n");
        for (MetricDatum datum : this.data.values()) {
            StatisticSet statistics = datum.statisticValues();
            output.append(String.format("Name=%25s\tMin=%.2f\tMax=%.2f\tCount=%.2f\tSum=%.2f\tAvg=%.2f\tUnit=%s\n", datum.metricName(), statistics.minimum(), statistics.maximum(), statistics.sampleCount(), statistics.sum(), statistics.sum() / statistics.sampleCount(), datum.unit()));
        }
        log.info(output.toString());
    }
}

