/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.retrieval;

import lombok.NonNull;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.kinesis.common.InitialPositionInStream;
import software.amazon.kinesis.common.InitialPositionInStreamExtended;
import software.amazon.kinesis.retrieval.RetrievalFactory;
import software.amazon.kinesis.retrieval.RetrievalSpecificConfig;
import software.amazon.kinesis.retrieval.fanout.FanOutConfig;

public class RetrievalConfig {
    public static final String KINESIS_CLIENT_LIB_USER_AGENT = "amazon-kinesis-client-library-java";
    public static final String KINESIS_CLIENT_LIB_USER_AGENT_VERSION = "2.2.8";
    @NonNull
    private final KinesisAsyncClient kinesisClient;
    @NonNull
    private final String streamName;
    @NonNull
    private final String applicationName;
    private long listShardsBackoffTimeInMillis = 1500L;
    private int maxListShardsRetryAttempts = 50;
    private InitialPositionInStreamExtended initialPositionInStreamExtended = InitialPositionInStreamExtended.newInitialPosition(InitialPositionInStream.LATEST);
    private RetrievalSpecificConfig retrievalSpecificConfig;
    private RetrievalFactory retrievalFactory;

    public RetrievalFactory retrievalFactory() {
        if (this.retrievalFactory == null) {
            if (this.retrievalSpecificConfig == null) {
                this.retrievalSpecificConfig = new FanOutConfig(this.kinesisClient()).streamName(this.streamName()).applicationName(this.applicationName());
            }
            this.retrievalFactory = this.retrievalSpecificConfig.retrievalFactory();
        }
        return this.retrievalFactory;
    }

    public RetrievalConfig(@NonNull KinesisAsyncClient kinesisClient, @NonNull String streamName, @NonNull String applicationName) {
        if (kinesisClient == null) {
            throw new NullPointerException("kinesisClient");
        }
        if (streamName == null) {
            throw new NullPointerException("streamName");
        }
        if (applicationName == null) {
            throw new NullPointerException("applicationName");
        }
        this.kinesisClient = kinesisClient;
        this.streamName = streamName;
        this.applicationName = applicationName;
    }

    @NonNull
    public KinesisAsyncClient kinesisClient() {
        return this.kinesisClient;
    }

    @NonNull
    public String streamName() {
        return this.streamName;
    }

    @NonNull
    public String applicationName() {
        return this.applicationName;
    }

    public long listShardsBackoffTimeInMillis() {
        return this.listShardsBackoffTimeInMillis;
    }

    public int maxListShardsRetryAttempts() {
        return this.maxListShardsRetryAttempts;
    }

    public InitialPositionInStreamExtended initialPositionInStreamExtended() {
        return this.initialPositionInStreamExtended;
    }

    public RetrievalSpecificConfig retrievalSpecificConfig() {
        return this.retrievalSpecificConfig;
    }

    public RetrievalConfig listShardsBackoffTimeInMillis(long listShardsBackoffTimeInMillis) {
        this.listShardsBackoffTimeInMillis = listShardsBackoffTimeInMillis;
        return this;
    }

    public RetrievalConfig maxListShardsRetryAttempts(int maxListShardsRetryAttempts) {
        this.maxListShardsRetryAttempts = maxListShardsRetryAttempts;
        return this;
    }

    public RetrievalConfig initialPositionInStreamExtended(InitialPositionInStreamExtended initialPositionInStreamExtended) {
        this.initialPositionInStreamExtended = initialPositionInStreamExtended;
        return this;
    }

    public RetrievalConfig retrievalSpecificConfig(RetrievalSpecificConfig retrievalSpecificConfig) {
        this.retrievalSpecificConfig = retrievalSpecificConfig;
        return this;
    }

    public RetrievalConfig retrievalFactory(RetrievalFactory retrievalFactory) {
        this.retrievalFactory = retrievalFactory;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RetrievalConfig)) {
            return false;
        }
        RetrievalConfig other = (RetrievalConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        KinesisAsyncClient this$kinesisClient = this.kinesisClient();
        KinesisAsyncClient other$kinesisClient = other.kinesisClient();
        if (this$kinesisClient == null ? other$kinesisClient != null : !this$kinesisClient.equals(other$kinesisClient)) {
            return false;
        }
        String this$streamName = this.streamName();
        String other$streamName = other.streamName();
        if (this$streamName == null ? other$streamName != null : !this$streamName.equals(other$streamName)) {
            return false;
        }
        String this$applicationName = this.applicationName();
        String other$applicationName = other.applicationName();
        if (this$applicationName == null ? other$applicationName != null : !this$applicationName.equals(other$applicationName)) {
            return false;
        }
        if (this.listShardsBackoffTimeInMillis() != other.listShardsBackoffTimeInMillis()) {
            return false;
        }
        if (this.maxListShardsRetryAttempts() != other.maxListShardsRetryAttempts()) {
            return false;
        }
        InitialPositionInStreamExtended this$initialPositionInStreamExtended = this.initialPositionInStreamExtended();
        InitialPositionInStreamExtended other$initialPositionInStreamExtended = other.initialPositionInStreamExtended();
        if (this$initialPositionInStreamExtended == null ? other$initialPositionInStreamExtended != null : !this$initialPositionInStreamExtended.equals(other$initialPositionInStreamExtended)) {
            return false;
        }
        RetrievalSpecificConfig this$retrievalSpecificConfig = this.retrievalSpecificConfig();
        RetrievalSpecificConfig other$retrievalSpecificConfig = other.retrievalSpecificConfig();
        if (this$retrievalSpecificConfig == null ? other$retrievalSpecificConfig != null : !this$retrievalSpecificConfig.equals(other$retrievalSpecificConfig)) {
            return false;
        }
        RetrievalFactory this$retrievalFactory = this.retrievalFactory();
        RetrievalFactory other$retrievalFactory = other.retrievalFactory();
        return !(this$retrievalFactory == null ? other$retrievalFactory != null : !this$retrievalFactory.equals(other$retrievalFactory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RetrievalConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        KinesisAsyncClient $kinesisClient = this.kinesisClient();
        result = result * 59 + ($kinesisClient == null ? 43 : $kinesisClient.hashCode());
        String $streamName = this.streamName();
        result = result * 59 + ($streamName == null ? 43 : $streamName.hashCode());
        String $applicationName = this.applicationName();
        result = result * 59 + ($applicationName == null ? 43 : $applicationName.hashCode());
        long $listShardsBackoffTimeInMillis = this.listShardsBackoffTimeInMillis();
        result = result * 59 + (int)($listShardsBackoffTimeInMillis >>> 32 ^ $listShardsBackoffTimeInMillis);
        result = result * 59 + this.maxListShardsRetryAttempts();
        InitialPositionInStreamExtended $initialPositionInStreamExtended = this.initialPositionInStreamExtended();
        result = result * 59 + ($initialPositionInStreamExtended == null ? 43 : $initialPositionInStreamExtended.hashCode());
        RetrievalSpecificConfig $retrievalSpecificConfig = this.retrievalSpecificConfig();
        result = result * 59 + ($retrievalSpecificConfig == null ? 43 : $retrievalSpecificConfig.hashCode());
        RetrievalFactory $retrievalFactory = this.retrievalFactory();
        result = result * 59 + ($retrievalFactory == null ? 43 : $retrievalFactory.hashCode());
        return result;
    }

    public String toString() {
        return "RetrievalConfig(kinesisClient=" + this.kinesisClient() + ", streamName=" + this.streamName() + ", applicationName=" + this.applicationName() + ", listShardsBackoffTimeInMillis=" + this.listShardsBackoffTimeInMillis() + ", maxListShardsRetryAttempts=" + this.maxListShardsRetryAttempts() + ", initialPositionInStreamExtended=" + this.initialPositionInStreamExtended() + ", retrievalSpecificConfig=" + this.retrievalSpecificConfig() + ", retrievalFactory=" + this.retrievalFactory() + ")";
    }
}

