/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.retrieval.fanout;

import com.google.common.base.Preconditions;
import lombok.NonNull;
import org.apache.commons.lang3.ObjectUtils;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.kinesis.leases.exceptions.DependencyException;
import software.amazon.kinesis.retrieval.RetrievalFactory;
import software.amazon.kinesis.retrieval.RetrievalSpecificConfig;
import software.amazon.kinesis.retrieval.fanout.FanOutConsumerRegistration;
import software.amazon.kinesis.retrieval.fanout.FanOutRetrievalFactory;

public class FanOutConfig
implements RetrievalSpecificConfig {
    @NonNull
    private final KinesisAsyncClient kinesisClient;
    private String consumerArn;
    private String streamName;
    private String consumerName;
    private String applicationName;
    private int maxDescribeStreamSummaryRetries = 10;
    private int maxDescribeStreamConsumerRetries = 10;
    private int registerStreamConsumerRetries = 10;
    private long retryBackoffMillis = 1000L;

    @Override
    public RetrievalFactory retrievalFactory() {
        return new FanOutRetrievalFactory(this.kinesisClient, this.getOrCreateConsumerArn());
    }

    private String getOrCreateConsumerArn() {
        if (this.consumerArn != null) {
            return this.consumerArn;
        }
        FanOutConsumerRegistration registration = this.createConsumerRegistration();
        try {
            return registration.getOrCreateStreamConsumerArn();
        }
        catch (DependencyException e) {
            throw new RuntimeException(e);
        }
    }

    private FanOutConsumerRegistration createConsumerRegistration() {
        String consumerToCreate = (String)ObjectUtils.firstNonNull((Object[])new String[]{this.consumerName(), this.applicationName()});
        return this.createConsumerRegistration(this.kinesisClient(), (String)Preconditions.checkNotNull((Object)this.streamName(), (Object)"streamName must be set for consumer creation"), (String)Preconditions.checkNotNull((Object)consumerToCreate, (Object)"applicationName or consumerName must be set for consumer creation"));
    }

    protected FanOutConsumerRegistration createConsumerRegistration(KinesisAsyncClient client, String stream, String consumerToCreate) {
        return new FanOutConsumerRegistration(client, stream, consumerToCreate, this.maxDescribeStreamSummaryRetries(), this.maxDescribeStreamConsumerRetries(), this.registerStreamConsumerRetries(), this.retryBackoffMillis());
    }

    public FanOutConfig(@NonNull KinesisAsyncClient kinesisClient) {
        if (kinesisClient == null) {
            throw new NullPointerException("kinesisClient");
        }
        this.kinesisClient = kinesisClient;
    }

    @NonNull
    public KinesisAsyncClient kinesisClient() {
        return this.kinesisClient;
    }

    public String consumerArn() {
        return this.consumerArn;
    }

    public String streamName() {
        return this.streamName;
    }

    public String consumerName() {
        return this.consumerName;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public int maxDescribeStreamSummaryRetries() {
        return this.maxDescribeStreamSummaryRetries;
    }

    public int maxDescribeStreamConsumerRetries() {
        return this.maxDescribeStreamConsumerRetries;
    }

    public int registerStreamConsumerRetries() {
        return this.registerStreamConsumerRetries;
    }

    public long retryBackoffMillis() {
        return this.retryBackoffMillis;
    }

    public FanOutConfig consumerArn(String consumerArn) {
        this.consumerArn = consumerArn;
        return this;
    }

    public FanOutConfig streamName(String streamName) {
        this.streamName = streamName;
        return this;
    }

    public FanOutConfig consumerName(String consumerName) {
        this.consumerName = consumerName;
        return this;
    }

    public FanOutConfig applicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    public FanOutConfig maxDescribeStreamSummaryRetries(int maxDescribeStreamSummaryRetries) {
        this.maxDescribeStreamSummaryRetries = maxDescribeStreamSummaryRetries;
        return this;
    }

    public FanOutConfig maxDescribeStreamConsumerRetries(int maxDescribeStreamConsumerRetries) {
        this.maxDescribeStreamConsumerRetries = maxDescribeStreamConsumerRetries;
        return this;
    }

    public FanOutConfig registerStreamConsumerRetries(int registerStreamConsumerRetries) {
        this.registerStreamConsumerRetries = registerStreamConsumerRetries;
        return this;
    }

    public FanOutConfig retryBackoffMillis(long retryBackoffMillis) {
        this.retryBackoffMillis = retryBackoffMillis;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FanOutConfig)) {
            return false;
        }
        FanOutConfig other = (FanOutConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        KinesisAsyncClient this$kinesisClient = this.kinesisClient();
        KinesisAsyncClient other$kinesisClient = other.kinesisClient();
        if (this$kinesisClient == null ? other$kinesisClient != null : !this$kinesisClient.equals(other$kinesisClient)) {
            return false;
        }
        String this$consumerArn = this.consumerArn();
        String other$consumerArn = other.consumerArn();
        if (this$consumerArn == null ? other$consumerArn != null : !this$consumerArn.equals(other$consumerArn)) {
            return false;
        }
        String this$streamName = this.streamName();
        String other$streamName = other.streamName();
        if (this$streamName == null ? other$streamName != null : !this$streamName.equals(other$streamName)) {
            return false;
        }
        String this$consumerName = this.consumerName();
        String other$consumerName = other.consumerName();
        if (this$consumerName == null ? other$consumerName != null : !this$consumerName.equals(other$consumerName)) {
            return false;
        }
        String this$applicationName = this.applicationName();
        String other$applicationName = other.applicationName();
        if (this$applicationName == null ? other$applicationName != null : !this$applicationName.equals(other$applicationName)) {
            return false;
        }
        if (this.maxDescribeStreamSummaryRetries() != other.maxDescribeStreamSummaryRetries()) {
            return false;
        }
        if (this.maxDescribeStreamConsumerRetries() != other.maxDescribeStreamConsumerRetries()) {
            return false;
        }
        if (this.registerStreamConsumerRetries() != other.registerStreamConsumerRetries()) {
            return false;
        }
        return this.retryBackoffMillis() == other.retryBackoffMillis();
    }

    protected boolean canEqual(Object other) {
        return other instanceof FanOutConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        KinesisAsyncClient $kinesisClient = this.kinesisClient();
        result = result * 59 + ($kinesisClient == null ? 43 : $kinesisClient.hashCode());
        String $consumerArn = this.consumerArn();
        result = result * 59 + ($consumerArn == null ? 43 : $consumerArn.hashCode());
        String $streamName = this.streamName();
        result = result * 59 + ($streamName == null ? 43 : $streamName.hashCode());
        String $consumerName = this.consumerName();
        result = result * 59 + ($consumerName == null ? 43 : $consumerName.hashCode());
        String $applicationName = this.applicationName();
        result = result * 59 + ($applicationName == null ? 43 : $applicationName.hashCode());
        result = result * 59 + this.maxDescribeStreamSummaryRetries();
        result = result * 59 + this.maxDescribeStreamConsumerRetries();
        result = result * 59 + this.registerStreamConsumerRetries();
        long $retryBackoffMillis = this.retryBackoffMillis();
        result = result * 59 + (int)($retryBackoffMillis >>> 32 ^ $retryBackoffMillis);
        return result;
    }

    public String toString() {
        return "FanOutConfig(kinesisClient=" + this.kinesisClient() + ", consumerArn=" + this.consumerArn() + ", streamName=" + this.streamName() + ", consumerName=" + this.consumerName() + ", applicationName=" + this.applicationName() + ", maxDescribeStreamSummaryRetries=" + this.maxDescribeStreamSummaryRetries() + ", maxDescribeStreamConsumerRetries=" + this.maxDescribeStreamConsumerRetries() + ", registerStreamConsumerRetries=" + this.registerStreamConsumerRetries() + ", retryBackoffMillis=" + this.retryBackoffMillis() + ")";
    }
}

