/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.retrieval.polling;

import java.time.Duration;
import lombok.NonNull;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.kinesis.annotations.KinesisClientInternalApi;
import software.amazon.kinesis.leases.ShardInfo;
import software.amazon.kinesis.metrics.MetricsFactory;
import software.amazon.kinesis.retrieval.GetRecordsRetrievalStrategy;
import software.amazon.kinesis.retrieval.RecordsFetcherFactory;
import software.amazon.kinesis.retrieval.RecordsPublisher;
import software.amazon.kinesis.retrieval.RetrievalFactory;
import software.amazon.kinesis.retrieval.polling.KinesisDataFetcher;
import software.amazon.kinesis.retrieval.polling.PollingConfig;
import software.amazon.kinesis.retrieval.polling.SynchronousGetRecordsRetrievalStrategy;

@KinesisClientInternalApi
public class SynchronousBlockingRetrievalFactory
implements RetrievalFactory {
    @NonNull
    private final String streamName;
    @NonNull
    private final KinesisAsyncClient kinesisClient;
    @NonNull
    private final RecordsFetcherFactory recordsFetcherFactory;
    private final int maxRecords;
    private final Duration kinesisRequestTimeout;

    public SynchronousBlockingRetrievalFactory(String streamName, KinesisAsyncClient kinesisClient, RecordsFetcherFactory recordsFetcherFactory, int maxRecords, Duration kinesisRequestTimeout) {
        this.streamName = streamName;
        this.kinesisClient = kinesisClient;
        this.recordsFetcherFactory = recordsFetcherFactory;
        this.maxRecords = maxRecords;
        this.kinesisRequestTimeout = kinesisRequestTimeout;
    }

    @Deprecated
    public SynchronousBlockingRetrievalFactory(String streamName, KinesisAsyncClient kinesisClient, RecordsFetcherFactory recordsFetcherFactory, int maxRecords) {
        this(streamName, kinesisClient, recordsFetcherFactory, maxRecords, PollingConfig.DEFAULT_REQUEST_TIMEOUT);
    }

    @Override
    public GetRecordsRetrievalStrategy createGetRecordsRetrievalStrategy(@NonNull ShardInfo shardInfo, @NonNull MetricsFactory metricsFactory) {
        if (shardInfo == null) {
            throw new NullPointerException("shardInfo");
        }
        if (metricsFactory == null) {
            throw new NullPointerException("metricsFactory");
        }
        return new SynchronousGetRecordsRetrievalStrategy(new KinesisDataFetcher(this.kinesisClient, this.streamName, shardInfo.shardId(), this.maxRecords, metricsFactory, this.kinesisRequestTimeout));
    }

    @Override
    public RecordsPublisher createGetRecordsCache(@NonNull ShardInfo shardInfo, @NonNull MetricsFactory metricsFactory) {
        if (shardInfo == null) {
            throw new NullPointerException("shardInfo");
        }
        if (metricsFactory == null) {
            throw new NullPointerException("metricsFactory");
        }
        return this.recordsFetcherFactory.createRecordsFetcher(this.createGetRecordsRetrievalStrategy(shardInfo, metricsFactory), shardInfo.shardId(), metricsFactory, this.maxRecords);
    }

    @NonNull
    public String getStreamName() {
        return this.streamName;
    }

    @NonNull
    public KinesisAsyncClient getKinesisClient() {
        return this.kinesisClient;
    }

    @NonNull
    public RecordsFetcherFactory getRecordsFetcherFactory() {
        return this.recordsFetcherFactory;
    }

    public int getMaxRecords() {
        return this.maxRecords;
    }

    public Duration getKinesisRequestTimeout() {
        return this.kinesisRequestTimeout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SynchronousBlockingRetrievalFactory)) {
            return false;
        }
        SynchronousBlockingRetrievalFactory other = (SynchronousBlockingRetrievalFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$streamName = this.getStreamName();
        String other$streamName = other.getStreamName();
        if (this$streamName == null ? other$streamName != null : !this$streamName.equals(other$streamName)) {
            return false;
        }
        KinesisAsyncClient this$kinesisClient = this.getKinesisClient();
        KinesisAsyncClient other$kinesisClient = other.getKinesisClient();
        if (this$kinesisClient == null ? other$kinesisClient != null : !this$kinesisClient.equals(other$kinesisClient)) {
            return false;
        }
        RecordsFetcherFactory this$recordsFetcherFactory = this.getRecordsFetcherFactory();
        RecordsFetcherFactory other$recordsFetcherFactory = other.getRecordsFetcherFactory();
        if (this$recordsFetcherFactory == null ? other$recordsFetcherFactory != null : !this$recordsFetcherFactory.equals(other$recordsFetcherFactory)) {
            return false;
        }
        if (this.getMaxRecords() != other.getMaxRecords()) {
            return false;
        }
        Duration this$kinesisRequestTimeout = this.getKinesisRequestTimeout();
        Duration other$kinesisRequestTimeout = other.getKinesisRequestTimeout();
        return !(this$kinesisRequestTimeout == null ? other$kinesisRequestTimeout != null : !((Object)this$kinesisRequestTimeout).equals(other$kinesisRequestTimeout));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SynchronousBlockingRetrievalFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $streamName = this.getStreamName();
        result = result * 59 + ($streamName == null ? 43 : $streamName.hashCode());
        KinesisAsyncClient $kinesisClient = this.getKinesisClient();
        result = result * 59 + ($kinesisClient == null ? 43 : $kinesisClient.hashCode());
        RecordsFetcherFactory $recordsFetcherFactory = this.getRecordsFetcherFactory();
        result = result * 59 + ($recordsFetcherFactory == null ? 43 : $recordsFetcherFactory.hashCode());
        result = result * 59 + this.getMaxRecords();
        Duration $kinesisRequestTimeout = this.getKinesisRequestTimeout();
        result = result * 59 + ($kinesisRequestTimeout == null ? 43 : ((Object)$kinesisRequestTimeout).hashCode());
        return result;
    }

    public String toString() {
        return "SynchronousBlockingRetrievalFactory(streamName=" + this.getStreamName() + ", kinesisClient=" + this.getKinesisClient() + ", recordsFetcherFactory=" + this.getRecordsFetcherFactory() + ", maxRecords=" + this.getMaxRecords() + ", kinesisRequestTimeout=" + this.getKinesisRequestTimeout() + ")";
    }
}

