/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.retrieval.polling;

import java.time.Duration;
import java.util.concurrent.ExecutorService;
import lombok.NonNull;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.kinesis.annotations.KinesisClientInternalApi;
import software.amazon.kinesis.leases.ShardInfo;
import software.amazon.kinesis.metrics.MetricsFactory;
import software.amazon.kinesis.retrieval.GetRecordsRetrievalStrategy;
import software.amazon.kinesis.retrieval.RecordsFetcherFactory;
import software.amazon.kinesis.retrieval.RecordsPublisher;
import software.amazon.kinesis.retrieval.RetrievalFactory;
import software.amazon.kinesis.retrieval.polling.KinesisDataFetcher;
import software.amazon.kinesis.retrieval.polling.PollingConfig;
import software.amazon.kinesis.retrieval.polling.PrefetchRecordsPublisher;
import software.amazon.kinesis.retrieval.polling.SynchronousGetRecordsRetrievalStrategy;

@KinesisClientInternalApi
public class SynchronousPrefetchingRetrievalFactory
implements RetrievalFactory {
    @NonNull
    private final String streamName;
    @NonNull
    private final KinesisAsyncClient kinesisClient;
    @NonNull
    private final RecordsFetcherFactory recordsFetcherFactory;
    private final int maxRecords;
    @NonNull
    private final ExecutorService executorService;
    private final long idleMillisBetweenCalls;
    private final Duration maxFutureWait;

    @Deprecated
    public SynchronousPrefetchingRetrievalFactory(String streamName, KinesisAsyncClient kinesisClient, RecordsFetcherFactory recordsFetcherFactory, int maxRecords, ExecutorService executorService, long idleMillisBetweenCalls) {
        this(streamName, kinesisClient, recordsFetcherFactory, maxRecords, executorService, idleMillisBetweenCalls, PollingConfig.DEFAULT_REQUEST_TIMEOUT);
    }

    public SynchronousPrefetchingRetrievalFactory(String streamName, KinesisAsyncClient kinesisClient, RecordsFetcherFactory recordsFetcherFactory, int maxRecords, ExecutorService executorService, long idleMillisBetweenCalls, Duration maxFutureWait) {
        this.streamName = streamName;
        this.kinesisClient = kinesisClient;
        this.recordsFetcherFactory = recordsFetcherFactory;
        this.maxRecords = maxRecords;
        this.executorService = executorService;
        this.idleMillisBetweenCalls = idleMillisBetweenCalls;
        this.maxFutureWait = maxFutureWait;
    }

    @Override
    public GetRecordsRetrievalStrategy createGetRecordsRetrievalStrategy(@NonNull ShardInfo shardInfo, @NonNull MetricsFactory metricsFactory) {
        if (shardInfo == null) {
            throw new NullPointerException("shardInfo");
        }
        if (metricsFactory == null) {
            throw new NullPointerException("metricsFactory");
        }
        return new SynchronousGetRecordsRetrievalStrategy(new KinesisDataFetcher(this.kinesisClient, this.streamName, shardInfo.shardId(), this.maxRecords, metricsFactory, this.maxFutureWait));
    }

    @Override
    public RecordsPublisher createGetRecordsCache(@NonNull ShardInfo shardInfo, @NonNull MetricsFactory metricsFactory) {
        if (shardInfo == null) {
            throw new NullPointerException("shardInfo");
        }
        if (metricsFactory == null) {
            throw new NullPointerException("metricsFactory");
        }
        return new PrefetchRecordsPublisher(this.recordsFetcherFactory.maxPendingProcessRecordsInput(), this.recordsFetcherFactory.maxByteSize(), this.recordsFetcherFactory.maxRecordsCount(), this.maxRecords, this.createGetRecordsRetrievalStrategy(shardInfo, metricsFactory), this.executorService, this.idleMillisBetweenCalls, metricsFactory, "Prefetching", shardInfo.shardId());
    }
}

