/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.common;

import java.time.Duration;
import software.amazon.awssdk.http.Protocol;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.Http2Configuration;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClientBuilder;

public class KinesisClientUtil {
    private static int INITIAL_WINDOW_SIZE_BYTES = 0xA00000;
    private static long HEALTH_CHECK_PING_PERIOD_MILLIS = 60000L;

    public static KinesisAsyncClient createKinesisAsyncClient(KinesisAsyncClientBuilder clientBuilder) {
        return (KinesisAsyncClient)KinesisClientUtil.adjustKinesisClientBuilder(clientBuilder).build();
    }

    public static KinesisAsyncClientBuilder adjustKinesisClientBuilder(KinesisAsyncClientBuilder builder) {
        return (KinesisAsyncClientBuilder)builder.httpClientBuilder((SdkAsyncHttpClient.Builder)NettyNioAsyncHttpClient.builder().maxConcurrency(Integer.valueOf(Integer.MAX_VALUE)).http2Configuration((Http2Configuration)Http2Configuration.builder().initialWindowSize(Integer.valueOf(INITIAL_WINDOW_SIZE_BYTES)).healthCheckPingPeriod(Duration.ofMillis(HEALTH_CHECK_PING_PERIOD_MILLIS)).build()).protocol(Protocol.HTTP2));
    }
}

