/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.leases;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.kinesis.common.InitialPositionInStreamExtended;
import software.amazon.kinesis.leases.HierarchicalShardSyncer;
import software.amazon.kinesis.leases.LeaseRefresher;
import software.amazon.kinesis.leases.ShardDetector;
import software.amazon.kinesis.leases.ShardSyncTask;
import software.amazon.kinesis.lifecycle.ConsumerTask;
import software.amazon.kinesis.lifecycle.TaskResult;
import software.amazon.kinesis.metrics.MetricsCollectingTaskDecorator;
import software.amazon.kinesis.metrics.MetricsFactory;

public class ShardSyncTaskManager {
    private static final Logger log = LoggerFactory.getLogger(ShardSyncTaskManager.class);
    @NonNull
    private final ShardDetector shardDetector;
    @NonNull
    private final LeaseRefresher leaseRefresher;
    @NonNull
    private final InitialPositionInStreamExtended initialPositionInStream;
    private final boolean cleanupLeasesUponShardCompletion;
    private final boolean ignoreUnexpectedChildShards;
    private final long shardSyncIdleTimeMillis;
    @NonNull
    private final ExecutorService executorService;
    @NonNull
    private final HierarchicalShardSyncer hierarchicalShardSyncer;
    @NonNull
    private final MetricsFactory metricsFactory;
    private ConsumerTask currentTask;
    private Future<TaskResult> future;

    @Deprecated
    public ShardSyncTaskManager(ShardDetector shardDetector, LeaseRefresher leaseRefresher, InitialPositionInStreamExtended initialPositionInStream, boolean cleanupLeasesUponShardCompletion, boolean ignoreUnexpectedChildShards, long shardSyncIdleTimeMillis, ExecutorService executorService, MetricsFactory metricsFactory) {
        this.shardDetector = shardDetector;
        this.leaseRefresher = leaseRefresher;
        this.initialPositionInStream = initialPositionInStream;
        this.cleanupLeasesUponShardCompletion = cleanupLeasesUponShardCompletion;
        this.ignoreUnexpectedChildShards = ignoreUnexpectedChildShards;
        this.shardSyncIdleTimeMillis = shardSyncIdleTimeMillis;
        this.executorService = executorService;
        this.hierarchicalShardSyncer = new HierarchicalShardSyncer();
        this.metricsFactory = metricsFactory;
    }

    public ShardSyncTaskManager(ShardDetector shardDetector, LeaseRefresher leaseRefresher, InitialPositionInStreamExtended initialPositionInStream, boolean cleanupLeasesUponShardCompletion, boolean ignoreUnexpectedChildShards, long shardSyncIdleTimeMillis, ExecutorService executorService, HierarchicalShardSyncer hierarchicalShardSyncer, MetricsFactory metricsFactory) {
        this.shardDetector = shardDetector;
        this.leaseRefresher = leaseRefresher;
        this.initialPositionInStream = initialPositionInStream;
        this.cleanupLeasesUponShardCompletion = cleanupLeasesUponShardCompletion;
        this.ignoreUnexpectedChildShards = ignoreUnexpectedChildShards;
        this.shardSyncIdleTimeMillis = shardSyncIdleTimeMillis;
        this.executorService = executorService;
        this.hierarchicalShardSyncer = hierarchicalShardSyncer;
        this.metricsFactory = metricsFactory;
    }

    public synchronized boolean syncShardAndLeaseInfo() {
        return this.checkAndSubmitNextTask();
    }

    private synchronized boolean checkAndSubmitNextTask() {
        boolean submittedNewTask = false;
        if (this.future == null || this.future.isCancelled() || this.future.isDone()) {
            if (this.future != null && this.future.isDone()) {
                try {
                    TaskResult result = this.future.get();
                    if (result.getException() != null) {
                        log.error("Caught exception running {} task: ", (Object)this.currentTask.taskType(), (Object)result.getException());
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    log.warn("{} task encountered exception.", (Object)this.currentTask.taskType(), (Object)e);
                }
            }
            this.currentTask = new MetricsCollectingTaskDecorator(new ShardSyncTask(this.shardDetector, this.leaseRefresher, this.initialPositionInStream, this.cleanupLeasesUponShardCompletion, this.ignoreUnexpectedChildShards, this.shardSyncIdleTimeMillis, this.hierarchicalShardSyncer, this.metricsFactory), this.metricsFactory);
            this.future = this.executorService.submit(this.currentTask);
            submittedNewTask = true;
            if (log.isDebugEnabled()) {
                log.debug("Submitted new {} task.", (Object)this.currentTask.taskType());
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Previous {} task still pending.  Not submitting new task.", (Object)this.currentTask.taskType());
        }
        return submittedNewTask;
    }

    @NonNull
    public ShardDetector shardDetector() {
        return this.shardDetector;
    }

    @NonNull
    public LeaseRefresher leaseRefresher() {
        return this.leaseRefresher;
    }

    @NonNull
    public InitialPositionInStreamExtended initialPositionInStream() {
        return this.initialPositionInStream;
    }

    public boolean cleanupLeasesUponShardCompletion() {
        return this.cleanupLeasesUponShardCompletion;
    }

    public boolean ignoreUnexpectedChildShards() {
        return this.ignoreUnexpectedChildShards;
    }

    public long shardSyncIdleTimeMillis() {
        return this.shardSyncIdleTimeMillis;
    }

    @NonNull
    public ExecutorService executorService() {
        return this.executorService;
    }

    @NonNull
    public HierarchicalShardSyncer hierarchicalShardSyncer() {
        return this.hierarchicalShardSyncer;
    }

    @NonNull
    public MetricsFactory metricsFactory() {
        return this.metricsFactory;
    }

    public ConsumerTask currentTask() {
        return this.currentTask;
    }

    public Future<TaskResult> future() {
        return this.future;
    }

    public ShardSyncTaskManager currentTask(ConsumerTask currentTask) {
        this.currentTask = currentTask;
        return this;
    }

    public ShardSyncTaskManager future(Future<TaskResult> future) {
        this.future = future;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShardSyncTaskManager)) {
            return false;
        }
        ShardSyncTaskManager other = (ShardSyncTaskManager)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ShardDetector this$shardDetector = this.shardDetector();
        ShardDetector other$shardDetector = other.shardDetector();
        if (this$shardDetector == null ? other$shardDetector != null : !this$shardDetector.equals(other$shardDetector)) {
            return false;
        }
        LeaseRefresher this$leaseRefresher = this.leaseRefresher();
        LeaseRefresher other$leaseRefresher = other.leaseRefresher();
        if (this$leaseRefresher == null ? other$leaseRefresher != null : !this$leaseRefresher.equals(other$leaseRefresher)) {
            return false;
        }
        InitialPositionInStreamExtended this$initialPositionInStream = this.initialPositionInStream();
        InitialPositionInStreamExtended other$initialPositionInStream = other.initialPositionInStream();
        if (this$initialPositionInStream == null ? other$initialPositionInStream != null : !this$initialPositionInStream.equals(other$initialPositionInStream)) {
            return false;
        }
        if (this.cleanupLeasesUponShardCompletion() != other.cleanupLeasesUponShardCompletion()) {
            return false;
        }
        if (this.ignoreUnexpectedChildShards() != other.ignoreUnexpectedChildShards()) {
            return false;
        }
        if (this.shardSyncIdleTimeMillis() != other.shardSyncIdleTimeMillis()) {
            return false;
        }
        ExecutorService this$executorService = this.executorService();
        ExecutorService other$executorService = other.executorService();
        if (this$executorService == null ? other$executorService != null : !this$executorService.equals(other$executorService)) {
            return false;
        }
        HierarchicalShardSyncer this$hierarchicalShardSyncer = this.hierarchicalShardSyncer();
        HierarchicalShardSyncer other$hierarchicalShardSyncer = other.hierarchicalShardSyncer();
        if (this$hierarchicalShardSyncer == null ? other$hierarchicalShardSyncer != null : !this$hierarchicalShardSyncer.equals(other$hierarchicalShardSyncer)) {
            return false;
        }
        MetricsFactory this$metricsFactory = this.metricsFactory();
        MetricsFactory other$metricsFactory = other.metricsFactory();
        if (this$metricsFactory == null ? other$metricsFactory != null : !this$metricsFactory.equals(other$metricsFactory)) {
            return false;
        }
        ConsumerTask this$currentTask = this.currentTask();
        ConsumerTask other$currentTask = other.currentTask();
        if (this$currentTask == null ? other$currentTask != null : !this$currentTask.equals(other$currentTask)) {
            return false;
        }
        Future<TaskResult> this$future = this.future();
        Future<TaskResult> other$future = other.future();
        return !(this$future == null ? other$future != null : !this$future.equals(other$future));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShardSyncTaskManager;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ShardDetector $shardDetector = this.shardDetector();
        result = result * 59 + ($shardDetector == null ? 43 : $shardDetector.hashCode());
        LeaseRefresher $leaseRefresher = this.leaseRefresher();
        result = result * 59 + ($leaseRefresher == null ? 43 : $leaseRefresher.hashCode());
        InitialPositionInStreamExtended $initialPositionInStream = this.initialPositionInStream();
        result = result * 59 + ($initialPositionInStream == null ? 43 : $initialPositionInStream.hashCode());
        result = result * 59 + (this.cleanupLeasesUponShardCompletion() ? 79 : 97);
        result = result * 59 + (this.ignoreUnexpectedChildShards() ? 79 : 97);
        long $shardSyncIdleTimeMillis = this.shardSyncIdleTimeMillis();
        result = result * 59 + (int)($shardSyncIdleTimeMillis >>> 32 ^ $shardSyncIdleTimeMillis);
        ExecutorService $executorService = this.executorService();
        result = result * 59 + ($executorService == null ? 43 : $executorService.hashCode());
        HierarchicalShardSyncer $hierarchicalShardSyncer = this.hierarchicalShardSyncer();
        result = result * 59 + ($hierarchicalShardSyncer == null ? 43 : $hierarchicalShardSyncer.hashCode());
        MetricsFactory $metricsFactory = this.metricsFactory();
        result = result * 59 + ($metricsFactory == null ? 43 : $metricsFactory.hashCode());
        ConsumerTask $currentTask = this.currentTask();
        result = result * 59 + ($currentTask == null ? 43 : $currentTask.hashCode());
        Future<TaskResult> $future = this.future();
        result = result * 59 + ($future == null ? 43 : $future.hashCode());
        return result;
    }

    public String toString() {
        return "ShardSyncTaskManager(shardDetector=" + this.shardDetector() + ", leaseRefresher=" + this.leaseRefresher() + ", initialPositionInStream=" + this.initialPositionInStream() + ", cleanupLeasesUponShardCompletion=" + this.cleanupLeasesUponShardCompletion() + ", ignoreUnexpectedChildShards=" + this.ignoreUnexpectedChildShards() + ", shardSyncIdleTimeMillis=" + this.shardSyncIdleTimeMillis() + ", executorService=" + this.executorService() + ", hierarchicalShardSyncer=" + this.hierarchicalShardSyncer() + ", metricsFactory=" + this.metricsFactory() + ", currentTask=" + this.currentTask() + ", future=" + this.future() + ")";
    }
}

