/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.lifecycle;

import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.kinesis.annotations.KinesisClientInternalApi;
import software.amazon.kinesis.exceptions.internal.BlockedOnParentShardException;
import software.amazon.kinesis.leases.Lease;
import software.amazon.kinesis.leases.LeaseRefresher;
import software.amazon.kinesis.leases.ShardInfo;
import software.amazon.kinesis.lifecycle.ConsumerTask;
import software.amazon.kinesis.lifecycle.TaskResult;
import software.amazon.kinesis.lifecycle.TaskType;
import software.amazon.kinesis.retrieval.kpl.ExtendedSequenceNumber;

@KinesisClientInternalApi
public class BlockOnParentShardTask
implements ConsumerTask {
    private static final Logger log = LoggerFactory.getLogger(BlockOnParentShardTask.class);
    @NonNull
    private final ShardInfo shardInfo;
    private final LeaseRefresher leaseRefresher;
    private final long parentShardPollIntervalMillis;
    private final TaskType taskType = TaskType.BLOCK_ON_PARENT_SHARDS;

    @Override
    public TaskResult call() {
        Exception exception = null;
        try {
            boolean blockedOnParentShard = false;
            for (String shardId : this.shardInfo.parentShardIds()) {
                Lease lease = this.leaseRefresher.getLease(shardId);
                if (lease != null) {
                    ExtendedSequenceNumber checkpoint = lease.checkpoint();
                    if (checkpoint == null || !checkpoint.equals(ExtendedSequenceNumber.SHARD_END)) {
                        log.debug("Shard {} is not yet done. Its current checkpoint is {}", (Object)shardId, (Object)checkpoint);
                        blockedOnParentShard = true;
                        exception = new BlockedOnParentShardException("Parent shard not yet done");
                        break;
                    }
                    log.debug("Shard {} has been completely processed.", (Object)shardId);
                    continue;
                }
                log.info("No lease found for shard {}. Not blocking on completion of this shard.", (Object)shardId);
            }
            if (!blockedOnParentShard) {
                log.info("No need to block on parents {} of shard {}", this.shardInfo.parentShardIds(), (Object)this.shardInfo.shardId());
                return new TaskResult(null);
            }
        }
        catch (Exception e) {
            log.error("Caught exception when checking for parent shard checkpoint", (Throwable)e);
            exception = e;
        }
        try {
            Thread.sleep(this.parentShardPollIntervalMillis);
        }
        catch (InterruptedException e) {
            log.error("Sleep interrupted when waiting on parent shard(s) of {}", (Object)this.shardInfo.shardId(), (Object)e);
        }
        return new TaskResult(exception);
    }

    @Override
    public TaskType taskType() {
        return this.taskType;
    }

    BlockOnParentShardTask(@NonNull ShardInfo shardInfo, LeaseRefresher leaseRefresher, long parentShardPollIntervalMillis) {
        if (shardInfo == null) {
            throw new NullPointerException("shardInfo");
        }
        this.shardInfo = shardInfo;
        this.leaseRefresher = leaseRefresher;
        this.parentShardPollIntervalMillis = parentShardPollIntervalMillis;
    }
}

