/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.checkpoint;

import java.util.Arrays;
import software.amazon.kinesis.retrieval.kpl.ExtendedSequenceNumber;

public class Checkpoint {
    private final ExtendedSequenceNumber checkpoint;
    private final ExtendedSequenceNumber pendingCheckpoint;
    private final byte[] pendingCheckpointState;

    @Deprecated
    public Checkpoint(ExtendedSequenceNumber checkpoint, ExtendedSequenceNumber pendingCheckpoint) {
        this(checkpoint, pendingCheckpoint, null);
    }

    public Checkpoint(ExtendedSequenceNumber checkpoint, ExtendedSequenceNumber pendingCheckpoint, byte[] pendingCheckpointState) {
        if (checkpoint == null || checkpoint.sequenceNumber().isEmpty()) {
            throw new IllegalArgumentException("Checkpoint cannot be null or empty");
        }
        this.checkpoint = checkpoint;
        this.pendingCheckpoint = pendingCheckpoint;
        this.pendingCheckpointState = pendingCheckpointState;
    }

    public ExtendedSequenceNumber checkpoint() {
        return this.checkpoint;
    }

    public ExtendedSequenceNumber pendingCheckpoint() {
        return this.pendingCheckpoint;
    }

    public byte[] pendingCheckpointState() {
        return this.pendingCheckpointState;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Checkpoint)) {
            return false;
        }
        Checkpoint other = (Checkpoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ExtendedSequenceNumber this$checkpoint = this.checkpoint();
        ExtendedSequenceNumber other$checkpoint = other.checkpoint();
        if (this$checkpoint == null ? other$checkpoint != null : !((Object)this$checkpoint).equals(other$checkpoint)) {
            return false;
        }
        ExtendedSequenceNumber this$pendingCheckpoint = this.pendingCheckpoint();
        ExtendedSequenceNumber other$pendingCheckpoint = other.pendingCheckpoint();
        if (this$pendingCheckpoint == null ? other$pendingCheckpoint != null : !((Object)this$pendingCheckpoint).equals(other$pendingCheckpoint)) {
            return false;
        }
        return Arrays.equals(this.pendingCheckpointState(), other.pendingCheckpointState());
    }

    protected boolean canEqual(Object other) {
        return other instanceof Checkpoint;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExtendedSequenceNumber $checkpoint = this.checkpoint();
        result = result * 59 + ($checkpoint == null ? 43 : ((Object)$checkpoint).hashCode());
        ExtendedSequenceNumber $pendingCheckpoint = this.pendingCheckpoint();
        result = result * 59 + ($pendingCheckpoint == null ? 43 : ((Object)$pendingCheckpoint).hashCode());
        result = result * 59 + Arrays.hashCode(this.pendingCheckpointState());
        return result;
    }

    public String toString() {
        return "Checkpoint(checkpoint=" + this.checkpoint() + ", pendingCheckpoint=" + this.pendingCheckpoint() + ", pendingCheckpointState=" + Arrays.toString(this.pendingCheckpointState()) + ")";
    }
}

