/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.checkpoint;

import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.kinesis.model.Record;
import software.amazon.kinesis.checkpoint.DoesNothingPreparedCheckpointer;
import software.amazon.kinesis.checkpoint.ShardPreparedCheckpointer;
import software.amazon.kinesis.exceptions.InvalidStateException;
import software.amazon.kinesis.exceptions.KinesisClientLibDependencyException;
import software.amazon.kinesis.exceptions.KinesisClientLibException;
import software.amazon.kinesis.exceptions.ShutdownException;
import software.amazon.kinesis.exceptions.ThrottlingException;
import software.amazon.kinesis.leases.ShardInfo;
import software.amazon.kinesis.processor.Checkpointer;
import software.amazon.kinesis.processor.PreparedCheckpointer;
import software.amazon.kinesis.processor.RecordProcessorCheckpointer;
import software.amazon.kinesis.retrieval.kpl.ExtendedSequenceNumber;

public class ShardRecordProcessorCheckpointer
implements RecordProcessorCheckpointer {
    private static final Logger log = LoggerFactory.getLogger(ShardRecordProcessorCheckpointer.class);
    @NonNull
    private final ShardInfo shardInfo;
    @NonNull
    private final Checkpointer checkpointer;
    private ExtendedSequenceNumber lastCheckpointValue;
    private ExtendedSequenceNumber largestPermittedCheckpointValue;
    private ExtendedSequenceNumber sequenceNumberAtShardEnd;

    @Override
    public synchronized void checkpoint() throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException {
        if (log.isDebugEnabled()) {
            log.debug("Checkpointing {}, token {} at largest permitted value {}", new Object[]{ShardInfo.getLeaseKey(this.shardInfo), this.shardInfo.concurrencyToken(), this.largestPermittedCheckpointValue});
        }
        this.advancePosition(this.largestPermittedCheckpointValue);
    }

    @Override
    public synchronized void checkpoint(Record record) throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException, IllegalArgumentException {
        if (record == null) {
            throw new IllegalArgumentException("Could not checkpoint a null record");
        }
        this.checkpoint(record.sequenceNumber(), 0L);
    }

    @Override
    public synchronized void checkpoint(String sequenceNumber) throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException, IllegalArgumentException {
        this.checkpoint(sequenceNumber, 0L);
    }

    @Override
    public synchronized void checkpoint(String sequenceNumber, long subSequenceNumber) throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException, IllegalArgumentException {
        if (subSequenceNumber < 0L) {
            throw new IllegalArgumentException("Could not checkpoint at invalid, negative subsequence number " + subSequenceNumber);
        }
        ExtendedSequenceNumber newCheckpoint = new ExtendedSequenceNumber(sequenceNumber, subSequenceNumber);
        if ((this.lastCheckpointValue == null || this.lastCheckpointValue.compareTo(newCheckpoint) <= 0) && newCheckpoint.compareTo(this.largestPermittedCheckpointValue) <= 0) {
            if (log.isDebugEnabled()) {
                log.debug("Checkpointing {}, token {} at specific extended sequence number {}", new Object[]{ShardInfo.getLeaseKey(this.shardInfo), this.shardInfo.concurrencyToken(), newCheckpoint});
            }
        } else {
            throw new IllegalArgumentException(String.format("Could not checkpoint at extended sequence number %s as it did not fall into acceptable range between the last checkpoint %s and the greatest extended sequence number passed to this record processor %s", newCheckpoint, this.lastCheckpointValue, this.largestPermittedCheckpointValue));
        }
        this.advancePosition(newCheckpoint);
    }

    @Override
    public synchronized PreparedCheckpointer prepareCheckpoint() throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException {
        return this.prepareCheckpoint(this.largestPermittedCheckpointValue.sequenceNumber(), this.largestPermittedCheckpointValue.subSequenceNumber());
    }

    @Override
    public PreparedCheckpointer prepareCheckpoint(byte[] applicationState) throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException {
        return this.prepareCheckpoint(this.largestPermittedCheckpointValue.sequenceNumber(), applicationState);
    }

    @Override
    public PreparedCheckpointer prepareCheckpoint(Record record, byte[] applicationState) throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException {
        if (record == null) {
            throw new IllegalArgumentException("Could not prepare checkpoint a null record");
        }
        return this.prepareCheckpoint(record.sequenceNumber(), 0L, applicationState);
    }

    @Override
    public synchronized PreparedCheckpointer prepareCheckpoint(Record record) throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException {
        return this.prepareCheckpoint(record, null);
    }

    @Override
    public synchronized PreparedCheckpointer prepareCheckpoint(String sequenceNumber) throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException {
        return this.prepareCheckpoint(sequenceNumber, 0L);
    }

    @Override
    public PreparedCheckpointer prepareCheckpoint(String sequenceNumber, byte[] applicationState) throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException, IllegalArgumentException {
        return this.prepareCheckpoint(sequenceNumber, 0L, applicationState);
    }

    @Override
    public synchronized PreparedCheckpointer prepareCheckpoint(String sequenceNumber, long subSequenceNumber) throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException {
        return this.prepareCheckpoint(sequenceNumber, subSequenceNumber, null);
    }

    @Override
    public PreparedCheckpointer prepareCheckpoint(String sequenceNumber, long subSequenceNumber, byte[] applicationState) throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException, IllegalArgumentException {
        if (subSequenceNumber < 0L) {
            throw new IllegalArgumentException("Could not checkpoint at invalid, negative subsequence number " + subSequenceNumber);
        }
        ExtendedSequenceNumber pendingCheckpoint = new ExtendedSequenceNumber(sequenceNumber, subSequenceNumber);
        if ((this.lastCheckpointValue == null || this.lastCheckpointValue.compareTo(pendingCheckpoint) <= 0) && pendingCheckpoint.compareTo(this.largestPermittedCheckpointValue) <= 0) {
            if (log.isDebugEnabled()) {
                log.debug("Preparing checkpoint {}, token {} at specific extended sequence number {}", new Object[]{ShardInfo.getLeaseKey(this.shardInfo), this.shardInfo.concurrencyToken(), pendingCheckpoint});
            }
            return this.doPrepareCheckpoint(pendingCheckpoint, applicationState);
        }
        throw new IllegalArgumentException(String.format("Could not prepare checkpoint at extended sequence number %s as it did not fall into acceptable range between the last checkpoint %s and the greatest extended sequence number passed to this record processor %s", pendingCheckpoint, this.lastCheckpointValue, this.largestPermittedCheckpointValue));
    }

    public synchronized void setInitialCheckpointValue(ExtendedSequenceNumber initialCheckpoint) {
        this.lastCheckpointValue = initialCheckpoint;
    }

    public synchronized void largestPermittedCheckpointValue(ExtendedSequenceNumber largestPermittedCheckpointValue) {
        this.largestPermittedCheckpointValue = largestPermittedCheckpointValue;
    }

    public synchronized void sequenceNumberAtShardEnd(ExtendedSequenceNumber extendedSequenceNumber) {
        this.sequenceNumberAtShardEnd = extendedSequenceNumber;
    }

    void advancePosition(String sequenceNumber) throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException {
        this.advancePosition(new ExtendedSequenceNumber(sequenceNumber));
    }

    void advancePosition(ExtendedSequenceNumber extendedSequenceNumber) throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException {
        ExtendedSequenceNumber checkpointToRecord = extendedSequenceNumber;
        if (this.sequenceNumberAtShardEnd != null && this.sequenceNumberAtShardEnd.equals(extendedSequenceNumber)) {
            checkpointToRecord = ExtendedSequenceNumber.SHARD_END;
        }
        if (extendedSequenceNumber != null && !extendedSequenceNumber.equals(this.lastCheckpointValue)) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Setting {}, token {} checkpoint to {}", new Object[]{ShardInfo.getLeaseKey(this.shardInfo), this.shardInfo.concurrencyToken(), checkpointToRecord});
                }
                this.checkpointer.setCheckpoint(ShardInfo.getLeaseKey(this.shardInfo), checkpointToRecord, this.shardInfo.concurrencyToken());
                this.lastCheckpointValue = checkpointToRecord;
            }
            catch (InvalidStateException | KinesisClientLibDependencyException | ShutdownException | ThrottlingException e) {
                throw e;
            }
            catch (KinesisClientLibException e) {
                log.warn("Caught exception setting checkpoint.", (Throwable)e);
                throw new KinesisClientLibDependencyException("Caught exception while checkpointing", e);
            }
        }
    }

    private PreparedCheckpointer doPrepareCheckpoint(ExtendedSequenceNumber extendedSequenceNumber, byte[] applicationState) throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException {
        ExtendedSequenceNumber newPrepareCheckpoint = extendedSequenceNumber;
        if (this.sequenceNumberAtShardEnd != null && this.sequenceNumberAtShardEnd.equals(extendedSequenceNumber)) {
            newPrepareCheckpoint = ExtendedSequenceNumber.SHARD_END;
        }
        if (newPrepareCheckpoint.equals(this.lastCheckpointValue)) {
            return new DoesNothingPreparedCheckpointer(newPrepareCheckpoint);
        }
        try {
            this.checkpointer.prepareCheckpoint(ShardInfo.getLeaseKey(this.shardInfo), newPrepareCheckpoint, this.shardInfo.concurrencyToken(), applicationState);
        }
        catch (InvalidStateException | KinesisClientLibDependencyException | ShutdownException | ThrottlingException e) {
            throw e;
        }
        catch (KinesisClientLibException e) {
            log.warn("Caught exception setting prepareCheckpoint.", (Throwable)e);
            throw new KinesisClientLibDependencyException("Caught exception while prepareCheckpointing", e);
        }
        ShardPreparedCheckpointer result = new ShardPreparedCheckpointer(newPrepareCheckpoint, this);
        return result;
    }

    public ShardRecordProcessorCheckpointer(@NonNull ShardInfo shardInfo, @NonNull Checkpointer checkpointer) {
        if (shardInfo == null) {
            throw new NullPointerException("shardInfo");
        }
        if (checkpointer == null) {
            throw new NullPointerException("checkpointer");
        }
        this.shardInfo = shardInfo;
        this.checkpointer = checkpointer;
    }

    @Override
    @NonNull
    public Checkpointer checkpointer() {
        return this.checkpointer;
    }

    public ExtendedSequenceNumber lastCheckpointValue() {
        return this.lastCheckpointValue;
    }

    public ExtendedSequenceNumber largestPermittedCheckpointValue() {
        return this.largestPermittedCheckpointValue;
    }
}

