/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.checkpoint.dynamodb;

import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import java.util.UUID;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.kinesis.annotations.KinesisClientInternalApi;
import software.amazon.kinesis.checkpoint.Checkpoint;
import software.amazon.kinesis.exceptions.InvalidStateException;
import software.amazon.kinesis.exceptions.KinesisClientLibDependencyException;
import software.amazon.kinesis.exceptions.KinesisClientLibException;
import software.amazon.kinesis.exceptions.ShutdownException;
import software.amazon.kinesis.exceptions.ThrottlingException;
import software.amazon.kinesis.exceptions.internal.KinesisClientLibIOException;
import software.amazon.kinesis.leases.Lease;
import software.amazon.kinesis.leases.LeaseCoordinator;
import software.amazon.kinesis.leases.LeaseRefresher;
import software.amazon.kinesis.leases.exceptions.DependencyException;
import software.amazon.kinesis.leases.exceptions.ProvisionedThroughputException;
import software.amazon.kinesis.processor.Checkpointer;
import software.amazon.kinesis.retrieval.kpl.ExtendedSequenceNumber;

@KinesisClientInternalApi
public class DynamoDBCheckpointer
implements Checkpointer {
    private static final Logger log = LoggerFactory.getLogger(DynamoDBCheckpointer.class);
    @NonNull
    private final LeaseCoordinator leaseCoordinator;
    @NonNull
    private final LeaseRefresher leaseRefresher;
    private String operation;

    @Override
    public void setCheckpoint(String leaseKey, ExtendedSequenceNumber checkpointValue, String concurrencyToken) throws KinesisClientLibException {
        try {
            boolean wasSuccessful = this.setCheckpoint(leaseKey, checkpointValue, UUID.fromString(concurrencyToken));
            if (!wasSuccessful) {
                throw new ShutdownException("Can't update checkpoint - instance doesn't hold the lease for this shard");
            }
        }
        catch (ProvisionedThroughputException e) {
            throw new ThrottlingException("Got throttled while updating checkpoint.", e);
        }
        catch (software.amazon.kinesis.leases.exceptions.InvalidStateException e) {
            String message = "Unable to save checkpoint for shardId " + leaseKey;
            log.error(message, (Throwable)e);
            throw new InvalidStateException(message, e);
        }
        catch (DependencyException e) {
            throw new KinesisClientLibDependencyException("Unable to save checkpoint for shardId " + leaseKey, e);
        }
    }

    @Override
    public ExtendedSequenceNumber getCheckpoint(String leaseKey) throws KinesisClientLibException {
        try {
            return this.leaseRefresher.getLease(leaseKey).checkpoint();
        }
        catch (DependencyException | software.amazon.kinesis.leases.exceptions.InvalidStateException | ProvisionedThroughputException e) {
            String message = "Unable to fetch checkpoint for shardId " + leaseKey;
            log.error(message, (Throwable)e);
            throw new KinesisClientLibIOException(message, e);
        }
    }

    @Override
    public Checkpoint getCheckpointObject(String leaseKey) throws KinesisClientLibException {
        try {
            Lease lease = this.leaseRefresher.getLease(leaseKey);
            log.debug("[{}] Retrieved lease => {}", (Object)leaseKey, (Object)lease);
            return new Checkpoint(lease.checkpoint(), lease.pendingCheckpoint(), lease.pendingCheckpointState());
        }
        catch (DependencyException | software.amazon.kinesis.leases.exceptions.InvalidStateException | ProvisionedThroughputException e) {
            String message = "Unable to fetch checkpoint for shardId " + leaseKey;
            log.error(message, (Throwable)e);
            throw new KinesisClientLibIOException(message, e);
        }
    }

    @Override
    public void prepareCheckpoint(String leaseKey, ExtendedSequenceNumber pendingCheckpoint, String concurrencyToken) throws KinesisClientLibException {
        this.prepareCheckpoint(leaseKey, pendingCheckpoint, concurrencyToken, null);
    }

    @Override
    public void prepareCheckpoint(String leaseKey, ExtendedSequenceNumber pendingCheckpoint, String concurrencyToken, byte[] pendingCheckpointState) throws KinesisClientLibException {
        try {
            boolean wasSuccessful = this.prepareCheckpoint(leaseKey, pendingCheckpoint, UUID.fromString(concurrencyToken), pendingCheckpointState);
            if (!wasSuccessful) {
                throw new ShutdownException("Can't prepare checkpoint - instance doesn't hold the lease for this shard");
            }
        }
        catch (ProvisionedThroughputException e) {
            throw new ThrottlingException("Got throttled while preparing checkpoint.", e);
        }
        catch (software.amazon.kinesis.leases.exceptions.InvalidStateException e) {
            String message = "Unable to prepare checkpoint for shardId " + leaseKey;
            log.error(message, (Throwable)e);
            throw new InvalidStateException(message, e);
        }
        catch (DependencyException e) {
            throw new KinesisClientLibDependencyException("Unable to prepare checkpoint for shardId " + leaseKey, e);
        }
    }

    @VisibleForTesting
    public boolean setCheckpoint(String leaseKey, ExtendedSequenceNumber checkpoint, UUID concurrencyToken) throws DependencyException, software.amazon.kinesis.leases.exceptions.InvalidStateException, ProvisionedThroughputException {
        Lease lease = this.leaseCoordinator.getCurrentlyHeldLease(leaseKey);
        if (lease == null) {
            log.info("Worker {} could not update checkpoint for shard {} because it does not hold the lease", (Object)this.leaseCoordinator.workerIdentifier(), (Object)leaseKey);
            return false;
        }
        lease.checkpoint(checkpoint);
        lease.pendingCheckpoint(null);
        lease.pendingCheckpointState(null);
        lease.ownerSwitchesSinceCheckpoint(0L);
        return this.leaseCoordinator.updateLease(lease, concurrencyToken, this.operation, leaseKey);
    }

    boolean prepareCheckpoint(String leaseKey, ExtendedSequenceNumber pendingCheckpoint, UUID concurrencyToken, byte[] pendingCheckpointState) throws DependencyException, software.amazon.kinesis.leases.exceptions.InvalidStateException, ProvisionedThroughputException {
        Lease lease = this.leaseCoordinator.getCurrentlyHeldLease(leaseKey);
        if (lease == null) {
            log.info("Worker {} could not prepare checkpoint for shard {} because it does not hold the lease", (Object)this.leaseCoordinator.workerIdentifier(), (Object)leaseKey);
            return false;
        }
        lease.pendingCheckpoint(Objects.requireNonNull(pendingCheckpoint, "pendingCheckpoint should not be null"));
        lease.pendingCheckpointState(pendingCheckpointState);
        return this.leaseCoordinator.updateLease(lease, concurrencyToken, this.operation, leaseKey);
    }

    @Override
    public void operation(@NonNull String operation) {
        if (operation == null) {
            throw new NullPointerException("operation");
        }
        this.operation = operation;
    }

    @Override
    public String operation() {
        return this.operation;
    }

    public DynamoDBCheckpointer(@NonNull LeaseCoordinator leaseCoordinator, @NonNull LeaseRefresher leaseRefresher) {
        if (leaseCoordinator == null) {
            throw new NullPointerException("leaseCoordinator");
        }
        if (leaseRefresher == null) {
            throw new NullPointerException("leaseRefresher");
        }
        this.leaseCoordinator = leaseCoordinator;
        this.leaseRefresher = leaseRefresher;
    }
}

