/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.common;

public class LeaseCleanupConfig {
    private final long leaseCleanupIntervalMillis;
    private final long completedLeaseCleanupIntervalMillis;
    private final long garbageLeaseCleanupIntervalMillis;

    LeaseCleanupConfig(long leaseCleanupIntervalMillis, long completedLeaseCleanupIntervalMillis, long garbageLeaseCleanupIntervalMillis) {
        this.leaseCleanupIntervalMillis = leaseCleanupIntervalMillis;
        this.completedLeaseCleanupIntervalMillis = completedLeaseCleanupIntervalMillis;
        this.garbageLeaseCleanupIntervalMillis = garbageLeaseCleanupIntervalMillis;
    }

    public static LeaseCleanupConfigBuilder builder() {
        return new LeaseCleanupConfigBuilder();
    }

    public long leaseCleanupIntervalMillis() {
        return this.leaseCleanupIntervalMillis;
    }

    public long completedLeaseCleanupIntervalMillis() {
        return this.completedLeaseCleanupIntervalMillis;
    }

    public long garbageLeaseCleanupIntervalMillis() {
        return this.garbageLeaseCleanupIntervalMillis;
    }

    public static class LeaseCleanupConfigBuilder {
        private long leaseCleanupIntervalMillis;
        private long completedLeaseCleanupIntervalMillis;
        private long garbageLeaseCleanupIntervalMillis;

        LeaseCleanupConfigBuilder() {
        }

        public LeaseCleanupConfigBuilder leaseCleanupIntervalMillis(long leaseCleanupIntervalMillis) {
            this.leaseCleanupIntervalMillis = leaseCleanupIntervalMillis;
            return this;
        }

        public LeaseCleanupConfigBuilder completedLeaseCleanupIntervalMillis(long completedLeaseCleanupIntervalMillis) {
            this.completedLeaseCleanupIntervalMillis = completedLeaseCleanupIntervalMillis;
            return this;
        }

        public LeaseCleanupConfigBuilder garbageLeaseCleanupIntervalMillis(long garbageLeaseCleanupIntervalMillis) {
            this.garbageLeaseCleanupIntervalMillis = garbageLeaseCleanupIntervalMillis;
            return this;
        }

        public LeaseCleanupConfig build() {
            return new LeaseCleanupConfig(this.leaseCleanupIntervalMillis, this.completedLeaseCleanupIntervalMillis, this.garbageLeaseCleanupIntervalMillis);
        }

        public String toString() {
            return "LeaseCleanupConfig.LeaseCleanupConfigBuilder(leaseCleanupIntervalMillis=" + this.leaseCleanupIntervalMillis + ", completedLeaseCleanupIntervalMillis=" + this.completedLeaseCleanupIntervalMillis + ", garbageLeaseCleanupIntervalMillis=" + this.garbageLeaseCleanupIntervalMillis + ")";
        }
    }
}

