/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.coordinator;

import java.time.Instant;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.kinesis.coordinator.LeaderDecider;
import software.amazon.kinesis.leases.Lease;
import software.amazon.kinesis.leases.LeaseRefresher;
import software.amazon.kinesis.leases.exceptions.DependencyException;
import software.amazon.kinesis.leases.exceptions.InvalidStateException;
import software.amazon.kinesis.leases.exceptions.ProvisionedThroughputException;

class DeterministicShuffleShardSyncLeaderDecider
implements LeaderDecider {
    private static final Logger log = LoggerFactory.getLogger(DeterministicShuffleShardSyncLeaderDecider.class);
    static final int DETERMINISTIC_SHUFFLE_SEED = 1947;
    private static final long ELECTION_INITIAL_DELAY_MILLIS = 60000L;
    private static final long ELECTION_SCHEDULING_INTERVAL_MILLIS = 300000L;
    private static final int AWAIT_TERMINATION_MILLIS = 5000;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final LeaseRefresher leaseRefresher;
    private final int numPeriodicShardSyncWorkers;
    private final ScheduledExecutorService leaderElectionThreadPool;
    private volatile Set<String> leaders;

    DeterministicShuffleShardSyncLeaderDecider(LeaseRefresher leaseRefresher, ScheduledExecutorService leaderElectionThreadPool, int numPeriodicShardSyncWorkers) {
        this.leaseRefresher = leaseRefresher;
        this.leaderElectionThreadPool = leaderElectionThreadPool;
        this.numPeriodicShardSyncWorkers = numPeriodicShardSyncWorkers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void electLeaders() {
        try {
            log.debug("Started leader election at: " + Instant.now());
            List<Lease> leases = this.leaseRefresher.listLeases();
            List uniqueHosts = leases.stream().map(Lease::leaseOwner).filter(owner -> owner != null).distinct().sorted().collect(Collectors.toList());
            Collections.shuffle(uniqueHosts, new Random(1947L));
            int numShardSyncWorkers = Math.min(uniqueHosts.size(), this.numPeriodicShardSyncWorkers);
            this.readWriteLock.writeLock().lock();
            this.leaders = new HashSet(uniqueHosts.subList(0, numShardSyncWorkers));
            log.info("Elected leaders: " + String.join((CharSequence)", ", this.leaders));
            log.debug("Completed leader election at: " + Instant.now());
        }
        catch (DependencyException | InvalidStateException | ProvisionedThroughputException e) {
            log.error("Exception occurred while trying to fetch all leases for leader election", (Throwable)e);
        }
        catch (Throwable t) {
            log.error("Unknown exception during leader election.", t);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    private boolean isWorkerLeaderForShardSync(String workerId) {
        return CollectionUtils.isNullOrEmpty(this.leaders) || this.leaders.contains(workerId);
    }

    @Override
    public synchronized Boolean isLeader(String workerId) {
        if (this.executeConditionCheckWithReadLock(() -> CollectionUtils.isNullOrEmpty(this.leaders))) {
            this.electLeaders();
            this.leaderElectionThreadPool.scheduleWithFixedDelay(this::electLeaders, 60000L, 300000L, TimeUnit.MILLISECONDS);
        }
        return this.executeConditionCheckWithReadLock(() -> this.isWorkerLeaderForShardSync(workerId));
    }

    @Override
    public synchronized void shutdown() {
        try {
            this.leaderElectionThreadPool.shutdown();
            if (this.leaderElectionThreadPool.awaitTermination(5000L, TimeUnit.MILLISECONDS)) {
                log.info("Successfully stopped leader election on the worker");
            } else {
                this.leaderElectionThreadPool.shutdownNow();
                log.info(String.format("Stopped leader election thread after awaiting termination for %d milliseconds", 5000));
            }
        }
        catch (InterruptedException e) {
            log.debug("Encountered InterruptedException while awaiting leader election threadPool termination");
        }
    }

    private boolean executeConditionCheckWithReadLock(BooleanSupplier action) {
        try {
            this.readWriteLock.readLock().lock();
            boolean bl = action.getAsBoolean();
            return bl;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }
}

