/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.leases;

import com.google.common.base.Verify;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;
import software.amazon.kinesis.leases.Lease;

public class MultiStreamLease
extends Lease {
    @NonNull
    private String streamIdentifier;
    @NonNull
    private String shardId;

    public MultiStreamLease(MultiStreamLease other) {
        super(other);
        this.streamIdentifier(other.streamIdentifier);
        this.shardId(other.shardId);
    }

    @Override
    public void update(Lease other) {
        MultiStreamLease casted = MultiStreamLease.validateAndCast(other);
        super.update(casted);
        this.streamIdentifier(casted.streamIdentifier);
        this.shardId(casted.shardId);
    }

    public static String getLeaseKey(String streamIdentifier, String shardId) {
        Verify.verifyNotNull((Object)streamIdentifier, (String)"streamIdentifier should not be null", (Object[])new Object[0]);
        Verify.verifyNotNull((Object)shardId, (String)"shardId should not be null", (Object[])new Object[0]);
        return streamIdentifier + ":" + shardId;
    }

    @Override
    public MultiStreamLease copy() {
        return new MultiStreamLease(this);
    }

    public static MultiStreamLease validateAndCast(Lease lease) {
        Validate.isInstanceOf(MultiStreamLease.class, (Object)lease);
        return (MultiStreamLease)lease;
    }

    public MultiStreamLease streamIdentifier(@NonNull String streamIdentifier) {
        if (streamIdentifier == null) {
            throw new NullPointerException("streamIdentifier");
        }
        this.streamIdentifier = streamIdentifier;
        return this;
    }

    public MultiStreamLease shardId(@NonNull String shardId) {
        if (shardId == null) {
            throw new NullPointerException("shardId");
        }
        this.shardId = shardId;
        return this;
    }

    public MultiStreamLease() {
    }

    @NonNull
    public String streamIdentifier() {
        return this.streamIdentifier;
    }

    @NonNull
    public String shardId() {
        return this.shardId;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiStreamLease)) {
            return false;
        }
        MultiStreamLease other = (MultiStreamLease)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$streamIdentifier = this.streamIdentifier();
        String other$streamIdentifier = other.streamIdentifier();
        if (this$streamIdentifier == null ? other$streamIdentifier != null : !this$streamIdentifier.equals(other$streamIdentifier)) {
            return false;
        }
        String this$shardId = this.shardId();
        String other$shardId = other.shardId();
        return !(this$shardId == null ? other$shardId != null : !this$shardId.equals(other$shardId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MultiStreamLease;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $streamIdentifier = this.streamIdentifier();
        result = result * 59 + ($streamIdentifier == null ? 43 : $streamIdentifier.hashCode());
        String $shardId = this.shardId();
        result = result * 59 + ($shardId == null ? 43 : $shardId.hashCode());
        return result;
    }
}

