/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.leases.exceptions;

import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import software.amazon.kinesis.common.StreamIdentifier;
import software.amazon.kinesis.leases.Lease;
import software.amazon.kinesis.leases.ShardDetector;
import software.amazon.kinesis.leases.ShardInfo;

public final class LeasePendingDeletion {
    private final StreamIdentifier streamIdentifier;
    private final Lease lease;
    private final ShardInfo shardInfo;
    private final ShardDetector shardDetector;

    public Set<String> getChildShardsFromService() throws InterruptedException, ExecutionException, TimeoutException {
        return this.shardDetector.getChildShards(this.shardInfo.shardId()).stream().map(c -> c.shardId()).collect(Collectors.toSet());
    }

    public LeasePendingDeletion(StreamIdentifier streamIdentifier, Lease lease, ShardInfo shardInfo, ShardDetector shardDetector) {
        this.streamIdentifier = streamIdentifier;
        this.lease = lease;
        this.shardInfo = shardInfo;
        this.shardDetector = shardDetector;
    }

    public StreamIdentifier streamIdentifier() {
        return this.streamIdentifier;
    }

    public Lease lease() {
        return this.lease;
    }

    public ShardInfo shardInfo() {
        return this.shardInfo;
    }

    public ShardDetector shardDetector() {
        return this.shardDetector;
    }

    public String toString() {
        return "LeasePendingDeletion(streamIdentifier=" + this.streamIdentifier() + ", lease=" + this.lease() + ", shardInfo=" + this.shardInfo() + ", shardDetector=" + this.shardDetector() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LeasePendingDeletion)) {
            return false;
        }
        LeasePendingDeletion other = (LeasePendingDeletion)o;
        StreamIdentifier this$streamIdentifier = this.streamIdentifier();
        StreamIdentifier other$streamIdentifier = other.streamIdentifier();
        if (this$streamIdentifier == null ? other$streamIdentifier != null : !((Object)this$streamIdentifier).equals(other$streamIdentifier)) {
            return false;
        }
        Lease this$lease = this.lease();
        Lease other$lease = other.lease();
        if (this$lease == null ? other$lease != null : !((Object)this$lease).equals(other$lease)) {
            return false;
        }
        ShardInfo this$shardInfo = this.shardInfo();
        ShardInfo other$shardInfo = other.shardInfo();
        if (this$shardInfo == null ? other$shardInfo != null : !((Object)this$shardInfo).equals(other$shardInfo)) {
            return false;
        }
        ShardDetector this$shardDetector = this.shardDetector();
        ShardDetector other$shardDetector = other.shardDetector();
        return !(this$shardDetector == null ? other$shardDetector != null : !this$shardDetector.equals(other$shardDetector));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StreamIdentifier $streamIdentifier = this.streamIdentifier();
        result = result * 59 + ($streamIdentifier == null ? 43 : ((Object)$streamIdentifier).hashCode());
        Lease $lease = this.lease();
        result = result * 59 + ($lease == null ? 43 : ((Object)$lease).hashCode());
        ShardInfo $shardInfo = this.shardInfo();
        result = result * 59 + ($shardInfo == null ? 43 : ((Object)$shardInfo).hashCode());
        ShardDetector $shardDetector = this.shardDetector();
        result = result * 59 + ($shardDetector == null ? 43 : $shardDetector.hashCode());
        return result;
    }
}

